/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.gnu;

import io.smallrye.common.constraint.Assert;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.qbicc.machine.tool.CCompilerInvoker;
import org.qbicc.machine.tool.gnu.AbstractGccInvoker;
import org.qbicc.machine.tool.gnu.GccToolChainImpl;
import org.qbicc.machine.tool.gnu.GnuCCompilerInvoker;
import org.qbicc.machine.tool.process.InputSource;

final class GnuCCompilerInvokerImpl
extends AbstractGccInvoker
implements GnuCCompilerInvoker {
    private final List<Path> includePaths = new ArrayList<Path>(1);
    private final List<String> definedSymbols = new ArrayList<String>(2);
    private InputSource inputSource = InputSource.empty();
    private Path outputPath = TMP.resolve("qbicc-output." + this.getTool().getPlatform().getObjectType().objectSuffix());
    private CCompilerInvoker.SourceLanguage sourceLanguage = CCompilerInvoker.SourceLanguage.C;

    GnuCCompilerInvokerImpl(GccToolChainImpl tool) {
        super(tool);
    }

    public void addIncludePath(Path path) {
        this.includePaths.add((Path)Assert.checkNotNullParam((String)"path", (Object)path));
    }

    public int getIncludePathCount() {
        return this.includePaths.size();
    }

    public Path getIncludePath(int index) throws IndexOutOfBoundsException {
        return this.includePaths.get(index);
    }

    public void addDefinedSymbol(String name, String value) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"value", (Object)value);
        this.definedSymbols.add(name);
        this.definedSymbols.add(value);
    }

    public int getDefinedSymbolCount() {
        return this.definedSymbols.size() >>> 1;
    }

    public String getDefinedSymbol(int index) throws IndexOutOfBoundsException {
        return this.definedSymbols.get(index << 1);
    }

    public String getDefinedSymbolValue(int index) throws IndexOutOfBoundsException {
        return this.definedSymbols.get((index << 1) + 1);
    }

    public void setSource(InputSource source) {
        this.inputSource = (InputSource)Assert.checkNotNullParam((String)"source", (Object)source);
    }

    @Override
    public InputSource getSource() {
        return this.inputSource;
    }

    public void setOutputPath(Path path) {
        this.outputPath = (Path)Assert.checkNotNullParam((String)"path", (Object)path);
    }

    public CCompilerInvoker.SourceLanguage getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(CCompilerInvoker.SourceLanguage sourceLanguage) {
        this.sourceLanguage = (CCompilerInvoker.SourceLanguage)Assert.checkNotNullParam((String)"sourceLanguage", (Object)sourceLanguage);
    }

    public Path getOutputPath() throws IllegalArgumentException {
        return this.outputPath;
    }

    @Override
    void addArguments(List<String> cmd) {
        if (this.getTool().isM32()) {
            cmd.add("-m32");
        }
        Collections.addAll(cmd, "-std=gnu11", "-finput-charset=UTF-8", "-pipe");
        for (Path includePath : this.includePaths) {
            cmd.add("-I" + includePath.toString());
        }
        for (int i = 0; i < this.definedSymbols.size(); i += 2) {
            String key = this.definedSymbols.get(i);
            String val = this.definedSymbols.get(i + 1);
            if (val.equals("1")) {
                cmd.add("-D" + key);
                continue;
            }
            cmd.add("-D" + key + "=" + val);
        }
        Collections.addAll(cmd, "-c", "-x", this.sourceLanguage == CCompilerInvoker.SourceLanguage.ASM ? "assembler" : "c", "-o", this.getOutputPath().toString(), "-");
    }
}

