/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.gnu;

import io.smallrye.common.constraint.Assert;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.qbicc.machine.tool.gnu.AbstractGccInvoker;
import org.qbicc.machine.tool.gnu.GccToolChainImpl;
import org.qbicc.machine.tool.gnu.GnuLinkerInvoker;

final class GnuLinkerInvokerImpl
extends AbstractGccInvoker
implements GnuLinkerInvoker {
    private final List<Path> libraryPaths = new ArrayList<Path>(4);
    private final List<String> libraries = new ArrayList<String>(4);
    private final List<Path> objectFiles = new ArrayList<Path>(4);
    private Path outputPath = TMP.resolve("qbicc-output-image");
    private boolean isPie = false;

    GnuLinkerInvokerImpl(GccToolChainImpl tool) {
        super(tool);
    }

    public void addLibraryPath(Path path) {
        this.libraryPaths.add((Path)Assert.checkNotNullParam((String)"path", (Object)path));
    }

    public int getLibraryPathCount() {
        return this.libraryPaths.size();
    }

    public Path getLibraryPath(int index) throws IndexOutOfBoundsException {
        return this.libraryPaths.get(index);
    }

    public void addLibrary(String name) {
        this.libraries.add((String)Assert.checkNotNullParam((String)"name", (Object)name));
    }

    public int getLibraryCount() {
        return this.libraries.size();
    }

    public String getLibrary(int index) throws IndexOutOfBoundsException {
        return this.libraries.get(index);
    }

    public void addObjectFile(Path path) {
        this.objectFiles.add((Path)Assert.checkNotNullParam((String)"path", (Object)path));
    }

    public int getObjectFileCount() {
        return this.objectFiles.size();
    }

    public Path getObjectFile(int index) throws IndexOutOfBoundsException {
        return this.objectFiles.get(index);
    }

    public void setOutputPath(Path path) {
        this.outputPath = (Path)Assert.checkNotNullParam((String)"path", (Object)path);
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    public void setIsPie(boolean isPie) {
        this.isPie = isPie;
    }

    public boolean getIsPie() {
        return this.isPie;
    }

    @Override
    void addArguments(List<String> cmd) {
        if (this.isPie) {
            cmd.add("-pie");
        } else {
            cmd.add("-no-pie");
        }
        for (Path libraryPath : this.libraryPaths) {
            cmd.add("-L" + libraryPath.toString());
        }
        for (Path objectFile : this.objectFiles) {
            cmd.add(objectFile.toString());
        }
        for (String library : this.libraries) {
            cmd.add("-l" + library);
        }
        cmd.add("-o");
        cmd.add(this.outputPath.toString());
    }
}

