/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.gnu;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qbicc.machine.arch.Cpu;
import org.qbicc.machine.arch.OS;
import org.qbicc.machine.arch.Platform;
import org.qbicc.machine.tool.Tool;
import org.qbicc.machine.tool.ToolProvider;
import org.qbicc.machine.tool.gnu.GccToolChainImpl;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;

public class GnuToolProvider
implements ToolProvider {
    static final Pattern TARGET_PATTERN = Pattern.compile("^Target:\\s+(x86_64|arm(?:v[67][^-]*)?|i[3-6]86|aarch64|powerpc64)(?:-(redhat|apple|ibm|pc|unknown))?-(linux|darwin)(?:-(gnu(?:eabi(?:hf)?)?))?");
    static final Pattern VERSION_PATTERN = Pattern.compile("^gcc version (\\S+)");

    public <T extends Tool> Iterable<T> findTools(Class<T> type, Platform platform, Path path) {
        ArrayList list = new ArrayList();
        if (type.isAssignableFrom(GccToolChainImpl.class)) {
            String cpuSimpleName = platform.getCpu().getSimpleName();
            String osName = platform.getOs().getName();
            String abiName = platform.getAbi().getName();
            this.tryGcc(type, platform, list, path);
            return list;
        }
        return List.of();
    }

    private <T extends Tool> void tryGcc(Class<T> type, Platform platform, ArrayList<T> list, Path path) {
        if (path != null && Files.isExecutable(path)) {
            class Result {
                String version;
                boolean m32;
                boolean match;

                Result() {
                }
            }
            Result res = new Result();
            OutputDestination dest = OutputDestination.of(r -> {
                try (BufferedReader br = new BufferedReader((Reader)r);){
                    String line;
                    while ((line = br.readLine()) != null) {
                        Matcher matcher = TARGET_PATTERN.matcher(line);
                        if (matcher.find()) {
                            String cpuStr = matcher.group(1);
                            String osStr = matcher.group(3);
                            String abiStr = matcher.group(4);
                            Cpu cpu = Cpu.forName((String)cpuStr);
                            boolean m32 = platform.getCpu().equals(Cpu.X86) && cpu.equals(Cpu.X86_64);
                            boolean cpuMatch = cpu.equals(platform.getCpu()) || m32;
                            OS os = OS.forName((String)osStr);
                            boolean osMatch = os.equals(platform.getOs());
                            res.match = cpuMatch && osMatch;
                            res.m32 = m32;
                            continue;
                        }
                        matcher = VERSION_PATTERN.matcher(line);
                        if (!matcher.find()) continue;
                        res.version = matcher.group(1);
                    }
                }
            }, (Charset)StandardCharsets.UTF_8);
            ProcessBuilder pb = new ProcessBuilder(path.toString(), "-###");
            try {
                InputSource.empty().transferTo(OutputDestination.of((ProcessBuilder)pb, (OutputDestination)dest, (OutputDestination)OutputDestination.discarding()));
            }
            catch (IOException e) {
                return;
            }
            if (res.match && res.version != null) {
                GccToolChainImpl gcc = new GccToolChainImpl(path, platform, res.version, res.m32);
                list.add((Tool)type.cast(gcc));
            }
        }
    }
}

