/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.tool.llvm;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.version.VersionScheme;
import java.nio.file.Path;
import java.util.List;
import org.qbicc.machine.arch.Platform;
import org.qbicc.tool.llvm.AbstractLlvmInvoker;
import org.qbicc.tool.llvm.LlcInvoker;
import org.qbicc.tool.llvm.LlcOptLevel;
import org.qbicc.tool.llvm.LlvmToolChain;
import org.qbicc.tool.llvm.LlvmToolChainImpl;
import org.qbicc.tool.llvm.OutputFormat;
import org.qbicc.tool.llvm.RelocationModel;

final class LlcInvokerImpl
extends AbstractLlvmInvoker
implements LlcInvoker {
    private boolean opaquePointers = false;
    private LlcOptLevel optLevel = LlcOptLevel.O2;
    private OutputFormat outputFormat = OutputFormat.OBJ;
    private RelocationModel relocationModel = RelocationModel.Static;
    private List<String> options = List.of();

    LlcInvokerImpl(LlvmToolChainImpl tool, Path path) {
        super(tool, path);
    }

    @Override
    public LlvmToolChain getTool() {
        return super.getTool();
    }

    @Override
    public void setOptimizationLevel(LlcOptLevel level) {
        this.optLevel = (LlcOptLevel)((Object)Assert.checkNotNullParam((String)"level", (Object)((Object)level)));
    }

    @Override
    public LlcOptLevel getOptimizationLevel() {
        return this.optLevel;
    }

    @Override
    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = (OutputFormat)((Object)Assert.checkNotNullParam((String)"outputFormat", (Object)((Object)outputFormat)));
    }

    @Override
    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public void setRelocationModel(RelocationModel relocationModel) {
        this.relocationModel = (RelocationModel)((Object)Assert.checkNotNullParam((String)"relocationModel", (Object)((Object)relocationModel)));
    }

    @Override
    public RelocationModel getRelocationModel() {
        return this.relocationModel;
    }

    @Override
    public void setOpaquePointers(boolean opaquePointers) {
        this.opaquePointers = opaquePointers;
    }

    @Override
    void addArguments(List<String> cmd) {
        LlvmToolChain tool = this.getTool();
        String llvmVersion = tool.getVersion();
        if (this.opaquePointers) {
            if (VersionScheme.BASIC.compare(llvmVersion, "15") < 0) {
                if (VersionScheme.BASIC.compare(llvmVersion, "14") >= 0) {
                    cmd.add("--opaque-pointers");
                } else {
                    cmd.add("--force-opaque-pointers");
                }
            }
        } else {
            if (VersionScheme.BASIC.compare(llvmVersion, "16") >= 0) {
                throw new IllegalArgumentException("Opaque pointers cannot be disabled on LLVM 16 or later");
            }
            if (VersionScheme.BASIC.compare(llvmVersion, "15") >= 0) {
                cmd.add("--opaque-pointers=0");
            }
        }
        Platform platform = tool.getPlatform();
        cmd.add("-mtriple=" + platform.getCpu().toString() + "-" + platform.getOs().toString() + "-" + platform.getAbi().toString());
        cmd.add("--relocation-model=" + this.relocationModel.value);
        cmd.add("-" + this.optLevel.name());
        cmd.add("--filetype=" + this.outputFormat.toOptionString());
        cmd.add("--dwarf-version=4");
        if (VersionScheme.BASIC.compare(this.getTool().getVersion(), "14") >= 0) {
            cmd.add("--strict-dwarf");
        }
        cmd.addAll(this.options);
    }

    @Override
    public void setOptions(List<String> options) {
        this.options = options;
    }
}

