/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.tool.llvm;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.qbicc.machine.tool.ToolInvoker;
import org.qbicc.machine.tool.ToolMessageHandler;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;
import org.qbicc.tool.llvm.LlvmObjCopyInvoker;
import org.qbicc.tool.llvm.LlvmToolChain;

public final class LlvmObjCopyInvokerImpl
implements LlvmObjCopyInvoker {
    private final LlvmToolChain toolChain;
    private final Path execPath;
    private final List<String> args = new ArrayList<String>();
    private Path objectFilePath;
    private ToolMessageHandler messageHandler = ToolMessageHandler.DISCARDING;
    private OutputDestination destination = OutputDestination.discarding();
    private Path workingDirectory;

    LlvmObjCopyInvokerImpl(LlvmToolChain toolChain, Path execPath) {
        this.toolChain = toolChain;
        this.execPath = execPath;
    }

    public void setMessageHandler(ToolMessageHandler messageHandler) {
        this.messageHandler = (ToolMessageHandler)Assert.checkNotNullParam((String)"messageHandler", (Object)messageHandler);
    }

    public ToolMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public Path getPath() {
        return this.execPath;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Path workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void invoke() throws IOException {
        InputSource.empty().transferTo(this.invokerAsDestination());
    }

    @Override
    public void setObjectFilePath(Path objectFilePath) {
        this.objectFilePath = objectFilePath;
    }

    @Override
    public void removeSection(String sectionName) {
        this.args.add("--remove-section=" + sectionName);
    }

    OutputDestination invokerAsDestination() {
        StringBuilder b = new StringBuilder();
        OutputDestination errorHandler = OutputDestination.of((Appendable)b, (Charset)StandardCharsets.UTF_8);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.execPath.toString());
        cmd.addAll(this.args);
        cmd.add(this.objectFilePath.toString());
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(cmd);
        if (this.getWorkingDirectory() != null) {
            pb.directory(this.getWorkingDirectory().toFile());
        }
        pb.environment().put("LC_ALL", "C");
        pb.environment().put("LANG", "C");
        return OutputDestination.of((ProcessBuilder)pb, (OutputDestination)errorHandler, (OutputDestination)this.destination, p -> {
            ToolMessageHandler.Level level;
            int ev = p.exitValue();
            ToolMessageHandler.Level level2 = level = ev == 0 ? ToolMessageHandler.Level.WARNING : ToolMessageHandler.Level.ERROR;
            if (!b.isEmpty()) {
                if (ev != 0) {
                    b.append("\n(exit code = ").append(ev).append(')');
                }
                this.messageHandler.handleMessage((ToolInvoker)this, level, this.objectFilePath.toString(), -1, -1, b.toString());
            } else if (ev != 0) {
                this.messageHandler.handleMessage((ToolInvoker)this, level, this.objectFilePath.toString(), -1, -1, "Tool execution failed (exit code = " + ev + ")");
            }
        });
    }

    @Override
    public LlvmToolChain getTool() {
        return this.toolChain;
    }
}

