/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.tool.llvm;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import org.qbicc.machine.arch.Platform;
import org.qbicc.machine.tool.Tool;
import org.qbicc.machine.tool.ToolUtil;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;
import org.qbicc.tool.llvm.LlcInvoker;
import org.qbicc.tool.llvm.Llvm;
import org.qbicc.tool.llvm.LlvmObjCopyInvoker;
import org.qbicc.tool.llvm.LlvmToolChainImpl;
import org.qbicc.tool.llvm.OptInvoker;

public interface LlvmToolChain
extends Tool {
    default public String getToolName() {
        return "llvm";
    }

    default public String getImplementationName() {
        return "llvm";
    }

    public LlcInvoker newLlcInvoker();

    public OptInvoker newOptInvoker();

    public LlvmObjCopyInvoker newLlvmObjCopyInvoker();

    public static Iterable<LlvmToolChain> findAllLlvmToolChains(Platform platform, Predicate<? super LlvmToolChain> filter, ClassLoader classLoader) {
        Path llcPath = ToolUtil.findExecutable((String)"llc");
        if (llcPath != null) {
            Path optPath = ToolUtil.findExecutable((String)"opt");
            if (optPath != null) {
                Path objCopyPath = ToolUtil.findExecutable((String)"llvm-objcopy");
                if (objCopyPath != null) {
                    ProcessBuilder pb = new ProcessBuilder(List.of(llcPath.toString(), "--version"));
                    StringBuilder stdOut = new StringBuilder();
                    try {
                        InputSource.empty().transferTo(OutputDestination.of((ProcessBuilder)pb, (OutputDestination)OutputDestination.discarding(), (OutputDestination)OutputDestination.of((Appendable)stdOut)));
                    }
                    catch (IOException e) {
                        Llvm.log.warn((Object)"Failed to execute LLVM tool chain version command", (Throwable)e);
                        return List.of();
                    }
                    Matcher matcher = Llvm.LLVM_VERSION_PATTERN.matcher(stdOut);
                    if (matcher.find()) {
                        String version = matcher.group(1);
                        return List.of(new LlvmToolChainImpl(llcPath, optPath, objCopyPath, platform, version));
                    }
                    Llvm.log.warn((Object)"Failed to identify LLVM version string; skipping");
                } else {
                    Llvm.log.warn((Object)"LLVM tool chain is missing a working `llvm-objcopy` executable");
                }
            } else {
                Llvm.log.warn((Object)"LLVM tool chain is missing a working `opt` executable");
            }
        }
        return List.of();
    }
}

