/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.tool.llvm;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.version.VersionScheme;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.qbicc.machine.arch.Platform;
import org.qbicc.tool.llvm.AbstractLlvmInvoker;
import org.qbicc.tool.llvm.LlvmToolChain;
import org.qbicc.tool.llvm.LlvmToolChainImpl;
import org.qbicc.tool.llvm.OptInvoker;
import org.qbicc.tool.llvm.OptPass;

final class OptInvokerImpl
extends AbstractLlvmInvoker
implements OptInvoker {
    private boolean opaquePointers;
    private List<OptPass> passes = new ArrayList<OptPass>();
    private List<String> options = List.of();

    OptInvokerImpl(LlvmToolChainImpl tool, Path path) {
        super(tool, path);
    }

    @Override
    public LlvmToolChain getTool() {
        return super.getTool();
    }

    @Override
    public void setOpaquePointers(boolean opaquePointers) {
        this.opaquePointers = opaquePointers;
    }

    @Override
    void addArguments(List<String> cmd) {
        LlvmToolChain tool = this.getTool();
        String llvmVersion = tool.getVersion();
        if (this.opaquePointers) {
            if (VersionScheme.BASIC.compare(llvmVersion, "15") < 0) {
                if (VersionScheme.BASIC.compare(llvmVersion, "14") >= 0) {
                    cmd.add("--opaque-pointers");
                } else {
                    cmd.add("--force-opaque-pointers");
                }
            }
        } else {
            if (VersionScheme.BASIC.compare(llvmVersion, "16") >= 0) {
                throw new IllegalArgumentException("Opaque pointers cannot be disabled on LLVM 16 or later");
            }
            if (VersionScheme.BASIC.compare(llvmVersion, "15") >= 0) {
                cmd.add("--opaque-pointers=0");
            }
        }
        Platform platform = this.getTool().getPlatform();
        cmd.add("-mtriple=" + platform.getCpu().toString() + "-" + platform.getOs().toString() + "-" + platform.getAbi().toString());
        for (OptPass pass : this.passes) {
            cmd.add("-" + pass.name);
        }
        cmd.addAll(this.options);
    }

    @Override
    public void setOptions(List<String> options) {
        this.options = options;
    }

    @Override
    public void addOptimizationPass(OptPass pass) {
        this.passes.add((OptPass)((Object)Assert.checkNotNullParam((String)"pass", (Object)((Object)pass))));
    }
}

