/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import org.eclipse.collections.api.list.ImmutableList;
import org.qbicc.machine.vfs.RelativeVirtualPath;
import org.qbicc.machine.vfs.VirtualPath;
import org.qbicc.machine.vfs.VirtualRootName;

public final class AbsoluteVirtualPath
extends VirtualPath {
    private final VirtualRootName root;

    AbsoluteVirtualPath(VirtualRootName root, ImmutableList<String> segments) {
        super(root.getFileSystem(), segments);
        this.root = root;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    public VirtualRootName getRootName() {
        return this.root;
    }

    @Override
    public AbsoluteVirtualPath getRoot() {
        return this.root.getRootPath();
    }

    @Override
    public AbsoluteVirtualPath toAbsolutePath() {
        return this;
    }

    @Override
    public AbsoluteVirtualPath getParent() {
        return (AbsoluteVirtualPath)super.getParent();
    }

    @Override
    public boolean startsWith(AbsoluteVirtualPath avp) {
        ImmutableList otherSegments = avp.segments;
        ImmutableList segments = this.segments;
        int otherSize = otherSegments.size();
        int size = segments.size();
        return this.root == avp.root && otherSize <= size && segments.subList(0, otherSize).equals(otherSegments);
    }

    @Override
    public boolean startsWith(RelativeVirtualPath rvp) {
        return false;
    }

    @Override
    public boolean endsWith(AbsoluteVirtualPath avp) {
        int size;
        ImmutableList otherSegments = avp.segments;
        ImmutableList segments = this.segments;
        int otherSize = otherSegments.size();
        return (otherSize < (size = segments.size()) || otherSize == size && avp.root == this.root) && segments.subList(size - otherSize, size).equals(otherSegments);
    }

    @Override
    public AbsoluteVirtualPath normalize() {
        return (AbsoluteVirtualPath)super.normalize();
    }

    @Override
    public AbsoluteVirtualPath resolve(VirtualPath other) {
        return (AbsoluteVirtualPath)super.resolve(other);
    }

    @Override
    public AbsoluteVirtualPath resolve(String other) {
        return (AbsoluteVirtualPath)super.resolve(other);
    }

    @Override
    public AbsoluteVirtualPath resolve(RelativeVirtualPath rvp) {
        return this.copy(this.segments.newWithAll((Iterable)rvp.segments));
    }

    @Override
    RelativeVirtualPath relativize() {
        return new RelativeVirtualPath(this.getFileSystem(), (ImmutableList<String>)this.segments);
    }

    @Override
    RelativeVirtualPath relativize(AbsoluteVirtualPath avp) {
        return this.root == avp.root ? this.relativizeCommon(avp) : (RelativeVirtualPath)AbsoluteVirtualPath.cannotRelativize();
    }

    @Override
    RelativeVirtualPath relativize(RelativeVirtualPath rvp) {
        return (RelativeVirtualPath)AbsoluteVirtualPath.cannotRelativize();
    }

    @Override
    public boolean equals(VirtualPath virtualPath) {
        AbsoluteVirtualPath avp;
        return virtualPath instanceof AbsoluteVirtualPath && this.equals(avp = (AbsoluteVirtualPath)virtualPath);
    }

    @Override
    public int hashCode() {
        return this.root.hashCode() * 19 + super.hashCode();
    }

    boolean equals(AbsoluteVirtualPath avp) {
        return super.equals(avp) && this.root == avp.root;
    }

    @Override
    AbsoluteVirtualPath copy(ImmutableList<String> newSegments) {
        return newSegments.isEmpty() ? this.root.getRootPath() : new AbsoluteVirtualPath(this.root, newSegments);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        this.root.toString(b);
        b.append(this.getFileSystem().getSeparator());
        return super.toString(b);
    }

    @Override
    public int compareTo(AbsoluteVirtualPath other) {
        return this.compareSegmentsTo((ImmutableList<String>)other.segments);
    }

    @Override
    public int compareTo(RelativeVirtualPath other) {
        return 1;
    }
}

