/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.impl.factory.Iterables;
import org.qbicc.machine.vfs.ExternalNode;
import org.qbicc.machine.vfs.FileNode;
import org.qbicc.machine.vfs.HostBytesNode;
import org.qbicc.machine.vfs.Node;
import org.qbicc.machine.vfs.RelativeVirtualPath;
import org.qbicc.machine.vfs.SingleParentNode;
import org.qbicc.machine.vfs.VirtualFileStatBuffer;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;
import org.qbicc.machine.vfs.ZipEntryNode;
import org.qbicc.machine.vio.DirectoryIoHandler;

final class DirectoryNode
extends SingleParentNode {
    private static final ImmutableSortedMap<String, Node> REMOVED = Iterables.iSortedMap((Object)"REMOVED", null);
    private static final VarHandle entriesHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "entries", VarHandle.class, DirectoryNode.class, ImmutableSortedMap.class);
    private static final VarHandle parentHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "parent", VarHandle.class, DirectoryNode.class, DirectoryNode.class);
    private volatile ImmutableSortedMap<String, Node> entries;
    private volatile DirectoryNode parent;
    private volatile int mode;
    private volatile long createTime;
    private volatile long modTime;

    private DirectoryNode(ImmutableSortedMap<String, Node> initialEntries, DirectoryNode parent, int mode) {
        Assert.checkNotNullParam((String)"parent", (Object)parent);
        this.entries = initialEntries;
        this.parent = parent;
        this.mode = mode;
        this.createTime = this.modTime = System.currentTimeMillis();
    }

    DirectoryNode(VirtualFileSystem fileSystem) {
        this.entries = fileSystem.getEmptyMap();
        this.parent = this;
        this.mode = 493;
        this.createTime = this.modTime = System.currentTimeMillis();
    }

    public Node get(String name) {
        return this.get(this.entries, name);
    }

    Node get(ImmutableSortedMap<String, Node> entries, String name) {
        return name.equals(".") ? this : (name.equals("..") ? this.parent : (entries == REMOVED ? null : (Node)entries.get((Object)name)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean changeParent(Node oldParent, Node newParent) {
        if (!(oldParent instanceof DirectoryNode)) return false;
        DirectoryNode odn = (DirectoryNode)oldParent;
        if (!(newParent instanceof DirectoryNode)) return false;
        DirectoryNode ndn = (DirectoryNode)newParent;
        if (!parentHandle.compareAndSet(this, odn, ndn)) return false;
        return true;
    }

    int openFile(int fd, VirtualFileSystem vfs, DirectoryNode parent, RelativeVirtualPath rvp, int idx, int flags, int mode) throws IOException {
        int nc = rvp.getNameCount();
        if (idx == nc) {
            return this.openExisting(fd, vfs, parent, flags);
        }
        if (idx == nc - 1) {
            return this.openFile(fd, vfs, rvp.getFileNameString(), flags, mode);
        }
        String name = rvp.getNameString(idx);
        Node node = this.get(name);
        if (node == null) {
            throw DirectoryNode.nsfe(rvp, idx);
        }
        if (node instanceof DirectoryNode) {
            DirectoryNode childDn = (DirectoryNode)node;
            return childDn.openFile(-1, vfs, this, rvp, idx + 1, flags, mode);
        }
        throw DirectoryNode.nde(rvp, idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int openFile(int fd, VirtualFileSystem vfs, String name, int flags, int mode) throws IOException {
        boolean create;
        boolean bl = create = (flags & 4) != 0;
        if (create && (flags & 0x40) != 0) {
            throw new AccessDeniedException(name);
        }
        if (create && !Thread.holdsLock(this)) {
            DirectoryNode directoryNode = this;
            synchronized (directoryNode) {
                return this.openFile(fd, vfs, name, flags, mode);
            }
        }
        boolean excl = (flags & 8) != 0;
        ImmutableSortedMap<String, Node> entries = this.entries;
        Node node = this.get(entries, name);
        if (node == null) {
            if (!create) {
                throw new NoSuchFileException(name);
            }
            if (!this.isWritable()) {
                throw new AccessDeniedException(name);
            }
            node = new FileNode(vfs, mode);
            this.modTime = System.currentTimeMillis();
            this.entries = entries.newWithKeyValue((Object)name, (Object)node);
        } else {
            if (create && excl) {
                throw new FileAlreadyExistsException(name);
            }
            node.checkMode(name, flags & 3);
        }
        return node.openExisting(fd, vfs, this, flags);
    }

    VirtualFileStatBuffer stat(VirtualFileSystem vfs, RelativeVirtualPath rvp, int idx, boolean followLinks) throws IOException {
        int nc = rvp.getNameCount();
        if (idx == nc) {
            return this.statExisting();
        }
        String name = rvp.getNameString(idx);
        Node node = this.get(name);
        if (node == null) {
            throw DirectoryNode.nsfe(rvp, idx);
        }
        if (idx == nc - 1) {
            return node.statExisting();
        }
        if (node instanceof DirectoryNode) {
            DirectoryNode dn = (DirectoryNode)node;
            return dn.stat(vfs, rvp, idx + 1, followLinks);
        }
        throw DirectoryNode.nde(rvp, idx);
    }

    @Override
    VirtualFileStatBuffer statExisting() {
        long modTime = this.modTime;
        return new VirtualFileStatBuffer(modTime, modTime, this.createTime, 5, this.entries.size(), this.getNodeId());
    }

    @Override
    int openExisting(int fd, VirtualFileSystem vfs, DirectoryNode parent, int flags) throws IOException {
        if ((flags & 3) != 0) {
            throw new AccessDeniedException("Cannot write to a directory");
        }
        if ((flags & 0x3C) != 0) {
            throw new IOException("Invalid flags");
        }
        ImmutableSortedMap<String, Node> entries = this.entries;
        if (entries == REMOVED) {
            throw new NoSuchFileException("<deleted>");
        }
        final Iterator iterator = entries.keysView().iterator();
        return vfs.getVioSystem().open(() -> new DirectoryIoHandler(){
            int stage;
            private final AtomicBoolean closed;
            {
                DirectoryNode.this.addLink();
                this.stage = 0;
                this.closed = new AtomicBoolean();
            }

            public String readEntry() {
                return switch (this.bumpStage()) {
                    case 0 -> ".";
                    case 1 -> "..";
                    default -> iterator.hasNext() ? (String)iterator.next() : null;
                };
            }

            private int bumpStage() {
                int stage = this.stage;
                switch (stage) {
                    case 0: 
                    case 1: {
                        this.stage = stage + 1;
                    }
                }
                return stage;
            }

            public void close() throws IOException {
                if (this.closed.compareAndSet(false, true)) {
                    DirectoryNode.this.removeLink();
                }
            }
        });
    }

    void bindZipEntry(VirtualFileSystem vfs, RelativeVirtualPath rvp, int idx, ZipFile zf, ZipEntry ze, boolean replace) throws IOException {
        int nc = rvp.getNameCount();
        if (idx == nc) {
            throw new IOException("Cannot overwrite directory");
        }
        if (idx == nc - 1) {
            this.bindZipEntry(vfs, rvp.getNameString(idx), zf, ze, replace);
            return;
        }
        Node node = this.get(rvp.getNameString(idx));
        if (node instanceof DirectoryNode) {
            DirectoryNode dn = (DirectoryNode)node;
            dn.bindZipEntry(vfs, rvp, idx + 1, zf, ze, replace);
            return;
        }
        throw DirectoryNode.nde(rvp, idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindZipEntry(VirtualFileSystem vfs, String name, ZipFile zf, ZipEntry ze, boolean replace) throws IOException {
        DirectoryNode directoryNode = this;
        synchronized (directoryNode) {
            ImmutableSortedMap<String, Node> entries = this.entries;
            Node node = this.get(entries, name);
            if (node != null && !replace) {
                throw new FileAlreadyExistsException(name);
            }
            if (!this.isWritable()) {
                throw new AccessDeniedException(name);
            }
            this.entries = entries.newWithKeyValue((Object)name, (Object)new ZipEntryNode(zf, ze));
            if (node != null) {
                try {
                    node.removeLink();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    void bindExternalNode(VirtualFileSystem vfs, RelativeVirtualPath rvp, int idx, Path externalPath, boolean replace, boolean deleteOnClose) throws IOException {
        int nc = rvp.getNameCount();
        if (idx == nc) {
            throw new IOException("Cannot overwrite directory");
        }
        if (idx == nc - 1) {
            this.bindExternalNode(vfs, rvp.getNameString(idx), externalPath, replace, deleteOnClose);
            return;
        }
        Node node = this.get(rvp.getNameString(idx));
        if (node instanceof DirectoryNode) {
            DirectoryNode dn = (DirectoryNode)node;
            dn.bindExternalNode(vfs, rvp, idx + 1, externalPath, replace, deleteOnClose);
            return;
        }
        throw DirectoryNode.nde(rvp, idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindExternalNode(VirtualFileSystem vfs, String name, Path externalPath, boolean replace, boolean deleteOnClose) throws IOException {
        DirectoryNode directoryNode = this;
        synchronized (directoryNode) {
            ImmutableSortedMap<String, Node> entries = this.entries;
            Node node = this.get(entries, name);
            if (node != null && !replace) {
                throw new FileAlreadyExistsException(name);
            }
            if (!this.isWritable()) {
                throw new AccessDeniedException(name);
            }
            this.entries = entries.newWithKeyValue((Object)name, (Object)new ExternalNode(this, externalPath, deleteOnClose));
            if (node != null) {
                try {
                    node.removeLink();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    void bindHostBytes(VirtualFileSystem vfs, RelativeVirtualPath rvp, int idx, byte[] bytes, boolean replace) throws IOException {
        int nc = rvp.getNameCount();
        if (idx == nc) {
            throw new IOException("Cannot overwrite directory");
        }
        if (idx == nc - 1) {
            this.bindHostBytes(vfs, rvp.getNameString(idx), bytes, replace);
            return;
        }
        Node node = this.get(rvp.getNameString(idx));
        if (node instanceof DirectoryNode) {
            DirectoryNode dn = (DirectoryNode)node;
            dn.bindHostBytes(vfs, rvp, idx + 1, bytes, replace);
            return;
        }
        throw DirectoryNode.nde(rvp, idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindHostBytes(VirtualFileSystem vfs, String name, byte[] bytes, boolean replace) throws IOException {
        DirectoryNode directoryNode = this;
        synchronized (directoryNode) {
            ImmutableSortedMap<String, Node> entries = this.entries;
            Node node = this.get(entries, name);
            if (node != null && !replace) {
                throw new FileAlreadyExistsException(name);
            }
            if (!this.isWritable()) {
                throw new AccessDeniedException(name);
            }
            this.entries = entries.newWithKeyValue((Object)name, (Object)new HostBytesNode(vfs, bytes));
            if (node != null) {
                try {
                    node.removeLink();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mkdirs(VirtualFileSystem vfs, RelativeVirtualPath rvp, int idx, int mode) throws IOException {
        DirectoryNode dn;
        if (idx == rvp.getNameCount()) {
            return;
        }
        String name = rvp.getNameString(idx);
        DirectoryNode directoryNode = this;
        synchronized (directoryNode) {
            ImmutableSortedMap<String, Node> entries = this.entries;
            Node node = this.get(entries, name);
            if (node instanceof DirectoryNode) {
                DirectoryNode ndn;
                dn = ndn = (DirectoryNode)node;
            } else {
                if (node != null) {
                    throw DirectoryNode.fae(rvp, idx);
                }
                if (!this.isWritable()) {
                    throw DirectoryNode.ade(rvp, idx);
                }
                dn = new DirectoryNode(vfs.getEmptyMap(), this, mode);
                this.entries = entries.newWithKeyValue((Object)name, (Object)dn);
            }
        }
        dn.mkdirs(vfs, rvp, idx + 1, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mkdir(VirtualFileSystem vfs, RelativeVirtualPath rvp, int idx, int mode) throws IOException {
        String name = rvp.getNameString(idx);
        int nc = rvp.getNameCount();
        if (idx == nc) {
            throw DirectoryNode.fae(rvp, idx);
        }
        if (idx == nc - 1) {
            DirectoryNode directoryNode = this;
            synchronized (directoryNode) {
                ImmutableSortedMap<String, Node> entries = this.entries;
                Node node = this.get(entries, name);
                if (node != null) {
                    throw DirectoryNode.fae(rvp, idx);
                }
                if (!this.isWritable()) {
                    throw DirectoryNode.ade(rvp, idx);
                }
                this.entries = entries.newWithKeyValue((Object)name, (Object)new DirectoryNode(vfs.getEmptyMap(), this, mode));
            }
        } else {
            Node node = this.get(name);
            if (node instanceof DirectoryNode) {
                DirectoryNode dn = (DirectoryNode)node;
                dn.mkdir(vfs, rvp, idx + 1, mode);
                return;
            }
            throw DirectoryNode.nde(rvp, idx);
        }
    }

    void unlink(VirtualFileSystem vfs, RelativeVirtualPath rvp, int idx) throws IOException {
        int nc = rvp.getNameCount();
        if (idx == nc) {
            throw new IOException("Cannot unlink directory");
        }
        if (idx != nc - 1) {
            Node node = this.get(rvp.getNameString(idx));
            if (node instanceof DirectoryNode) {
                DirectoryNode dn = (DirectoryNode)node;
                dn.unlink(vfs, rvp, idx + 1);
                return;
            }
            throw DirectoryNode.nde(rvp, idx);
        }
        this.unlink(rvp.getNameString(idx));
    }

    private void unlink(String name) throws IOException {
        ImmutableSortedMap newVal;
        ImmutableSortedMap<String, Node> oldVal;
        Assert.checkNotNullParam((String)"name", (Object)name);
        if (name.equals(".") || name.equals("..")) {
            throw new IOException();
        }
        do {
            Node node;
            if ((node = (Node)(oldVal = this.entries).get((Object)name)) == null) {
                throw new NoSuchFileException(name);
            }
            if (!(node instanceof DirectoryNode)) continue;
            DirectoryNode dn = (DirectoryNode)node;
            dn.remove();
        } while (!entriesHandle.compareAndSet(this, oldVal, newVal = oldVal.newWithoutKey((Object)name)));
    }

    void checkAccess(VirtualFileSystem vfs, RelativeVirtualPath rvp, int idx, boolean read, boolean write, boolean execute) throws IOException {
        int nc = rvp.getNameCount();
        if (idx == nc) {
            this.checkModeFlags(rvp, idx, read, write, execute, this.getMode());
            return;
        }
        String name = rvp.getNameString(idx);
        Node node = this.get(name);
        if (node == null) {
            throw DirectoryNode.nsfe(rvp, idx);
        }
        if (idx == nc - 1) {
            this.checkModeFlags(rvp, idx, read, write, execute, node.getMode());
            return;
        }
        if (node instanceof DirectoryNode) {
            DirectoryNode dn = (DirectoryNode)node;
            dn.checkAccess(vfs, rvp, idx + 1, read, write, execute);
            return;
        }
        throw DirectoryNode.nde(rvp, idx);
    }

    private void checkModeFlags(RelativeVirtualPath rvp, int idx, boolean read, boolean write, boolean execute, int mode) throws AccessDeniedException {
        if (read & (mode & 0x124) == 0) {
            throw DirectoryNode.ade(rvp, idx);
        }
        if (write & (mode & 0x92) == 0) {
            throw DirectoryNode.ade(rvp, idx);
        }
        if (execute & (mode & 0x49) == 0) {
            throw DirectoryNode.ade(rvp, idx);
        }
    }

    int getBooleanAttributes(RelativeVirtualPath rvp, int idx, boolean followLinks) throws IOException {
        int nc = rvp.getNameCount();
        if (idx == nc) {
            return 5;
        }
        String name = rvp.getNameString(idx);
        Node node = this.get(name);
        if (node == null) {
            return 0;
        }
        if (idx == nc - 1) {
            if (node instanceof DirectoryNode) {
                return 5;
            }
            if (node instanceof ExternalNode) {
                ExternalNode en = (ExternalNode)node;
                BasicFileAttributeView av = Files.getFileAttributeView(en.getExternalPath(), BasicFileAttributeView.class, new LinkOption[0]);
                if (av == null) {
                    return Files.exists(en.getExternalPath(), new LinkOption[0]) ? 1 : 0;
                }
                BasicFileAttributes baf = av.readAttributes();
                int val = 1;
                if (baf.isRegularFile()) {
                    val |= 2;
                }
                if (baf.isDirectory()) {
                    val |= 4;
                }
                return val;
            }
            return 3;
        }
        if (node instanceof DirectoryNode) {
            DirectoryNode dn = (DirectoryNode)node;
            return dn.getBooleanAttributes(rvp, idx + 1, followLinks);
        }
        throw DirectoryNode.nde(rvp, idx);
    }

    Collection<String> getEntryNames(RelativeVirtualPath rvp, int idx, boolean followLinks) throws IOException {
        int nc = rvp.getNameCount();
        if (idx == nc) {
            return this.entries.castToMap().keySet();
        }
        String name = rvp.getNameString(idx);
        Node node = this.get(name);
        if (node == null) {
            throw DirectoryNode.nsfe(rvp, idx);
        }
        if (node instanceof DirectoryNode) {
            DirectoryNode dn = (DirectoryNode)node;
            return dn.getEntryNames(rvp, idx + 1, followLinks);
        }
        throw DirectoryNode.nde(rvp, idx);
    }

    void linkFrom(VirtualFileSystem vfs, RelativeVirtualPath rvp, int idx, boolean followLinks, VirtualPath fromPath) throws IOException {
        int nc = rvp.getNameCount();
        if (idx == nc) {
            vfs.getRootNode(fromPath).link(fromPath.relativize(), 0, followLinks, this);
            return;
        }
        String name = rvp.getNameString(idx);
        Node node = this.get(name);
        if (idx == nc - 1) {
            vfs.getRootNode(fromPath).link(fromPath.relativize(), 0, followLinks, node);
        } else if (node instanceof DirectoryNode) {
            DirectoryNode dn = (DirectoryNode)node;
            dn.linkFrom(vfs, rvp, idx + 1, followLinks, fromPath);
        } else {
            throw DirectoryNode.nde(rvp, idx);
        }
    }

    private void remove() throws IOException {
        ImmutableSortedMap<String, Node> entries = this.entries;
        if (entries == REMOVED || entries.isEmpty() && entriesHandle.compareAndSet(entries, REMOVED)) {
            return;
        }
        throw new DirectoryNotEmptyException(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void link(RelativeVirtualPath rvp, int idx, boolean followLinks, Node value) throws IOException {
        Assert.checkNotNullParam((String)"value", (Object)value);
        int nc = rvp.getNameCount();
        if (idx == nc) {
            throw new IllegalStateException("Unexpected directory");
        }
        String name = rvp.getNameString(idx);
        if (idx == nc - 1) {
            value.addLink();
            try {
                DirectoryNode directoryNode = this;
                synchronized (directoryNode) {
                    ImmutableSortedMap<String, Node> entries = this.entries;
                    if (entries == REMOVED) {
                        throw DirectoryNode.nsfe(rvp, idx - 1);
                    }
                    Node node = this.get(entries, name);
                    if (node != null) {
                        throw DirectoryNode.fae(rvp, idx);
                    }
                    this.entries = entries.newWithKeyValue((Object)name, (Object)value);
                    return;
                }
            }
            catch (Throwable t) {
                try {
                    value.removeLink();
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
        }
        Node node = this.get(name);
        if (node == null) {
            throw DirectoryNode.nsfe(rvp, idx);
        }
        if (node instanceof DirectoryNode) {
            DirectoryNode dn = (DirectoryNode)node;
            dn.link(rvp, idx + 1, followLinks, value);
            return;
        }
        throw DirectoryNode.nde(rvp, idx);
    }

    Node linkIfAbsent(String name, Node value) throws IOException {
        ImmutableSortedMap newVal;
        ImmutableSortedMap<String, Node> oldVal;
        DirectoryNode dn;
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"value", (Object)value);
        if (name.equals(".") || name.equals("..")) {
            throw new IOException();
        }
        if (value instanceof DirectoryNode && (dn = (DirectoryNode)value).getParent() != this) {
            throw new IOException("Node cannot be linked here");
        }
        do {
            if ((oldVal = this.entries) == REMOVED) {
                throw new NoSuchFileException(name);
            }
            Node node = (Node)oldVal.get((Object)name);
            if (node == null) continue;
            return node;
        } while (!entriesHandle.compareAndSet(this, oldVal, newVal = oldVal.newWithKeyValue((Object)name, (Object)value)));
        return null;
    }

    Node linkIfPresent(String name, Node value) throws IOException {
        Node node;
        ImmutableSortedMap newVal;
        ImmutableSortedMap<String, Node> oldVal;
        DirectoryNode dn;
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"value", (Object)value);
        if (name.equals(".") || name.equals("..")) {
            throw new IOException();
        }
        if (value instanceof DirectoryNode && (dn = (DirectoryNode)value).getParent() != this) {
            throw new IOException("Node cannot be linked here");
        }
        do {
            if ((oldVal = this.entries) == REMOVED) {
                throw new NoSuchFileException(name);
            }
            node = (Node)oldVal.get((Object)name);
            if (node != null) continue;
            return null;
        } while (!entriesHandle.compareAndSet(this, oldVal, newVal = oldVal.newWithKeyValue((Object)name, (Object)value)));
        return node;
    }

    public ImmutableSortedMap<String, Node> getEntries() {
        return this.entries;
    }

    @Override
    public DirectoryNode getParent() {
        return this.parent;
    }

    @Override
    int getMode() {
        return this.mode;
    }

    @Override
    void changeMode(int newMode) {
        this.mode = newMode & 0x1FF;
    }

    private static AccessDeniedException ade(RelativeVirtualPath rvp, int idx) {
        return new AccessDeniedException(rvp.subpath(0, idx).toString());
    }

    private static FileAlreadyExistsException fae(RelativeVirtualPath rvp, int idx) {
        return new FileAlreadyExistsException(rvp.subpath(0, idx + 1).toString());
    }

    private static NoSuchFileException nsfe(RelativeVirtualPath rvp, int idx) {
        return new NoSuchFileException(rvp.subpath(0, idx + 1).toString());
    }

    private static NotDirectoryException nde(RelativeVirtualPath rvp, int idx) {
        return new NotDirectoryException(rvp.subpath(0, idx + 1).toString());
    }
}

