/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import org.qbicc.machine.vfs.UncVirtualRootName;
import org.qbicc.machine.vfs.UnixVirtualRootName;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualRootName;

final class DriveLetterVirtualRootName
extends VirtualRootName {
    private final String name;

    DriveLetterVirtualRootName(VirtualFileSystem fileSystem, char letter) {
        super(fileSystem);
        this.name = Character.toString(Character.toUpperCase(letter));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return super.toString(b).append(':');
    }

    @Override
    public boolean equals(VirtualRootName other) {
        DriveLetterVirtualRootName vrn;
        return other instanceof DriveLetterVirtualRootName && this.equals(vrn = (DriveLetterVirtualRootName)other);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 19 + this.name.hashCode();
    }

    @Override
    int compareTo(DriveLetterVirtualRootName other) {
        return Character.compare(this.name.charAt(0), other.name.charAt(0));
    }

    @Override
    int compareTo(UncVirtualRootName other) {
        return -1;
    }

    @Override
    int compareTo(UnixVirtualRootName other) {
        return 1;
    }

    boolean equals(DriveLetterVirtualRootName other) {
        return super.equals(other) && this.name.equals(other.name);
    }

    public char getDriveLetter() {
        return this.name.charAt(0);
    }
}

