/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import java.io.IOException;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Set;
import org.qbicc.machine.vfs.DirectoryNode;
import org.qbicc.machine.vfs.Node;
import org.qbicc.machine.vfs.SingleParentNode;
import org.qbicc.machine.vfs.VFSUtils;
import org.qbicc.machine.vfs.VirtualFileStatBuffer;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;

final class ExternalNode
extends SingleParentNode {
    private static final VarHandle parentHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "parent", VarHandle.class, ExternalNode.class, Node.class);
    private volatile Node parent;
    private final Path path;
    private final boolean deleteOnClose;

    ExternalNode(Node parent, Path path, boolean deleteOnClose) {
        this.parent = parent;
        this.path = path;
        this.deleteOnClose = deleteOnClose;
    }

    public Path getExternalPath() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        if (this.deleteOnClose) {
            Files.delete(this.getExternalPath());
        }
    }

    @Override
    int getMode() {
        try {
            return VFSUtils.getModeFromPermSet(Files.getPosixFilePermissions(this.path, LinkOption.NOFOLLOW_LINKS));
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    void changeMode(int newMode) throws AccessDeniedException {
        try {
            Files.setPosixFilePermissions(this.path, VFSUtils.getPermSetFromMode(newMode));
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (IOException e) {
            throw new AccessDeniedException(this.path.toString(), null, e.toString());
        }
    }

    @Override
    VirtualFileStatBuffer statExisting() throws IOException {
        BasicFileAttributeView view = Files.getFileAttributeView(this.path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        BasicFileAttributes attr = view.readAttributes();
        int ba = 1;
        if (attr.isRegularFile()) {
            ba |= 2;
        }
        if (attr.isDirectory()) {
            ba |= 4;
        }
        return new VirtualFileStatBuffer(attr.lastModifiedTime().toMillis(), attr.lastAccessTime().toMillis(), attr.creationTime().toMillis(), ba, attr.size(), this.getNodeId());
    }

    @Override
    int openExisting(int fd, VirtualFileSystem vfs, DirectoryNode parent, int flags) throws IOException {
        EnumSet<StandardOpenOption> set = VFSUtils.getOpenOptions(flags);
        set.remove(StandardOpenOption.CREATE);
        set.remove(StandardOpenOption.CREATE_NEW);
        if (fd == -1) {
            return vfs.getVioSystem().openRealFile(this.path, set, Set.of());
        }
        vfs.getVioSystem().openRealFile(fd, this.path, set, Set.of());
        return fd;
    }

    @Override
    VirtualPath readLink(VirtualFileSystem fileSystem, VirtualPath vp, int vpi) throws IOException {
        return fileSystem.getPath(Files.readSymbolicLink(this.path).toString(), new String[0]);
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public boolean changeParent(Node oldParent, Node newParent) {
        return newParent != null && parentHandle.compareAndSet(this, oldParent, newParent);
    }
}

