/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;
import org.qbicc.machine.vfs.DirectoryNode;
import org.qbicc.machine.vfs.Node;
import org.qbicc.machine.vfs.VirtualFileStatBuffer;
import org.qbicc.machine.vfs.VirtualFileSystem;

final class FileNode
extends Node
implements Closeable {
    private final Path tempFilePath = Files.createTempFile("qbicc-vfs", "", PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE)));
    private volatile int mode;

    FileNode(VirtualFileSystem vfs, int mode) throws IOException {
        vfs.addCloseable(this);
        this.mode = mode & 0x1FF;
    }

    @Override
    VirtualFileStatBuffer statExisting() throws IOException {
        BasicFileAttributeView view = Files.getFileAttributeView(this.tempFilePath, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        BasicFileAttributes attr = view.readAttributes();
        int ba = 1;
        if (attr.isRegularFile()) {
            ba |= 2;
        }
        if (attr.isDirectory()) {
            ba |= 4;
        }
        return new VirtualFileStatBuffer(attr.lastModifiedTime().toMillis(), attr.lastAccessTime().toMillis(), attr.creationTime().toMillis(), ba, attr.size(), this.getNodeId());
    }

    @Override
    int openExisting(int fd, VirtualFileSystem vfs, DirectoryNode parent, int flags) throws IOException {
        EnumSet<StandardOpenOption> options = this.getOptions(flags);
        this.addLink();
        try {
            if (fd == -1) {
                return vfs.getVioSystem().openRealFile(this.tempFilePath, options, Set.of(), this::removeLink);
            }
            vfs.getVioSystem().openRealFile(fd, this.tempFilePath, options, Set.of(), this::removeLink);
            return fd;
        }
        catch (Throwable t) {
            try {
                this.removeLink();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
    }

    private EnumSet<StandardOpenOption> getOptions(int flags) throws NotDirectoryException {
        EnumSet<StandardOpenOption> set = EnumSet.noneOf(StandardOpenOption.class);
        int accessMode = flags & 3;
        if (accessMode == 0 || accessMode == 2) {
            set.add(StandardOpenOption.READ);
        }
        if (accessMode == 1 || accessMode == 2) {
            set.add(StandardOpenOption.WRITE);
        }
        if ((flags & 0x10) != 0) {
            set.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        if ((flags & 0x40) != 0) {
            throw new NotDirectoryException("Not a directory");
        }
        return set;
    }

    @Override
    public void close() throws IOException {
        Files.delete(this.tempFilePath);
    }

    @Override
    int getMode() {
        return this.mode;
    }

    @Override
    void changeMode(int newMode) {
        this.mode = newMode & 0x1FF;
    }
}

