/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.NotDirectoryException;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import org.qbicc.machine.vfs.DirectoryNode;
import org.qbicc.machine.vfs.Node;
import org.qbicc.machine.vfs.VirtualFileStatBuffer;
import org.qbicc.machine.vfs.VirtualFileSystem;

final class HostBytesNode
extends Node
implements Closeable {
    private byte[] bytes;
    private volatile int mode;
    final long createTime;

    HostBytesNode(VirtualFileSystem vfs, byte[] bytes) throws IOException {
        this.bytes = bytes;
        this.createTime = System.currentTimeMillis();
        vfs.addCloseable(this);
        this.mode = 292;
    }

    @Override
    VirtualFileStatBuffer statExisting() throws IOException {
        int ba = 1;
        return new VirtualFileStatBuffer(this.createTime, this.createTime, this.createTime, ba |= 2, this.bytes.length, this.getNodeId());
    }

    @Override
    int openExisting(int fd, VirtualFileSystem vfs, DirectoryNode parent, int flags) throws IOException {
        this.addLink();
        try {
            if (fd == -1) {
                return vfs.getVioSystem().openInputStream(() -> new ByteArrayInputStream(this.bytes));
            }
            vfs.getVioSystem().openInputStream(fd, () -> new ByteArrayInputStream(this.bytes));
            return fd;
        }
        catch (Throwable t) {
            try {
                this.removeLink();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
    }

    private EnumSet<StandardOpenOption> getOptions(int flags) throws NotDirectoryException {
        EnumSet<StandardOpenOption> set = EnumSet.noneOf(StandardOpenOption.class);
        int accessMode = flags & 3;
        if (accessMode == 0 || accessMode == 2) {
            set.add(StandardOpenOption.READ);
        }
        if (accessMode == 1 || accessMode == 2) {
            set.add(StandardOpenOption.WRITE);
        }
        if ((flags & 0x10) != 0) {
            set.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        if ((flags & 0x40) != 0) {
            throw new NotDirectoryException("Not a directory");
        }
        return set;
    }

    @Override
    public void close() throws IOException {
        this.bytes = new byte[0];
    }

    @Override
    int getMode() {
        return this.mode;
    }

    @Override
    void changeMode(int newMode) {
        this.mode = newMode & 0x1FF;
    }
}

