/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.util.concurrent.atomic.AtomicLong;
import org.qbicc.machine.vfs.DirectoryNode;
import org.qbicc.machine.vfs.VirtualFileStatBuffer;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;

abstract class Node
implements Closeable {
    private static final AtomicLong nodeIdCounter = new AtomicLong(1L);
    private static final VarHandle linksHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "links", VarHandle.class, Node.class, Integer.TYPE);
    private volatile int links = 1;
    private final long nodeId = nodeIdCounter.getAndIncrement();

    Node() {
    }

    final void addLink() throws NoSuchFileException {
        int links;
        do {
            if ((links = this.links) != 0) continue;
            throw new NoSuchFileException("<deleted>");
        } while (!linksHandle.compareAndSet(this, links, links + 1));
    }

    final void removeLink() throws IOException {
        int links;
        do {
            if ((links = this.links) != 0) continue;
            throw new IllegalStateException("Link reference count mismatch");
        } while (!linksHandle.compareAndSet(this, links, links - 1));
        if (links == 1) {
            this.close();
        }
    }

    abstract VirtualFileStatBuffer statExisting() throws IOException;

    abstract int openExisting(int var1, VirtualFileSystem var2, DirectoryNode var3, int var4) throws IOException;

    VirtualPath readLink(VirtualFileSystem fileSystem, VirtualPath vp, int vpi) throws IOException {
        throw new NotLinkException("Cannot open non-link node");
    }

    long getNodeId() {
        return this.nodeId;
    }

    abstract int getMode();

    abstract void changeMode(int var1) throws AccessDeniedException;

    boolean isReadable() {
        return (this.getMode() & 0x124) != 0;
    }

    boolean isWritable() {
        return (this.getMode() & 0x92) != 0;
    }

    boolean isExecutable() {
        return (this.getMode() & 0x49) != 0;
    }

    void checkMode(String name, int accessMode) throws AccessDeniedException {
        int mode = this.getMode();
        if ((accessMode == 0 || accessMode == 2) && (mode & 0x124) == 0 || (accessMode == 1 || accessMode == 2) && (mode & 0x92) == 0) {
            throw new AccessDeniedException(name);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

