/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import java.util.List;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.qbicc.machine.vfs.AbsoluteVirtualPath;
import org.qbicc.machine.vfs.DirectoryNode;
import org.qbicc.machine.vfs.RelativeVirtualPath;
import org.qbicc.machine.vfs.UnixVirtualRootName;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;
import org.qbicc.machine.vfs.VirtualRootName;
import org.qbicc.machine.vio.VIOSystem;

public class PosixVirtualFileSystem
extends VirtualFileSystem {
    private final UnixVirtualRootName rootName = new UnixVirtualRootName(this);
    private final DirectoryNode rootNode = new DirectoryNode(this);
    private final List<AbsoluteVirtualPath> rootList = List.of(this.rootName.getRootPath());
    private static final int ST_INITIAL = 0;
    private static final int ST_SLASH = 1;
    private static final int ST_SEGMENT = 2;

    public PosixVirtualFileSystem(VIOSystem vioSystem, boolean caseSensitive) {
        super(vioSystem, caseSensitive ? String::compareTo : String::compareToIgnoreCase);
    }

    @Override
    public VirtualRootName getDefaultRootName() {
        return this.rootName;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public List<AbsoluteVirtualPath> getRootDirectories() {
        return this.rootList;
    }

    @Override
    public VirtualPath getPath(String first, String ... rest) throws IllegalArgumentException {
        return PosixVirtualFileSystem.parsePosixPath(this, first, rest);
    }

    static VirtualPath parsePosixPath(VirtualFileSystem vfs, String first, String ... rest) {
        int state = 0;
        String current = first;
        int strIdx = 0;
        int nextIdx = 0;
        int start = -1;
        VirtualRootName rootName = null;
        FastList segments = FastList.newList();
        while (true) {
            if (strIdx == current.length() && state == 2) {
                segments.add((Object)current.substring(start, strIdx));
                state = 1;
            }
            while (current == null || strIdx == current.length()) {
                if (rest != null && nextIdx < rest.length) {
                    current = rest[nextIdx++];
                    strIdx = 0;
                    continue;
                }
                if (rootName != null) {
                    if (segments.isEmpty()) {
                        return rootName.getRootPath();
                    }
                    return new AbsoluteVirtualPath(rootName, (ImmutableList<String>)segments.toImmutable());
                }
                if (segments.isEmpty()) {
                    return vfs.getEmptyPath();
                }
                return new RelativeVirtualPath(vfs, (ImmutableList<String>)segments.toImmutable());
            }
            char c = current.charAt(strIdx);
            switch (c) {
                case '/': {
                    switch (state) {
                        case 0: {
                            rootName = vfs.getDefaultRootName();
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            segments.add((Object)current.substring(start, strIdx));
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    state = 1;
                    break;
                }
                default: {
                    switch (state) {
                        case 0: 
                        case 1: {
                            start = strIdx;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    state = 2;
                }
            }
            ++strIdx;
        }
    }

    @Override
    DirectoryNode getRootNode(VirtualRootName rootName) {
        return rootName.equals(this.rootName) ? this.rootNode : null;
    }

    @Override
    public boolean isHidden(VirtualPath path) {
        return path.getFileNameString().startsWith(".");
    }
}

