/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import org.eclipse.collections.api.list.ImmutableList;
import org.qbicc.machine.vfs.AbsoluteVirtualPath;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;

public final class RelativeVirtualPath
extends VirtualPath {
    RelativeVirtualPath(VirtualFileSystem fileSystem, ImmutableList<String> segments) {
        super(fileSystem, segments);
    }

    @Override
    public RelativeVirtualPath getParent() {
        return (RelativeVirtualPath)super.getParent();
    }

    @Override
    public boolean startsWith(AbsoluteVirtualPath avp) {
        return false;
    }

    @Override
    public boolean startsWith(RelativeVirtualPath rvp) {
        int size;
        ImmutableList otherSegments = rvp.segments;
        ImmutableList segments = this.segments;
        int otherSize = otherSegments.size();
        return otherSize <= (size = segments.size()) && segments.subList(0, otherSize).equals(otherSegments);
    }

    @Override
    public boolean endsWith(AbsoluteVirtualPath avp) {
        return false;
    }

    @Override
    public RelativeVirtualPath normalize() {
        return (RelativeVirtualPath)super.normalize();
    }

    @Override
    public RelativeVirtualPath resolve(RelativeVirtualPath rvp) {
        return this.copy(this.segments.newWithAll((Iterable)rvp.segments));
    }

    @Override
    RelativeVirtualPath relativize() {
        return this;
    }

    @Override
    RelativeVirtualPath relativize(AbsoluteVirtualPath avp) {
        return (RelativeVirtualPath)RelativeVirtualPath.cannotRelativize();
    }

    @Override
    RelativeVirtualPath relativize(RelativeVirtualPath rvp) {
        return this.relativizeCommon(rvp);
    }

    @Override
    public boolean equals(VirtualPath virtualPath) {
        RelativeVirtualPath rvp;
        return virtualPath instanceof RelativeVirtualPath && this.equals(rvp = (RelativeVirtualPath)virtualPath);
    }

    public boolean equals(RelativeVirtualPath rvp) {
        return super.equals(rvp);
    }

    @Override
    RelativeVirtualPath copy(ImmutableList<String> newSegments) {
        return newSegments.isEmpty() ? this.getFileSystem().getEmptyPath() : new RelativeVirtualPath(this.getFileSystem(), newSegments);
    }

    @Override
    public boolean isAbsolute() {
        return false;
    }

    @Override
    public AbsoluteVirtualPath getRoot() {
        return null;
    }

    @Override
    public AbsoluteVirtualPath toAbsolutePath() {
        return this.getFileSystem().getDefaultRootName().getRootPath().resolve(this);
    }

    @Override
    public int compareTo(AbsoluteVirtualPath other) {
        return -1;
    }

    @Override
    public int compareTo(RelativeVirtualPath other) {
        return this.compareSegmentsTo((ImmutableList<String>)other.segments);
    }
}

