/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import io.smallrye.common.constraint.Assert;
import org.qbicc.machine.vfs.DriveLetterVirtualRootName;
import org.qbicc.machine.vfs.UnixVirtualRootName;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualRootName;

final class UncVirtualRootName
extends VirtualRootName {
    private final String serverName;

    UncVirtualRootName(VirtualFileSystem fileSystem, String serverName) {
        super(fileSystem);
        this.serverName = Assert.checkNotEmptyParam((String)"serverName", (String)serverName);
    }

    @Override
    public String getName() {
        return this.serverName;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        String sep = this.getFileSystem().getSeparator();
        b.append(sep);
        b.append(sep);
        return super.toString(b);
    }

    @Override
    public boolean equals(VirtualRootName other) {
        UncVirtualRootName vrn;
        return other instanceof UncVirtualRootName && this.equals(vrn = (UncVirtualRootName)other);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 19 + this.serverName.hashCode();
    }

    @Override
    int compareTo(DriveLetterVirtualRootName other) {
        return 1;
    }

    @Override
    int compareTo(UncVirtualRootName other) {
        return this.serverName.compareToIgnoreCase(other.serverName);
    }

    @Override
    int compareTo(UnixVirtualRootName other) {
        return 1;
    }

    boolean equals(UncVirtualRootName other) {
        return super.equals(other) && this.serverName.equalsIgnoreCase(other.serverName);
    }
}

