/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;

public final class VFSUtils {
    public static final String DOT = ".";
    public static final String DOT_DOT = "..";
    public static final int O_ACCESS_MODE_MASK = 3;
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_CREAT = 4;
    public static final int O_EXCL = 8;
    public static final int O_TRUNC = 16;
    public static final int O_APPEND = 32;
    public static final int O_DIRECTORY = 64;
    public static final int BA_EXISTS = 1;
    public static final int BA_REGULAR = 2;
    public static final int BA_DIRECTORY = 4;
    public static final int BA_HIDDEN = 8;
    private static final PosixFilePermission[] PERM_VALUES = PosixFilePermission.values();

    private VFSUtils() {
    }

    public static void mountZipFile(VirtualFileSystem vfs, VirtualPath mountPoint, ZipFile zipFile) throws IOException {
        Iterator<? extends ZipEntry> iterator = zipFile.entries().asIterator();
        while (iterator.hasNext()) {
            ZipEntry entry = iterator.next();
            vfs.bindZipEntry(mountPoint.resolve(entry.getName()), zipFile, entry, true);
        }
        vfs.addCloseable(zipFile);
    }

    public static void safeClose(Closeable closeable, Throwable t) {
        block2: {
            try {
                closeable.close();
            }
            catch (Throwable t2) {
                if (t == null) break block2;
                t.addSuppressed(t2);
            }
        }
    }

    public static int getModeFromPermSet(Set<PosixFilePermission> set) {
        int mode = 0;
        for (PosixFilePermission perm : set) {
            mode |= 1 << perm.ordinal();
        }
        return mode;
    }

    public static EnumSet<PosixFilePermission> getPermSetFromMode(int mode) {
        EnumSet<PosixFilePermission> permSet = EnumSet.noneOf(PosixFilePermission.class);
        while (mode != 0) {
            int lob = Integer.lowestOneBit(mode);
            int idx = Integer.numberOfTrailingZeros(lob);
            if (idx < PERM_VALUES.length) {
                permSet.add(PERM_VALUES[idx]);
            }
            mode &= ~lob;
        }
        return permSet;
    }

    public static EnumSet<StandardOpenOption> getOpenOptions(int flags) throws IOException {
        int am = flags & 3;
        EnumSet<StandardOpenOption> set = switch (am) {
            case 0 -> EnumSet.of(StandardOpenOption.READ);
            case 1 -> EnumSet.of(StandardOpenOption.WRITE);
            case 2 -> EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE);
            default -> throw new IOException("Invalid mode");
        };
        if ((flags & 4) != 0) {
            set.add((flags & 8) != 0 ? StandardOpenOption.CREATE_NEW : StandardOpenOption.CREATE);
        }
        if ((flags & 0x10) != 0) {
            set.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        if ((flags & 0x20) != 0) {
            set.add(StandardOpenOption.APPEND);
        }
        return set;
    }
}

