/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.impl.factory.Iterables;
import org.qbicc.machine.vfs.AbsoluteVirtualPath;
import org.qbicc.machine.vfs.DirectoryNode;
import org.qbicc.machine.vfs.Node;
import org.qbicc.machine.vfs.RelativeVirtualPath;
import org.qbicc.machine.vfs.VirtualFileStatBuffer;
import org.qbicc.machine.vfs.VirtualPath;
import org.qbicc.machine.vfs.VirtualRootName;
import org.qbicc.machine.vio.VIOSystem;

public abstract class VirtualFileSystem
implements Closeable {
    private final VIOSystem vioSystem;
    private final RelativeVirtualPath emptyPath = new RelativeVirtualPath(this, (ImmutableList<String>)Iterables.iList());
    private final ImmutableSortedMap<String, Node> emptyMap;
    private volatile boolean closed;
    private final ArrayList<Closeable> closeables = new ArrayList();

    VirtualFileSystem(VIOSystem vioSystem, Comparator<? super String> segmentComparator) {
        this.vioSystem = vioSystem;
        this.emptyMap = Iterables.iSortedMap(segmentComparator);
    }

    public abstract VirtualRootName getDefaultRootName();

    public VIOSystem getVioSystem() {
        return this.vioSystem;
    }

    public abstract List<AbsoluteVirtualPath> getRootDirectories();

    public abstract VirtualPath getPath(String var1, String ... var2) throws IllegalArgumentException;

    abstract DirectoryNode getRootNode(VirtualRootName var1);

    DirectoryNode getRootNode(VirtualPath vp) {
        if (vp instanceof AbsoluteVirtualPath) {
            AbsoluteVirtualPath avp = (AbsoluteVirtualPath)vp;
            return this.getRootNode(avp.getRootName());
        }
        return this.getRootNode(this.getDefaultRootName());
    }

    public RelativeVirtualPath getEmptyPath() {
        return this.emptyPath;
    }

    public Comparator<String> getPathSegmentComparator() {
        return this.emptyMap.comparator();
    }

    public ImmutableSortedMap<String, Node> getEmptyMap() {
        return this.emptyMap;
    }

    public void bindExternalNode(VirtualPath vp, Path path, boolean replace, boolean deleteOnClose) throws IOException {
        this.getRootNode(vp).bindExternalNode(this, vp.relativize(), 0, path, replace, deleteOnClose);
    }

    public void bindZipEntry(VirtualPath vp, ZipFile zf, ZipEntry ze, boolean replace) throws IOException {
        this.getRootNode(vp).bindZipEntry(this, vp.relativize(), 0, zf, ze, replace);
    }

    public void bindHostBytes(VirtualPath vp, byte[] bytes, boolean replace) throws IOException {
        this.getRootNode(vp).bindHostBytes(this, vp.relativize(), 0, bytes, replace);
    }

    public void mkdirs(VirtualPath vp, int mode) throws IOException {
        this.getRootNode(vp).mkdirs(this, vp.relativize(), 0, mode);
    }

    public int open(VirtualPath vp, int flags, int mode) throws IOException {
        return this.getRootNode(vp).openFile(-1, this, this.getRootNode(vp), vp.relativize(), 0, flags, mode);
    }

    public void open(int fd, VirtualPath vp, int flags, int mode) throws IOException {
        this.getRootNode(vp).openFile(fd, this, this.getRootNode(vp), vp.relativize(), 0, flags, mode);
    }

    public VirtualFileStatBuffer stat(VirtualPath vp, boolean followLinks) throws IOException {
        return this.getRootNode(vp).stat(this, vp.relativize(), 0, followLinks);
    }

    public VirtualPath readLink(VirtualPath vp) throws IOException {
        return this.getRootNode(vp).readLink(this, vp, 0);
    }

    public void unlink(VirtualPath vp) throws IOException {
        this.getRootNode(vp).unlink(this, vp.relativize(), 0);
    }

    public boolean deleteIfExists(VirtualPath vp) throws IOException {
        try {
            this.unlink(vp);
            return true;
        }
        catch (NoSuchFileException ignored) {
            return false;
        }
    }

    public void mkdir(VirtualPath vp, int mode) throws IOException {
        this.getRootNode(vp).mkdir(this, vp.relativize(), 0, mode);
    }

    public abstract boolean isHidden(VirtualPath var1) throws IOException;

    public void checkAccess(VirtualPath vp, boolean read, boolean write, boolean execute) throws IOException {
        this.getRootNode(vp).checkAccess(this, vp.relativize(), 0, read, write, execute);
    }

    public abstract String getSeparator();

    public int getBooleanAttributes(VirtualPath vp, boolean followLinks) throws IOException {
        return this.getRootNode(vp).getBooleanAttributes(vp.relativize(), 0, followLinks);
    }

    public Collection<String> getDirectoryEntries(VirtualPath vp, boolean followLinks) throws IOException {
        return this.getRootNode(vp).getEntryNames(vp.relativize(), 0, followLinks);
    }

    public void link(VirtualPath toPath, VirtualPath fromPath, boolean followLinks) throws IOException {
        this.getRootNode(fromPath).linkFrom(this, fromPath.relativize(), 0, followLinks, toPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ArrayList<Closeable> closeables = this.closeables;
        Throwable e = null;
        ArrayList<Closeable> arrayList = closeables;
        synchronized (arrayList) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (Closeable closeable : closeables) {
                try {
                    closeable.close();
                }
                catch (Throwable t) {
                    if (e == null) {
                        e = new IOException("One or more resources failed to close properly");
                    }
                    e.addSuppressed(t);
                }
            }
            closeables.clear();
        }
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseable(Closeable closeable) throws IOException {
        ArrayList<Closeable> closeables;
        ArrayList<Closeable> arrayList = closeables = this.closeables;
        synchronized (arrayList) {
            if (this.closed) {
                closeable.close();
            }
            closeables.add(closeable);
        }
    }
}

