/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.qbicc.machine.vfs.AbsoluteVirtualPath;
import org.qbicc.machine.vfs.RelativeVirtualPath;
import org.qbicc.machine.vfs.VirtualFileSystem;

public abstract class VirtualPath
implements Comparable<VirtualPath> {
    private final VirtualFileSystem fileSystem;
    final ImmutableList<String> segments;
    private transient String toString;

    VirtualPath(VirtualFileSystem fileSystem, ImmutableList<String> segments) {
        this.fileSystem = fileSystem;
        this.segments = segments;
    }

    public VirtualFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public VirtualPath getFileName() {
        return this.getName(this.segments.size() - 1);
    }

    public String getFileNameString() {
        return (String)this.segments.getLast();
    }

    public VirtualPath getParent() {
        return this.segments.isEmpty() ? null : this.subpath(0, this.segments.size() - 1);
    }

    public int getNameCount() {
        return this.segments.size();
    }

    public VirtualPath getName(int index) {
        return this.subpath(index, index + 1);
    }

    public String getNameString(int index) {
        return (String)this.segments.get(index);
    }

    public Iterable<String> getNameStrings() {
        return this.segments;
    }

    public VirtualPath subpath(int beginIndex, int endIndex) {
        ImmutableList newSegments = this.segments.subList(beginIndex, endIndex);
        return beginIndex == 0 ? this.copy((ImmutableList<String>)newSegments) : new RelativeVirtualPath(this.fileSystem, (ImmutableList<String>)newSegments);
    }

    public VirtualPath subpath(int beginIndex) {
        ImmutableList newSegments = this.segments.subList(beginIndex, this.segments.size());
        return beginIndex == 0 ? this.copy((ImmutableList<String>)newSegments) : new RelativeVirtualPath(this.fileSystem, (ImmutableList<String>)newSegments);
    }

    public boolean startsWith(VirtualPath other) {
        RelativeVirtualPath rvp;
        AbsoluteVirtualPath avp;
        return other instanceof AbsoluteVirtualPath && this.startsWith(avp = (AbsoluteVirtualPath)other) || other instanceof RelativeVirtualPath && this.startsWith(rvp = (RelativeVirtualPath)other);
    }

    public abstract boolean startsWith(AbsoluteVirtualPath var1);

    public abstract boolean startsWith(RelativeVirtualPath var1);

    public final boolean endsWith(VirtualPath other) {
        RelativeVirtualPath rvp;
        AbsoluteVirtualPath avp;
        return other instanceof AbsoluteVirtualPath && this.endsWith(avp = (AbsoluteVirtualPath)other) || other instanceof RelativeVirtualPath && this.endsWith(rvp = (RelativeVirtualPath)other);
    }

    public abstract boolean endsWith(AbsoluteVirtualPath var1);

    public boolean endsWith(RelativeVirtualPath rvp) {
        int size;
        ImmutableList otherSegments = rvp.segments;
        ImmutableList<String> segments = this.segments;
        int otherSize = otherSegments.size();
        return otherSize <= (size = segments.size()) && segments.subList(size - otherSize, size).equals(otherSegments);
    }

    public VirtualPath normalize() {
        ListIterator li = this.segments.listIterator();
        FastList ml = null;
        while (li.hasNext()) {
            String item = (String)li.next();
            boolean isDot = item.equals(".");
            boolean isDotDot = item.equals("..");
            if ((isDot || isDotDot) && ml == null) {
                ml = new FastList(this.segments.size());
                int idx = li.nextIndex();
                this.segments.forEach(0, idx, arg_0 -> ((MutableList)ml).add(arg_0));
            }
            if (isDot) continue;
            if (isDotDot) {
                int size = ml.size();
                if (size <= 0) continue;
                ml.remove(size - 1);
                continue;
            }
            if (ml == null) continue;
            ml.add((Object)item);
        }
        if (ml == null) {
            return this;
        }
        return this.copy((ImmutableList<String>)ml.toImmutable());
    }

    public VirtualPath resolve(VirtualPath other) {
        VirtualPath virtualPath;
        if (other instanceof AbsoluteVirtualPath) {
            AbsoluteVirtualPath avp = (AbsoluteVirtualPath)other;
            virtualPath = this.resolve(avp);
        } else if (other instanceof RelativeVirtualPath) {
            RelativeVirtualPath rvp = (RelativeVirtualPath)other;
            virtualPath = this.resolve(rvp);
        } else {
            virtualPath = (VirtualPath)VirtualPath.wrongType();
        }
        return virtualPath;
    }

    public VirtualPath resolve(String other) {
        return this.resolve(this.getFileSystem().getPath(other, new String[0]));
    }

    public AbsoluteVirtualPath resolve(AbsoluteVirtualPath avp) {
        return avp;
    }

    public abstract VirtualPath resolve(RelativeVirtualPath var1);

    static <T> T wrongType() {
        throw new IllegalArgumentException("Wrong Path type for this provider");
    }

    public RelativeVirtualPath relativize(VirtualPath other) {
        RelativeVirtualPath relativeVirtualPath;
        if (other instanceof AbsoluteVirtualPath) {
            AbsoluteVirtualPath avp = (AbsoluteVirtualPath)other;
            relativeVirtualPath = this.relativize(avp);
        } else if (other instanceof RelativeVirtualPath) {
            RelativeVirtualPath rvp = (RelativeVirtualPath)other;
            relativeVirtualPath = this.relativize(rvp);
        } else {
            relativeVirtualPath = (RelativeVirtualPath)VirtualPath.cannotRelativize();
        }
        return relativeVirtualPath;
    }

    RelativeVirtualPath relativizeCommon(VirtualPath other) {
        ImmutableList<String> otherSegments = other.normalize().segments;
        ImmutableList<String> segments = this.normalize().segments;
        int otherSize = otherSegments.size();
        int size = segments.size();
        ListIterator iter = segments.listIterator();
        ListIterator otherIter = otherSegments.listIterator();
        while (iter.hasNext() && otherIter.hasNext()) {
            String otherNext;
            String next = (String)iter.next();
            if (next.equals(otherNext = (String)otherIter.next())) continue;
            int cnt = iter.nextIndex();
            FastList ml = new FastList(otherSize - cnt + size - cnt);
            ml.addAll(Collections.nCopies(size - cnt, ".."));
            otherIter.forEachRemaining(arg_0 -> ((MutableList)ml).add(arg_0));
            return new RelativeVirtualPath(this.fileSystem, (ImmutableList<String>)ml.toImmutable());
        }
        if (iter.hasNext()) {
            int cnt = iter.nextIndex();
            return new RelativeVirtualPath(this.fileSystem, (ImmutableList<String>)Lists.immutable.ofAll(Collections.nCopies(size - cnt, "..")));
        }
        if (otherIter.hasNext()) {
            return new RelativeVirtualPath(this.fileSystem, (ImmutableList<String>)otherSegments.subList(size, otherSize));
        }
        return this.fileSystem.getEmptyPath();
    }

    abstract RelativeVirtualPath relativize();

    abstract RelativeVirtualPath relativize(AbsoluteVirtualPath var1);

    abstract RelativeVirtualPath relativize(RelativeVirtualPath var1);

    public abstract boolean isAbsolute();

    public abstract AbsoluteVirtualPath getRoot();

    public abstract AbsoluteVirtualPath toAbsolutePath();

    @Override
    public int compareTo(VirtualPath other) {
        int n;
        if (other instanceof AbsoluteVirtualPath) {
            AbsoluteVirtualPath avp = (AbsoluteVirtualPath)other;
            n = this.compareTo(avp);
        } else if (other instanceof RelativeVirtualPath) {
            RelativeVirtualPath rvp = (RelativeVirtualPath)other;
            n = this.compareTo(rvp);
        } else {
            n = this.classCastInt();
        }
        return n;
    }

    @Override
    public abstract int compareTo(AbsoluteVirtualPath var1);

    @Override
    public abstract int compareTo(RelativeVirtualPath var1);

    int compareSegmentsTo(ImmutableList<String> otherSegments) {
        ImmutableList<String> segments = this.segments;
        int size = segments.size();
        int otherSize = otherSegments.size();
        int minSize = Math.min(size, otherSize);
        Comparator<String> cmp = this.getFileSystem().getPathSegmentComparator();
        for (int i = 0; i < minSize; ++i) {
            int res = cmp.compare((String)segments.get(i), (String)otherSegments.get(i));
            if (res == 0) continue;
            return res;
        }
        return Integer.compare(size, otherSize);
    }

    private int classCastInt() {
        throw new ClassCastException("Wrong Path type for this provider");
    }

    public final boolean equals(Object obj) {
        VirtualPath vp;
        return obj instanceof VirtualPath && this.equals(vp = (VirtualPath)obj);
    }

    public boolean equals(VirtualPath virtualPath) {
        return virtualPath == this || virtualPath != null && this.fileSystem.equals(virtualPath.fileSystem) && this.segments.equals(virtualPath.segments);
    }

    public int hashCode() {
        return this.fileSystem.hashCode() * 19 + this.segments.hashCode();
    }

    abstract VirtualPath copy(ImmutableList<String> var1);

    static <T> T cannotRelativize() {
        throw new IllegalArgumentException("The given path cannot be relativized against this path");
    }

    public String toString() {
        String toString = this.toString;
        if (toString == null) {
            toString = this.toString = this.toString(new StringBuilder()).toString();
        }
        return toString;
    }

    public StringBuilder toString(StringBuilder b) {
        Iterator iterator = this.segments.iterator();
        if (iterator.hasNext()) {
            String sep = this.fileSystem.getSeparator();
            b.append((String)iterator.next());
            while (iterator.hasNext()) {
                b.append(sep);
                b.append((String)iterator.next());
            }
        }
        return b;
    }
}

