/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import io.smallrye.common.constraint.Assert;
import java.util.Objects;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.factory.Iterables;
import org.qbicc.machine.vfs.AbsoluteVirtualPath;
import org.qbicc.machine.vfs.DriveLetterVirtualRootName;
import org.qbicc.machine.vfs.UncVirtualRootName;
import org.qbicc.machine.vfs.UnixVirtualRootName;
import org.qbicc.machine.vfs.VirtualFileSystem;

public abstract class VirtualRootName
implements Comparable<VirtualRootName> {
    private final AbsoluteVirtualPath rootPath;
    private final VirtualFileSystem fileSystem;

    VirtualRootName(VirtualFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.rootPath = new AbsoluteVirtualPath(this, (ImmutableList<String>)Iterables.iList());
    }

    public abstract String getName();

    public AbsoluteVirtualPath getRootPath() {
        return this.rootPath;
    }

    public VirtualFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder b) {
        return b.append(this.getName());
    }

    public boolean equals(Object obj) {
        VirtualRootName vrn;
        return obj instanceof VirtualRootName && this.equals(vrn = (VirtualRootName)obj);
    }

    public boolean equals(VirtualRootName other) {
        return this == other || other != null && this.rootPath.equals(other.rootPath) && this.fileSystem == other.fileSystem;
    }

    public int hashCode() {
        return Objects.hash(this.rootPath, this.fileSystem);
    }

    @Override
    public int compareTo(VirtualRootName o) {
        if (o instanceof DriveLetterVirtualRootName) {
            DriveLetterVirtualRootName vrn = (DriveLetterVirtualRootName)o;
            return this.compareTo(vrn);
        }
        if (o instanceof UncVirtualRootName) {
            UncVirtualRootName vrn = (UncVirtualRootName)o;
            return this.compareTo(vrn);
        }
        if (o instanceof UnixVirtualRootName) {
            UnixVirtualRootName vrn = (UnixVirtualRootName)o;
            return this.compareTo(vrn);
        }
        throw Assert.unreachableCode();
    }

    @Override
    abstract int compareTo(DriveLetterVirtualRootName var1);

    @Override
    abstract int compareTo(UncVirtualRootName var1);

    @Override
    abstract int compareTo(UnixVirtualRootName var1);
}

