/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Locale;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.SortedMaps;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharObjectMap;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.impl.factory.primitive.CharObjectMaps;
import org.qbicc.machine.vfs.AbsoluteVirtualPath;
import org.qbicc.machine.vfs.DirectoryNode;
import org.qbicc.machine.vfs.DriveLetterVirtualRootName;
import org.qbicc.machine.vfs.UncVirtualRootName;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;
import org.qbicc.machine.vfs.VirtualRoot;
import org.qbicc.machine.vfs.VirtualRootName;
import org.qbicc.machine.vio.VIOSystem;

public class WindowsVirtualFileSystem
extends VirtualFileSystem {
    private static final VarHandle cachedDriveLettersHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "cachedDriveLetters", VarHandle.class, WindowsVirtualFileSystem.class, ImmutableCharObjectMap.class);
    private static final VarHandle cachedUncHostsHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "cachedUncHosts", VarHandle.class, WindowsVirtualFileSystem.class, ImmutableMap.class);
    private static final VarHandle rootsHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "roots", VarHandle.class, WindowsVirtualFileSystem.class, ImmutableSortedMap.class);
    private final char defaultDriveLetter;
    private volatile ImmutableCharObjectMap<DriveLetterVirtualRootName> cachedDriveLetters;
    private volatile ImmutableMap<String, UncVirtualRootName> cachedUncHosts = Maps.immutable.empty();
    private volatile ImmutableSortedMap<VirtualRootName, VirtualRoot> roots;

    public WindowsVirtualFileSystem(VIOSystem vioSystem) {
        this(vioSystem, 'C');
    }

    public WindowsVirtualFileSystem(VIOSystem vioSystem, char defaultDriveLetter) {
        super(vioSystem, String::compareToIgnoreCase);
        this.defaultDriveLetter = Character.toUpperCase(defaultDriveLetter);
        DriveLetterVirtualRootName defaultRootName = new DriveLetterVirtualRootName(this, defaultDriveLetter);
        this.cachedDriveLetters = CharObjectMaps.immutable.of(defaultDriveLetter, (Object)defaultRootName);
        this.roots = SortedMaps.immutable.of((Object)defaultRootName, (Object)new VirtualRoot(defaultRootName, this));
    }

    @Override
    public VirtualRootName getDefaultRootName() {
        return (VirtualRootName)this.cachedDriveLetters.get(this.defaultDriveLetter);
    }

    @Override
    public String getSeparator() {
        return "\\";
    }

    @Override
    public List<AbsoluteVirtualPath> getRootDirectories() {
        return this.roots.collect((Function & Serializable)item -> item.getRootName().getRootPath()).toList();
    }

    public DriveLetterVirtualRootName getDriveLetterRootName(char driveLetter) {
        if ((driveLetter = Character.toUpperCase(driveLetter)) < 'A' || 'Z' < driveLetter) {
            throw new IllegalArgumentException();
        }
        ImmutableCharObjectMap<DriveLetterVirtualRootName> oldVal = this.cachedDriveLetters;
        DriveLetterVirtualRootName rootName = (DriveLetterVirtualRootName)oldVal.get(driveLetter);
        if (rootName != null) {
            return rootName;
        }
        DriveLetterVirtualRootName added = new DriveLetterVirtualRootName(this, driveLetter);
        ImmutableCharObjectMap newVal = oldVal.newWithKeyValue(driveLetter, (Object)added);
        while (!cachedDriveLettersHandle.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.cachedDriveLetters;
            rootName = (DriveLetterVirtualRootName)oldVal.get(driveLetter);
            if (rootName != null) {
                return rootName;
            }
            newVal = oldVal.newWithKeyValue(driveLetter, (Object)added);
        }
        return added;
    }

    public UncVirtualRootName getUncVirtualRootName(String hostName) {
        ImmutableMap<String, UncVirtualRootName> oldVal = this.cachedUncHosts;
        UncVirtualRootName rootName = (UncVirtualRootName)oldVal.get((Object)(hostName = hostName.toUpperCase(Locale.ROOT)));
        if (rootName != null) {
            return rootName;
        }
        UncVirtualRootName added = new UncVirtualRootName(this, hostName);
        ImmutableMap newVal = oldVal.newWithKeyValue((Object)hostName, (Object)added);
        while (!cachedUncHostsHandle.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.cachedUncHosts;
            rootName = (UncVirtualRootName)oldVal.get((Object)hostName);
            if (rootName != null) {
                return rootName;
            }
            newVal = oldVal.newWithKeyValue((Object)hostName, (Object)added);
        }
        return added;
    }

    public VirtualRoot getDrive(char driveLetter) {
        return this.get(this.getDriveLetterRootName(driveLetter));
    }

    public VirtualRoot get(VirtualRootName rootName) {
        return (VirtualRoot)this.roots.get((Object)rootName);
    }

    public VirtualRoot getOrMount(VirtualRootName rootName) {
        Assert.checkNotNullParam((String)"rootName", (Object)rootName);
        ImmutableSortedMap<VirtualRootName, VirtualRoot> oldVal = this.roots;
        VirtualRoot virtualRoot = (VirtualRoot)oldVal.get((Object)rootName);
        if (virtualRoot != null) {
            return virtualRoot;
        }
        VirtualRoot added = new VirtualRoot(rootName, this);
        ImmutableSortedMap newVal = oldVal.newWithKeyValue((Object)rootName, (Object)added);
        while (!rootsHandle.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.roots;
            virtualRoot = (VirtualRoot)oldVal.get((Object)rootName);
            if (virtualRoot != null) {
                return virtualRoot;
            }
            newVal = oldVal.newWithKeyValue((Object)rootName, (Object)added);
        }
        return added;
    }

    @Override
    public VirtualPath getPath(String first, String ... rest) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Windows");
    }

    @Override
    DirectoryNode getRootNode(VirtualRootName rootName) {
        VirtualRoot virtualRoot = (VirtualRoot)this.roots.get((Object)rootName);
        return virtualRoot == null ? null : virtualRoot.getRootDirectory();
    }

    @Override
    public boolean isHidden(VirtualPath path) throws IOException {
        return false;
    }
}

