/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vfs;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.qbicc.machine.vfs.DirectoryNode;
import org.qbicc.machine.vfs.Node;
import org.qbicc.machine.vfs.VirtualFileStatBuffer;
import org.qbicc.machine.vfs.VirtualFileSystem;

final class ZipEntryNode
extends Node {
    private final ZipFile zf;
    private final ZipEntry ze;
    private final long defaultTime = System.currentTimeMillis();

    ZipEntryNode(ZipFile zf, ZipEntry ze) {
        this.zf = zf;
        this.ze = ze;
    }

    @Override
    VirtualFileStatBuffer statExisting() {
        int attr = 1;
        FileTime ctime = this.ze.getCreationTime();
        FileTime mtime = this.ze.getLastModifiedTime();
        if (ctime == null) {
            ctime = mtime == null ? (mtime = FileTime.fromMillis(this.defaultTime)) : mtime;
        } else if (mtime == null) {
            mtime = ctime;
        }
        FileTime atime = this.ze.getLastAccessTime();
        if (atime == null) {
            atime = mtime;
        }
        return new VirtualFileStatBuffer(mtime.toMillis(), atime.toMillis(), ctime.toMillis(), attr | (this.ze.isDirectory() ? 4 : 2), this.ze.getSize(), this.getNodeId());
    }

    @Override
    int openExisting(int fd, VirtualFileSystem vfs, DirectoryNode parent, int flags) throws IOException {
        if ((flags & 3) != 0) {
            throw ZipEntryNode.notWritable();
        }
        return vfs.getVioSystem().openZipFileEntryForInput(this.zf, this.ze);
    }

    @Override
    int getMode() {
        return 292;
    }

    @Override
    void changeMode(int newMode) throws AccessDeniedException {
        throw ZipEntryNode.notWritable();
    }

    private static AccessDeniedException notWritable() {
        return new AccessDeniedException("Zip entries are not writable");
    }
}

