/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vio;

import io.smallrye.common.function.ExceptionRunnable;
import java.io.IOException;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.qbicc.machine.vio.IoHandler;
import org.qbicc.machine.vio.ReadableIoHandler;
import org.qbicc.machine.vio.SeekableIoHandler;
import org.qbicc.machine.vio.StatableIoHandler;
import org.qbicc.machine.vio.WritableIoHandler;

final class FileChannelHandler
implements IoHandler,
ReadableIoHandler,
WritableIoHandler,
SeekableIoHandler,
StatableIoHandler {
    private static final VarHandle closedHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "closed", VarHandle.class, FileChannelHandler.class, Boolean.TYPE);
    private final FileChannel channel;
    private final boolean append;
    private final ByteBuffer singleByte = ByteBuffer.allocateDirect(1);
    private final ExceptionRunnable<IOException> closeAction;
    private volatile boolean closed;

    FileChannelHandler(FileChannel channel, boolean append, ExceptionRunnable<IOException> closeAction) {
        this.channel = channel;
        this.append = append;
        this.closeAction = closeAction;
    }

    @Override
    public void close() throws IOException {
        if (closedHandle.compareAndSet(this, false, true)) {
            try {
                this.channel.close();
            }
            finally {
                this.closeAction.run();
            }
        }
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        return this.channel.read(buf);
    }

    @Override
    public int readSingle() throws IOException {
        ByteBuffer singleByte = this.singleByte;
        singleByte.position(0);
        int cnt = this.channel.read(singleByte);
        return cnt == -1 ? -1 : (int)singleByte.get(0);
    }

    @Override
    public long available() throws IOException {
        long size = this.channel.size();
        long offset = this.channel.position();
        return Math.max(0L, size - offset);
    }

    @Override
    public int write(ByteBuffer buf) throws IOException {
        return this.channel.write(buf);
    }

    @Override
    public int append(ByteBuffer buf) throws IOException {
        this.channel.position(this.channel.size());
        return this.channel.write(buf);
    }

    @Override
    public void writeSingle(int value) throws IOException {
        ByteBuffer singleByte = this.singleByte;
        singleByte.position(0);
        singleByte.put(0, (byte)value);
        if (this.channel.write(singleByte) == 0) {
            throw new IOException("Would block");
        }
    }

    @Override
    public void appendSingle(int value) throws IOException {
        this.channel.position(this.channel.size());
        ByteBuffer singleByte = this.singleByte;
        singleByte.position(0);
        singleByte.put(0, (byte)value);
        if (this.channel.write(singleByte) == 0) {
            throw new IOException("Would block");
        }
    }

    @Override
    public boolean isAppend() {
        return this.append;
    }

    @Override
    public long seekRelative(long offs) throws IOException {
        long oldPosition = this.channel.position();
        if (offs != 0L) {
            this.channel.position(oldPosition + offs);
        }
        return oldPosition;
    }

    @Override
    public long seekAbsolute(long offs) throws IOException {
        long oldPosition = this.channel.position();
        if (offs != oldPosition) {
            this.channel.position(offs);
        }
        return oldPosition;
    }

    @Override
    public long getSize() throws IOException {
        return this.channel.size();
    }
}

