/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.qbicc.machine.vio.IoHandler;
import org.qbicc.machine.vio.ReadableIoHandler;
import org.qbicc.machine.vio.SeekableIoHandler;
import org.qbicc.machine.vio.Utils;

class InputStreamHandler
implements IoHandler,
ReadableIoHandler,
SeekableIoHandler {
    private final InputStream is;
    private long pos;

    InputStreamHandler(InputStream is) {
        this.is = is;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        int cnt = Utils.readInto(this.is, buf);
        if (cnt > 0) {
            this.pos += (long)cnt;
        }
        return cnt;
    }

    @Override
    public int readSingle() throws IOException {
        return this.is.read();
    }

    @Override
    public long available() throws IOException {
        return this.is.available();
    }

    @Override
    public long seekRelative(long offs) throws IOException {
        if (offs == 0L) {
            return this.pos;
        }
        if (offs > 0L) {
            this.is.skipNBytes(offs);
            this.pos += offs;
            return this.pos;
        }
        throw new IOException("Cannot seek backwards");
    }

    @Override
    public long seekAbsolute(long offs) throws IOException {
        return this.seekRelative(offs - this.pos);
    }
}

