/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.qbicc.machine.vio.IoHandler;
import org.qbicc.machine.vio.Utils;
import org.qbicc.machine.vio.WritableIoHandler;

final class OutputStreamHandler
implements IoHandler,
WritableIoHandler {
    private final OutputStream os;

    OutputStreamHandler(OutputStream os) {
        this.os = os;
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    @Override
    public boolean isAppend() {
        return true;
    }

    @Override
    public int write(ByteBuffer buf) throws IOException {
        return Utils.writeFrom(this.os, buf);
    }

    @Override
    public void writeSingle(int value) throws IOException {
        this.os.write(value);
    }

    @Override
    public int append(ByteBuffer buf) throws IOException {
        return this.write(buf);
    }

    @Override
    public void appendSingle(int value) throws IOException {
        this.writeSingle(value);
    }
}

