/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import org.qbicc.machine.vio.ReadableIoHandler;

final class PipeSourceHandler
implements ReadableIoHandler {
    private final Pipe.SourceChannel source;
    private final ByteBuffer singleByte = ByteBuffer.allocateDirect(1);

    PipeSourceHandler(Pipe.SourceChannel source) {
        this.source = source;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        return this.source.read(buf);
    }

    @Override
    public int readSingle() throws IOException {
        ByteBuffer singleByte = this.singleByte;
        singleByte.position(0);
        int cnt = this.source.read(singleByte);
        return cnt == -1 ? -1 : (int)singleByte.get(0);
    }

    @Override
    public long available() {
        return 0L;
    }
}

