/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import org.qbicc.machine.vio.DuplexIoHandler;
import org.qbicc.machine.vio.ReadableIoHandler;
import org.qbicc.machine.vio.WritableIoHandler;

final class SocketPairHandler
implements ReadableIoHandler,
WritableIoHandler,
DuplexIoHandler {
    private final Pipe.SourceChannel source;
    private final Pipe.SinkChannel sink;
    private final ByteBuffer singleByte = ByteBuffer.allocateDirect(1);

    SocketPairHandler(Pipe.SourceChannel source, Pipe.SinkChannel sink) {
        this.source = source;
        this.sink = sink;
    }

    @Override
    public boolean isAppend() {
        return true;
    }

    @Override
    public void shutdownInput() throws IOException {
        this.source.close();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.sink.close();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
        this.sink.close();
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        try {
            return this.source.read(buf);
        }
        catch (ClosedChannelException e) {
            return -1;
        }
    }

    @Override
    public int readSingle() throws IOException {
        ByteBuffer singleByte = this.singleByte;
        singleByte.position(0);
        int cnt = this.source.read(singleByte);
        return cnt == -1 ? -1 : (int)singleByte.get(0);
    }

    @Override
    public long available() {
        return 0L;
    }

    @Override
    public int write(ByteBuffer buf) throws IOException {
        return this.sink.write(buf);
    }

    @Override
    public void writeSingle(int value) throws IOException {
        ByteBuffer singleByte = this.singleByte;
        singleByte.position(0);
        singleByte.put(0, (byte)value);
        if (this.sink.write(singleByte) == 0) {
            throw new IOException("Would block");
        }
    }

    @Override
    public int append(ByteBuffer buf) throws IOException {
        return this.write(buf);
    }

    @Override
    public void appendSingle(int value) throws IOException {
        this.writeSingle(value);
    }
}

