/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vio;

import io.smallrye.common.function.ExceptionBiConsumer;
import io.smallrye.common.function.ExceptionBiFunction;
import io.smallrye.common.function.ExceptionBiPredicate;
import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionFunction;
import io.smallrye.common.function.ExceptionObjIntConsumer;
import io.smallrye.common.function.ExceptionObjLongConsumer;
import io.smallrye.common.function.ExceptionPredicate;
import io.smallrye.common.function.ExceptionSupplier;
import io.smallrye.common.function.ExceptionToLongBiFunction;
import io.smallrye.common.function.ExceptionToLongFunction;
import java.io.IOException;
import org.qbicc.machine.vio.AlreadyOpenException;
import org.qbicc.machine.vio.BadDescriptorException;
import org.qbicc.machine.vio.ExceptionObjLongToLongFunction;
import org.qbicc.machine.vio.IoHandler;

final class VIOFile {
    private int refCnt;
    private IoHandler handler;

    VIOFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(ExceptionSupplier<IoHandler, IOException> factory) throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            if (this.handler != null) {
                throw new AlreadyOpenException();
            }
            IoHandler handler = (IoHandler)factory.get();
            assert (this.refCnt == 0);
            this.refCnt = 1;
            this.handler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireOne() throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            int refCnt = this.refCnt;
            if (refCnt == 0) {
                throw new BadDescriptorException();
            }
            this.refCnt = refCnt + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseOne() throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            if (--this.refCnt == 0) {
                IoHandler handler = this.handler;
                this.handler = null;
                handler.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <H extends IoHandler> void run(Class<H> handlerType, ExceptionConsumer<H, IOException> action) throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            IoHandler handler = this.handler;
            if (!handlerType.isInstance(handler)) {
                throw BadDescriptorException.fileNotOpen();
            }
            action.accept((Object)((IoHandler)handlerType.cast(handler)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <H extends IoHandler, T> void run(Class<H> handlerType, T argument, ExceptionBiConsumer<H, T, IOException> action) throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            IoHandler handler = this.handler;
            if (!handlerType.isInstance(handler)) {
                throw BadDescriptorException.fileNotOpen();
            }
            action.accept((Object)((IoHandler)handlerType.cast(handler)), argument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <H extends IoHandler> void run(Class<H> handlerType, long argument, ExceptionObjLongConsumer<H, IOException> action) throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            IoHandler handler = this.handler;
            if (!handlerType.isInstance(handler)) {
                throw BadDescriptorException.fileNotOpen();
            }
            action.accept((Object)((IoHandler)handlerType.cast(handler)), argument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <H extends IoHandler> void run(Class<H> handlerType, int argument, ExceptionObjIntConsumer<H, IOException> action) throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            IoHandler handler = this.handler;
            if (!handlerType.isInstance(handler)) {
                throw BadDescriptorException.fileNotOpen();
            }
            action.accept((Object)((IoHandler)handlerType.cast(handler)), argument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <H extends IoHandler, R> R call(Class<H> handlerType, ExceptionFunction<H, R, IOException> action) throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            IoHandler handler = this.handler;
            if (!handlerType.isInstance(handler)) {
                throw BadDescriptorException.fileNotOpen();
            }
            return (R)action.apply((Object)((IoHandler)handlerType.cast(handler)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <H extends IoHandler> long call(Class<H> handlerType, long argument, ExceptionObjLongToLongFunction<H, IOException> action) throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            IoHandler handler = this.handler;
            if (!handlerType.isInstance(handler)) {
                throw BadDescriptorException.fileNotOpen();
            }
            return action.applyAsLong((IoHandler)handlerType.cast(handler), argument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <H extends IoHandler, T, R> R call(Class<H> handlerType, T argument, ExceptionBiFunction<H, T, R, IOException> action) throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            IoHandler handler = this.handler;
            if (!handlerType.isInstance(handler)) {
                throw BadDescriptorException.fileNotOpen();
            }
            return (R)action.apply((Object)((IoHandler)handlerType.cast(handler)), argument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <H extends IoHandler> long call(Class<H> handlerType, ExceptionToLongFunction<H, IOException> action) throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            IoHandler handler = this.handler;
            if (!handlerType.isInstance(handler)) {
                throw BadDescriptorException.fileNotOpen();
            }
            return action.apply((Object)((IoHandler)handlerType.cast(handler)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <H extends IoHandler, T> long call(Class<H> handlerType, T argument, ExceptionToLongBiFunction<H, T, IOException> action) throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            IoHandler handler = this.handler;
            if (!handlerType.isInstance(handler)) {
                throw BadDescriptorException.fileNotOpen();
            }
            return action.apply((Object)((IoHandler)handlerType.cast(handler)), argument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <H extends IoHandler> boolean test(Class<H> handlerType, ExceptionPredicate<H, IOException> action) throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            IoHandler handler = this.handler;
            if (!handlerType.isInstance(handler)) {
                throw BadDescriptorException.fileNotOpen();
            }
            return action.test((Object)((IoHandler)handlerType.cast(handler)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <H extends IoHandler, T> boolean test(Class<H> handlerType, T argument, ExceptionBiPredicate<H, T, IOException> action) throws IOException {
        VIOFile vIOFile = this;
        synchronized (vIOFile) {
            IoHandler handler = this.handler;
            if (!handlerType.isInstance(handler)) {
                throw BadDescriptorException.fileNotOpen();
            }
            return action.test((Object)((IoHandler)handlerType.cast(handler)), argument);
        }
    }
}

