/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.vio;

import io.smallrye.common.function.ExceptionBiConsumer;
import io.smallrye.common.function.ExceptionBiFunction;
import io.smallrye.common.function.ExceptionBiPredicate;
import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionFunction;
import io.smallrye.common.function.ExceptionObjIntConsumer;
import io.smallrye.common.function.ExceptionObjLongConsumer;
import io.smallrye.common.function.ExceptionPredicate;
import io.smallrye.common.function.ExceptionRunnable;
import io.smallrye.common.function.ExceptionSupplier;
import io.smallrye.common.function.ExceptionToLongBiFunction;
import io.smallrye.common.function.ExceptionToLongFunction;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.qbicc.machine.vio.BadDescriptorException;
import org.qbicc.machine.vio.DirectoryIoHandler;
import org.qbicc.machine.vio.DuplexIoHandler;
import org.qbicc.machine.vio.ExceptionObjLongToLongFunction;
import org.qbicc.machine.vio.FileChannelHandler;
import org.qbicc.machine.vio.InputStreamHandler;
import org.qbicc.machine.vio.IoHandler;
import org.qbicc.machine.vio.OutputStreamHandler;
import org.qbicc.machine.vio.PipeSinkHandler;
import org.qbicc.machine.vio.PipeSourceHandler;
import org.qbicc.machine.vio.ReadableIoHandler;
import org.qbicc.machine.vio.SeekableIoHandler;
import org.qbicc.machine.vio.SeekableReadableIoHandler;
import org.qbicc.machine.vio.SocketPairHandler;
import org.qbicc.machine.vio.StatableIoHandler;
import org.qbicc.machine.vio.TooManyOpenFilesException;
import org.qbicc.machine.vio.VIOFile;
import org.qbicc.machine.vio.VIOFileDescriptor;
import org.qbicc.machine.vio.WritableIoHandler;
import org.qbicc.machine.vio.ZipEntryInputStreamHandler;

public final class VIOSystem {
    private final VIOFileDescriptor[] fileDescArray;

    public VIOSystem(int maxFiles) {
        int len = Math.max(16, maxFiles);
        VIOFileDescriptor[] array = new VIOFileDescriptor[len];
        for (int i = 0; i < len; ++i) {
            array[i] = new VIOFileDescriptor(i);
        }
        this.fileDescArray = array;
    }

    public int open(ExceptionSupplier<IoHandler, IOException> factory) throws IOException {
        return this.allocateFd((ExceptionConsumer<VIOFileDescriptor, IOException>)((ExceptionConsumer)newDesc -> {
            VIOFile file;
            VIOFile vIOFile = file = new VIOFile();
            synchronized (vIOFile) {
                file.open(factory);
                newDesc.setFile(file);
            }
        })).getFdNum();
    }

    public void replace(int fd, ExceptionSupplier<IoHandler, IOException> factory) throws IOException {
        this.rangeCheck(fd);
        VIOFile file = new VIOFile();
        file.open(factory);
        VIOFile oldFile = this.fileDescArray[fd].replaceFile(file);
        if (oldFile != null) {
            try {
                oldFile.releaseOne();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int openInputStream(ExceptionSupplier<InputStream, IOException> factory) throws IOException {
        return this.open((ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> VIOSystem.makeInputStreamHandler(factory)));
    }

    public void openInputStream(int fd, ExceptionSupplier<InputStream, IOException> factory) throws IOException {
        this.replace(fd, (ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> VIOSystem.makeInputStreamHandler(factory)));
    }

    public int openOutputStream(ExceptionSupplier<OutputStream, IOException> factory) throws IOException {
        return this.open((ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> new OutputStreamHandler((OutputStream)factory.get())));
    }

    public void openOutputStream(int fd, ExceptionSupplier<OutputStream, IOException> factory) throws IOException {
        this.replace(fd, (ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> new OutputStreamHandler((OutputStream)factory.get())));
    }

    public int openPipeSource(ExceptionSupplier<Pipe.SourceChannel, IOException> factory) throws IOException {
        return this.open((ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> new PipeSourceHandler((Pipe.SourceChannel)factory.get())));
    }

    public void openPipeSource(int fd, ExceptionSupplier<Pipe.SourceChannel, IOException> factory) throws IOException {
        this.replace(fd, (ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> new PipeSourceHandler((Pipe.SourceChannel)factory.get())));
    }

    public int openPipeSink(ExceptionSupplier<Pipe.SinkChannel, IOException> factory) throws IOException {
        return this.open((ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> new PipeSinkHandler((Pipe.SinkChannel)factory.get())));
    }

    public void openPipeSink(int fd, ExceptionSupplier<Pipe.SinkChannel, IOException> factory) throws IOException {
        this.replace(fd, (ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> new PipeSinkHandler((Pipe.SinkChannel)factory.get())));
    }

    private static IoHandler makeInputStreamHandler(ExceptionSupplier<InputStream, IOException> factory) throws IOException {
        InputStream is = (InputStream)factory.get();
        if (is instanceof FileInputStream) {
            FileInputStream fis = (FileInputStream)is;
            return new FileChannelHandler(fis.getChannel(), false, (ExceptionRunnable<IOException>)((ExceptionRunnable)() -> {}));
        }
        return new InputStreamHandler(is);
    }

    public int[] pipe() throws IOException {
        int writeFd;
        int readFd;
        Pipe pipe = Pipe.open();
        try {
            readFd = this.openPipeSource((ExceptionSupplier<Pipe.SourceChannel, IOException>)((ExceptionSupplier)pipe::source));
            try {
                writeFd = this.openPipeSink((ExceptionSupplier<Pipe.SinkChannel, IOException>)((ExceptionSupplier)pipe::sink));
            }
            catch (Throwable t) {
                this.safeClose(readFd, t);
                throw t;
            }
        }
        catch (Throwable t) {
            this.safeClose(pipe.source(), t);
            this.safeClose(pipe.sink(), t);
            throw t;
        }
        return new int[]{readFd, writeFd};
    }

    public int[] socketPair() throws IOException {
        int rightFd;
        int leftFd;
        Pipe a = Pipe.open();
        try {
            Pipe b = Pipe.open();
            try {
                leftFd = this.open((ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> new SocketPairHandler(a.source(), b.sink())));
                try {
                    rightFd = this.open((ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> new SocketPairHandler(b.source(), a.sink())));
                }
                catch (Throwable t) {
                    this.safeClose(leftFd, t);
                    throw t;
                }
            }
            catch (Throwable t) {
                this.safeClose(b.source(), t);
                this.safeClose(b.sink(), t);
                throw t;
            }
        }
        catch (Throwable t) {
            this.safeClose(a.source(), t);
            this.safeClose(a.sink(), t);
            throw t;
        }
        return new int[]{leftFd, rightFd};
    }

    public int openRealFile(Path path, Set<? extends OpenOption> options, Set<? extends FileAttribute<?>> attrs) throws IOException {
        return this.openRealFile(path, options, attrs, (ExceptionRunnable<IOException>)((ExceptionRunnable)() -> {}));
    }

    public int openRealFile(Path path, Set<? extends OpenOption> options, Set<? extends FileAttribute<?>> attrs, ExceptionRunnable<IOException> closeAction) throws IOException {
        boolean append = options.contains(StandardOpenOption.APPEND);
        return this.open((ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> new FileChannelHandler(FileChannel.open(path, options, (FileAttribute[])attrs.toArray(FileAttribute[]::new)), append, closeAction)));
    }

    public void openRealFile(int fd, Path path, Set<? extends OpenOption> options, Set<? extends FileAttribute<?>> attrs) throws IOException {
        this.openRealFile(fd, path, options, attrs, (ExceptionRunnable<IOException>)((ExceptionRunnable)() -> {}));
    }

    public void openRealFile(int fd, Path path, Set<? extends OpenOption> options, Set<? extends FileAttribute<?>> attrs, ExceptionRunnable<IOException> closeAction) throws IOException {
        boolean append = options.contains(StandardOpenOption.APPEND);
        this.replace(fd, (ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> new FileChannelHandler(FileChannel.open(path, options, (FileAttribute[])attrs.toArray(FileAttribute[]::new)), append, closeAction)));
    }

    public int openZipFileEntryForInput(ZipFile zf, ZipEntry ze) throws IOException {
        return this.open((ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> new ZipEntryInputStreamHandler(ze, zf.getInputStream(ze))));
    }

    public void openZipFileEntryForInput(int fd, ZipFile zf, ZipEntry ze) throws IOException {
        this.replace(fd, (ExceptionSupplier<IoHandler, IOException>)((ExceptionSupplier)() -> new ZipEntryInputStreamHandler(ze, zf.getInputStream(ze))));
    }

    public int dup(int origFd) throws IOException {
        this.rangeCheck(origFd);
        return this.allocateFd((ExceptionConsumer<VIOFileDescriptor, IOException>)((ExceptionConsumer)newDesc -> {
            VIOFile file = this.fileDescArray[origFd].getFile();
            if (file == null) {
                throw BadDescriptorException.fileNotOpen();
            }
            file.acquireOne();
            newDesc.setFile(file);
        })).getFdNum();
    }

    public void dup2(int origFd, int newFd) throws IOException {
        this.rangeCheck(newFd);
        if (origFd == newFd) {
            throw new BadDescriptorException("origFd must not equal newFd");
        }
        VIOFile file = this.findFile(origFd);
        file.acquireOne();
        VIOFile oldFile = this.fileDescArray[newFd].replaceFile(file);
        if (oldFile != null) {
            try {
                oldFile.releaseOne();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void close(int fd) throws IOException {
        this.findFile(fd).releaseOne();
    }

    public void shutdownInput(int fd) throws IOException {
        this.run(fd, DuplexIoHandler.class, DuplexIoHandler::shutdownInput);
    }

    public void shutdownOutput(int fd) throws IOException {
        this.run(fd, DuplexIoHandler.class, DuplexIoHandler::shutdownOutput);
    }

    public int read(int fd, ByteBuffer buffer) throws IOException {
        return (int)this.call(fd, ReadableIoHandler.class, buffer, ReadableIoHandler::read);
    }

    public int pread(int fd, ByteBuffer buffer, long position) throws IOException {
        return (int)this.call(fd, SeekableReadableIoHandler.class, buffer, (seekableReadableIoHandler, byteBuffer) -> seekableReadableIoHandler.pread((ByteBuffer)byteBuffer, position));
    }

    public int readSingle(int fd) throws IOException {
        return (int)this.call(fd, ReadableIoHandler.class, ReadableIoHandler::readSingle);
    }

    public long available(int fd) throws IOException {
        return this.call(fd, ReadableIoHandler.class, ReadableIoHandler::available);
    }

    public String readDirectoryEntry(int fd) throws IOException {
        return (String)this.call(fd, DirectoryIoHandler.class, DirectoryIoHandler::readEntry);
    }

    public int write(int fd, ByteBuffer buffer) throws IOException {
        return (int)this.call(fd, WritableIoHandler.class, buffer, WritableIoHandler::write);
    }

    public void writeSingle(int fd, int val) throws IOException {
        this.run(fd, WritableIoHandler.class, val, WritableIoHandler::writeSingle);
    }

    public boolean isAppend(int fd) throws IOException {
        return this.test(fd, WritableIoHandler.class, WritableIoHandler::isAppend);
    }

    public long getFileSize(int fd) throws IOException {
        return this.call(fd, StatableIoHandler.class, StatableIoHandler::getSize);
    }

    public long seekAbsolute(int fd, long offs) throws IOException {
        return this.call(fd, SeekableIoHandler.class, offs, SeekableIoHandler::seekAbsolute);
    }

    public long seekRelative(int fd, long offs) throws IOException {
        return this.call(fd, SeekableIoHandler.class, offs, SeekableIoHandler::seekRelative);
    }

    public <H extends IoHandler> void run(int fd, Class<H> handlerType, ExceptionConsumer<H, IOException> action) throws IOException {
        this.findFile(fd).run(handlerType, action);
    }

    public <H extends IoHandler, T> void run(int fd, Class<H> handlerType, T argument, ExceptionBiConsumer<H, T, IOException> action) throws IOException {
        this.findFile(fd).run(handlerType, argument, action);
    }

    public <H extends IoHandler> void run(int fd, Class<H> handlerType, long argument, ExceptionObjLongConsumer<H, IOException> action) throws IOException {
        this.findFile(fd).run(handlerType, argument, action);
    }

    public <H extends IoHandler> void run(int fd, Class<H> handlerType, int argument, ExceptionObjIntConsumer<H, IOException> action) throws IOException {
        this.findFile(fd).run(handlerType, argument, action);
    }

    public <H extends IoHandler, R> R call(int fd, Class<H> handlerType, ExceptionFunction<H, R, IOException> action) throws IOException {
        return this.findFile(fd).call(handlerType, action);
    }

    public <H extends IoHandler, T, R> R call(int fd, Class<H> handlerType, T argument, ExceptionBiFunction<H, T, R, IOException> action) throws IOException {
        return this.findFile(fd).call(handlerType, argument, action);
    }

    public <H extends IoHandler> long call(int fd, Class<H> handlerType, ExceptionToLongFunction<H, IOException> action) throws IOException {
        return this.findFile(fd).call(handlerType, action);
    }

    public <H extends IoHandler> long call(int fd, Class<H> handlerType, long argument, ExceptionObjLongToLongFunction<H, IOException> action) throws IOException {
        return this.findFile(fd).call(handlerType, argument, action);
    }

    public <H extends IoHandler, T> long call(int fd, Class<H> handlerType, T argument, ExceptionToLongBiFunction<H, T, IOException> action) throws IOException {
        return this.findFile(fd).call(handlerType, argument, action);
    }

    public <H extends IoHandler> boolean test(int fd, Class<H> handlerType, ExceptionPredicate<H, IOException> action) throws IOException {
        return this.findFile(fd).test(handlerType, action);
    }

    public <H extends IoHandler, T> boolean test(int fd, Class<H> handlerType, T argument, ExceptionBiPredicate<H, T, IOException> action) throws IOException {
        return this.findFile(fd).test(handlerType, argument, action);
    }

    private VIOFile findFile(int fd) throws BadDescriptorException {
        this.rangeCheck(fd);
        VIOFileDescriptor desc = this.fileDescArray[fd];
        VIOFile file = desc.getFile();
        if (file == null) {
            throw BadDescriptorException.fileNotOpen();
        }
        return file;
    }

    private void rangeCheck(int origFd) throws BadDescriptorException {
        if (origFd < 0 || origFd >= this.fileDescArray.length) {
            throw new BadDescriptorException("File descriptor out of range");
        }
    }

    private VIOFileDescriptor allocateFd(ExceptionConsumer<VIOFileDescriptor, IOException> action) throws IOException {
        for (VIOFileDescriptor desc : this.fileDescArray) {
            if (!desc.tryOpen(action)) continue;
            return desc;
        }
        throw new TooManyOpenFilesException();
    }

    private void safeClose(Closeable closeable, Throwable t) {
        try {
            closeable.close();
        }
        catch (Throwable t2) {
            t.addSuppressed(t2);
        }
    }

    private void safeClose(int fd, Throwable t) {
        try {
            this.close(fd);
        }
        catch (Throwable t2) {
            t.addSuppressed(t2);
        }
    }
}

