/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.main;

import io.smallrye.common.constraint.Assert;
import java.nio.file.Path;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import picocli.CommandLine;

public abstract class ClassPathEntry {
    ClassPathEntry() {
    }

    public static FilePath of(Path path) {
        Assert.checkNotNullParam((String)"path", (Object)path);
        return new FilePath(path);
    }

    public static MavenArtifact of(Artifact artifact) {
        Assert.checkNotNullParam((String)"artifact", (Object)artifact);
        return new MavenArtifact(artifact);
    }

    public static ClassLibraries ofClassLibraries(String version) {
        Assert.checkNotNullParam((String)"version", (Object)version);
        return new ClassLibraries(version);
    }

    public static final class FilePath
    extends ClassPathEntry {
        private final Path path;

        FilePath(Path path) {
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        public static final class Converter
        implements CommandLine.ITypeConverter<FilePath> {
            public FilePath convert(String value) {
                return ClassPathEntry.of(Path.of(value, new String[0]));
            }
        }
    }

    public static final class MavenArtifact
    extends ClassPathEntry {
        private final Artifact artifact;

        MavenArtifact(Artifact artifact) {
            this.artifact = artifact;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public static final class Converter
        implements CommandLine.ITypeConverter<MavenArtifact> {
            public MavenArtifact convert(String value) {
                return ClassPathEntry.of((Artifact)new DefaultArtifact(value));
            }
        }
    }

    public static final class ClassLibraries
    extends ClassPathEntry {
        private final String version;

        ClassLibraries(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

