/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.main;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.qbicc.context.Diagnostic;
import org.qbicc.context.DiagnosticContext;
import org.qbicc.driver.ClassPathElement;
import org.qbicc.driver.ClassPathItem;
import org.qbicc.main.ClassPathEntry;

public final class DefaultArtifactRequestor {
    public List<ClassPathItem> requestArtifactsFromRepositories(RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remoteRepositoryList, List<ClassPathEntry> classPathList, DiagnosticContext ctxt, Runtime.Version version) throws IOException {
        DependencyResult dependencyResult;
        CollectRequest collectRequest = new CollectRequest((Dependency)null, null, system.newResolutionRepositories(session, remoteRepositoryList));
        HashMap<String, Map<String, ClassPathEntry>> gaToCpe = new HashMap<String, Map<String, ClassPathEntry>>();
        for (ClassPathEntry classPathEntry : classPathList) {
            Dependency dependency;
            Artifact artifact;
            if (classPathEntry instanceof ClassPathEntry.ClassLibraries) {
                ClassPathEntry.ClassLibraries cl = (ClassPathEntry.ClassLibraries)classPathEntry;
                artifact = new DefaultArtifact("org.qbicc.rt", "qbicc-rt", "", "pom", cl.getVersion());
                dependency = new Dependency(artifact, "runtime", Boolean.FALSE);
                collectRequest.addDependency(dependency);
                gaToCpe.computeIfAbsent(artifact.getGroupId(), DefaultArtifactRequestor::newMap).put(artifact.getArtifactId(), classPathEntry);
                continue;
            }
            if (classPathEntry instanceof ClassPathEntry.MavenArtifact) {
                ClassPathEntry.MavenArtifact ma = (ClassPathEntry.MavenArtifact)classPathEntry;
                artifact = ma.getArtifact();
                dependency = new Dependency(artifact, "runtime", Boolean.FALSE);
                collectRequest.addDependency(dependency);
                gaToCpe.computeIfAbsent(artifact.getGroupId(), DefaultArtifactRequestor::newMap).put(artifact.getArtifactId(), classPathEntry);
                continue;
            }
            if (!(classPathEntry instanceof ClassPathEntry.FilePath)) continue;
        }
        DependencyRequest depReq = new DependencyRequest(collectRequest, null);
        try {
            dependencyResult = system.resolveDependencies(session, depReq);
        }
        catch (DependencyResolutionException e) {
            Diagnostic parent = ctxt.error("Failed to resolve dependencies: %s", new Object[]{e});
            DependencyResult result = e.getResult();
            List artifactResults = result.getArtifactResults();
            for (ArtifactResult artifactResult : artifactResults) {
                List exceptions = artifactResult.getExceptions();
                for (Exception exception : exceptions) {
                    ctxt.error(parent, "Resolve of %s failed: %s", new Object[]{artifactResult.getRequest().getArtifact(), exception});
                }
            }
            for (Exception collectException : result.getCollectExceptions()) {
                ctxt.error(parent, "Collect exception: %s", new Object[]{collectException});
            }
            return List.of();
        }
        List artifactResults = dependencyResult.getArtifactResults();
        HashMap resultMapping = new HashMap();
        for (ArtifactResult result : artifactResults) {
            DependencyNode node = result.getRequest().getDependencyNode();
            ClassPathEntry entry = DefaultArtifactRequestor.findDependency(node, gaToCpe);
            if (entry != null) {
                resultMapping.computeIfAbsent(entry, DefaultArtifactRequestor::newList).add(result);
                DefaultArtifactRequestor.populateChildren(entry, node, gaToCpe);
            }
            Artifact resultArtifact = result.getArtifact();
            if (result.isMissing()) {
                ctxt.error("Required artifact is missing: %s", new Object[]{resultArtifact});
                continue;
            }
            if (result.isResolved()) continue;
            ctxt.error("Required artifact is not missing but wasn't resolved: %s", new Object[]{resultArtifact});
        }
        ArrayList<ClassPathItem> resultList = new ArrayList<ClassPathItem>();
        LinkedHashSet unmappedResults = new LinkedHashSet(artifactResults);
        try {
            for (ClassPathEntry classPathEntry : classPathList) {
                if (classPathEntry instanceof ClassPathEntry.MavenArtifact || classPathEntry instanceof ClassPathEntry.ClassLibraries) {
                    for (ArtifactResult artifactResult : resultMapping.getOrDefault(classPathEntry, List.of())) {
                        unmappedResults.remove(artifactResult);
                        DefaultArtifactRequestor.appendArtifactResult(system, session, resultList, artifactResult, version);
                    }
                    continue;
                }
                if (!(classPathEntry instanceof ClassPathEntry.FilePath)) continue;
                ClassPathEntry.FilePath fp = (ClassPathEntry.FilePath)classPathEntry;
                Path path = fp.getPath();
                if (Files.isDirectory(path, new LinkOption[0])) {
                    resultList.add(new ClassPathItem(path.toString(), List.of(ClassPathElement.forDirectory((Path)path)), List.of()));
                    continue;
                }
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    ClassPathElement element = ClassPathElement.forJarFile((Path)path, (Runtime.Version)version);
                    try {
                        resultList.add(new ClassPathItem(path.toString(), List.of(element), List.of()));
                        continue;
                    }
                    catch (Throwable t) {
                        element.close();
                        throw t;
                    }
                }
                if (Files.exists(path, new LinkOption[0])) continue;
                ctxt.warning("Class path entry \"%s\" does not exist", new Object[]{path});
            }
            for (ArtifactResult unmappedResult : unmappedResults) {
                DefaultArtifactRequestor.appendArtifactResult(system, session, resultList, unmappedResult, version);
            }
        }
        catch (Throwable t) {
            for (ClassPathItem item : resultList) {
                item.close();
            }
            throw t;
        }
        return List.copyOf(resultList);
    }

    static <K, V> Map<K, V> newMap(Object ignored) {
        return new HashMap();
    }

    static void appendArtifactResult(RepositorySystem system, RepositorySystemSession session, List<ClassPathItem> resultList, ArtifactResult artifactResult, Runtime.Version version) throws IOException {
        if (artifactResult.isResolved() && !artifactResult.isMissing()) {
            Artifact resultArtifact = artifactResult.getArtifact();
            if (!artifactResult.getArtifact().getExtension().equals("jar")) {
                return;
            }
            File jarFile = resultArtifact.getFile();
            File sourceFile = null;
            ArtifactRequest sourceRequest = new ArtifactRequest((Artifact)new DefaultArtifact(resultArtifact.getGroupId(), resultArtifact.getArtifactId(), "sources", "jar", resultArtifact.getVersion()), null, null);
            try {
                ArtifactResult sourceResult = system.resolveArtifact(session, sourceRequest);
                if (sourceResult != null && sourceResult.isResolved() && !sourceResult.isMissing()) {
                    sourceFile = sourceResult.getArtifact().getFile();
                }
            }
            catch (ArtifactResolutionException sourceResult) {
                // empty catch block
            }
            ClassPathElement element = ClassPathElement.forJarFile((File)jarFile, (Runtime.Version)version);
            List<ClassPathElement> jarPath = List.of(element);
            try {
                ClassPathElement sourceElement = sourceFile == null ? null : ClassPathElement.forJarFile(sourceFile, (Runtime.Version)version);
                List<Object> sourcePath = sourceFile == null ? List.of() : List.of(sourceElement);
                try {
                    resultList.add(new ClassPathItem(resultArtifact.toString(), jarPath, sourcePath));
                }
                catch (Throwable t) {
                    if (sourceElement != null) {
                        sourceElement.close();
                    }
                    throw t;
                }
            }
            catch (Throwable t) {
                element.close();
                throw t;
            }
        }
    }

    static void populateChildren(ClassPathEntry parent, DependencyNode dependencyNode, Map<String, Map<String, ClassPathEntry>> gaToCpe) {
        for (DependencyNode child : dependencyNode.getChildren()) {
            Artifact artifact = child.getArtifact();
            gaToCpe.computeIfAbsent(artifact.getGroupId(), DefaultArtifactRequestor::newMap).putIfAbsent(artifact.getArtifactId(), parent);
            DefaultArtifactRequestor.populateChildren(parent, child, gaToCpe);
        }
    }

    static ClassPathEntry findDependency(DependencyNode dependencyNode, Map<String, Map<String, ClassPathEntry>> gaToCpe) {
        if (dependencyNode == null) {
            return null;
        }
        Dependency dependency = dependencyNode.getDependency();
        Artifact artifact = dependency.getArtifact();
        ClassPathEntry classPathEntry = (ClassPathEntry)gaToCpe.getOrDefault(artifact.getGroupId(), Map.of()).get(artifact.getArtifactId());
        if (classPathEntry != null) {
            return classPathEntry;
        }
        for (DependencyNode child : dependencyNode.getChildren()) {
            ClassPathEntry found = DefaultArtifactRequestor.findDependency(child, gaToCpe);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    static <E> List<E> newList(Object ignored) {
        return new ArrayList();
    }
}

