/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.main;

import io.smallrye.beanbag.maven.MavenFactory;
import io.smallrye.common.constraint.Assert;
import io.smallrye.common.version.VersionIterator;
import io.smallrye.common.version.VersionScheme;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsProblem;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.jboss.logmanager.LogManager;
import org.jboss.logmanager.Logger;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Diagnostic;
import org.qbicc.context.DiagnosticContext;
import org.qbicc.context.Location;
import org.qbicc.driver.BaseDiagnosticContext;
import org.qbicc.driver.BuilderStage;
import org.qbicc.driver.ClassPathElement;
import org.qbicc.driver.ClassPathItem;
import org.qbicc.driver.Driver;
import org.qbicc.driver.ElementBodyCopier;
import org.qbicc.driver.ElementBodyCreator;
import org.qbicc.driver.ElementInitializer;
import org.qbicc.driver.ElementVisitorAdapter;
import org.qbicc.driver.GraphGenConfig;
import org.qbicc.driver.Phase;
import org.qbicc.driver.plugin.DriverPlugin;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.interpreter.VmThread;
import org.qbicc.interpreter.impl.VmImpl;
import org.qbicc.machine.arch.ObjectType;
import org.qbicc.machine.arch.Platform;
import org.qbicc.machine.object.ObjectFileProvider;
import org.qbicc.machine.tool.CToolChain;
import org.qbicc.machine.vfs.AbsoluteVirtualPath;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;
import org.qbicc.main.Backend;
import org.qbicc.main.ClassPathEntry;
import org.qbicc.main.ClassPathResolver;
import org.qbicc.main.DefaultArtifactRequestor;
import org.qbicc.main.ElementReachableAdapter;
import org.qbicc.main.PlatformConverter;
import org.qbicc.main.PlatformTypeSystemLoader;
import org.qbicc.main.Version;
import org.qbicc.plugin.apploader.AppClassLoader;
import org.qbicc.plugin.apploader.InitAppClassLoaderHook;
import org.qbicc.plugin.constants.ConstantBasicBlockBuilder;
import org.qbicc.plugin.conversion.NumericalConversionBasicBlockBuilder;
import org.qbicc.plugin.core.CoreAnnotationTypeBuilder;
import org.qbicc.plugin.coreclasses.BasicHeaderManualInitializer;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.coreclasses.CoreClassesBasicBlockBuilder;
import org.qbicc.plugin.correctness.BuildTimeOnlyElementHandler;
import org.qbicc.plugin.correctness.ConstraintMaterializingBasicBlockBuilder;
import org.qbicc.plugin.correctness.DeferenceBasicBlockBuilder;
import org.qbicc.plugin.correctness.RuntimeChecksBasicBlockBuilder;
import org.qbicc.plugin.correctness.StaticChecksBasicBlockBuilder;
import org.qbicc.plugin.dispatch.DevirtualizingBasicBlockBuilder;
import org.qbicc.plugin.dispatch.DispatchTableBuilder;
import org.qbicc.plugin.dispatch.DispatchTableEmitter;
import org.qbicc.plugin.dot.DotGenerator;
import org.qbicc.plugin.gc.common.GcCommon;
import org.qbicc.plugin.gc.common.MultiNewArrayExpansionBasicBlockBuilder;
import org.qbicc.plugin.gc.common.safepoint.SafePointPlacementBasicBlockBuilder;
import org.qbicc.plugin.gc.common.safepoint.SafePoints;
import org.qbicc.plugin.gc.nogc.NoGcBasicBlockBuilder;
import org.qbicc.plugin.gc.nogc.NoGcSetupHook;
import org.qbicc.plugin.initializationcontrol.InitAtRuntimeTypeBuilder;
import org.qbicc.plugin.initializationcontrol.QbiccFeature;
import org.qbicc.plugin.initializationcontrol.QbiccFeatureProcessor;
import org.qbicc.plugin.initializationcontrol.RuntimeResourceManager;
import org.qbicc.plugin.instanceofcheckcast.InstanceOfCheckCastBasicBlockBuilder;
import org.qbicc.plugin.instanceofcheckcast.SupersDisplayBuilder;
import org.qbicc.plugin.instanceofcheckcast.SupersDisplayEmitter;
import org.qbicc.plugin.intrinsics.IntrinsicBasicBlockBuilder;
import org.qbicc.plugin.intrinsics.core.CoreIntrinsics;
import org.qbicc.plugin.layout.ObjectAccessLoweringBuilder;
import org.qbicc.plugin.linker.LinkStage;
import org.qbicc.plugin.llvm.LLVMCompatibleBasicBlockBuilder;
import org.qbicc.plugin.llvm.LLVMConfiguration;
import org.qbicc.plugin.llvm.LLVMDefaultModuleCompileStage;
import org.qbicc.plugin.llvm.LLVMGenerator;
import org.qbicc.plugin.llvm.LLVMIntrinsics;
import org.qbicc.plugin.llvm.LLVMStackMapCollector;
import org.qbicc.plugin.llvm.LLVMStripStackMapStage;
import org.qbicc.plugin.llvm.ReferenceStrategy;
import org.qbicc.plugin.lowering.AbortingThrowLoweringBasicBlockBuilder;
import org.qbicc.plugin.lowering.BooleanAccessCopier;
import org.qbicc.plugin.lowering.FunctionLoweringElementHandler;
import org.qbicc.plugin.lowering.InitCheckLoweringBasicBlockBuilder;
import org.qbicc.plugin.lowering.InvocationLoweringBasicBlockBuilder;
import org.qbicc.plugin.lowering.MemberPointerCopier;
import org.qbicc.plugin.lowering.VMHelpersSetupHook;
import org.qbicc.plugin.main_method.AddMainClassHook;
import org.qbicc.plugin.main_method.MainMethod;
import org.qbicc.plugin.methodinfo.CallSiteTable;
import org.qbicc.plugin.native_.ConstTypeResolver;
import org.qbicc.plugin.native_.ConstantDefiningBasicBlockBuilder;
import org.qbicc.plugin.native_.ExternExportTypeBuilder;
import org.qbicc.plugin.native_.FunctionTypeResolver;
import org.qbicc.plugin.native_.InternalNativeTypeResolver;
import org.qbicc.plugin.native_.NativeBasicBlockBuilder;
import org.qbicc.plugin.native_.NativeBindingMethodConfigurator;
import org.qbicc.plugin.native_.NativeTypeBuilder;
import org.qbicc.plugin.native_.NativeTypeResolver;
import org.qbicc.plugin.native_.NativeXtorLoweringHook;
import org.qbicc.plugin.native_.PointerBasicBlockBuilder;
import org.qbicc.plugin.native_.PointerTypeResolver;
import org.qbicc.plugin.native_.StructMemberAccessBasicBlockBuilder;
import org.qbicc.plugin.objectmonitor.ObjectMonitorBasicBlockBuilder;
import org.qbicc.plugin.opt.BlockParameterOptimizingVisitor;
import org.qbicc.plugin.opt.FinalFieldLoadOptimizer;
import org.qbicc.plugin.opt.GotoRemovingVisitor;
import org.qbicc.plugin.opt.InliningBasicBlockBuilder;
import org.qbicc.plugin.opt.LocalMemoryTrackingBasicBlockBuilder;
import org.qbicc.plugin.opt.LocalOptBasicBlockBuilder;
import org.qbicc.plugin.opt.ea.EscapeAnalysisDotGenerator;
import org.qbicc.plugin.opt.ea.EscapeAnalysisDotVisitor;
import org.qbicc.plugin.opt.ea.EscapeAnalysisInterMethodAnalysis;
import org.qbicc.plugin.opt.ea.EscapeAnalysisIntraMethodAnalysis;
import org.qbicc.plugin.opt.ea.EscapeAnalysisOptimizeVisitor;
import org.qbicc.plugin.patcher.AccessorBasicBlockBuilder;
import org.qbicc.plugin.patcher.AccessorTypeBuilder;
import org.qbicc.plugin.patcher.Patcher;
import org.qbicc.plugin.patcher.PatcherResolverBasicBlockBuilder;
import org.qbicc.plugin.patcher.PatcherTypeResolver;
import org.qbicc.plugin.reachability.ReachabilityAnnotationTypeBuilder;
import org.qbicc.plugin.reachability.ReachabilityBlockBuilder;
import org.qbicc.plugin.reachability.ReachabilityFactsSetup;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.plugin.reachability.ReachabilityRoots;
import org.qbicc.plugin.reachability.ServiceLoaderAnalyzer;
import org.qbicc.plugin.reflection.Reflection;
import org.qbicc.plugin.reflection.ReflectionFactsSetup;
import org.qbicc.plugin.reflection.ReflectionIntrinsics;
import org.qbicc.plugin.reflection.ReflectiveElementRegistry;
import org.qbicc.plugin.reflection.ReflectiveElementTypeBuilder;
import org.qbicc.plugin.reflection.VarHandleResolvingBasicBlockBuilder;
import org.qbicc.plugin.serialization.BuildtimeHeap;
import org.qbicc.plugin.serialization.ClassObjectSerializer;
import org.qbicc.plugin.serialization.InitialHeapLiteralSerializingVisitor;
import org.qbicc.plugin.serialization.MethodDataStringsSerializer;
import org.qbicc.plugin.serialization.StringInternTableEmitter;
import org.qbicc.plugin.source.SourceEmittingElementHandler;
import org.qbicc.plugin.threadlocal.ThreadLocalBasicBlockBuilder;
import org.qbicc.plugin.threadlocal.ThreadLocalTypeBuilder;
import org.qbicc.plugin.trycatch.ExceptionOnThreadStrategy;
import org.qbicc.plugin.trycatch.SynchronizedMethodBasicBlockBuilder;
import org.qbicc.plugin.unwind.UnwindExceptionStrategy;
import org.qbicc.plugin.unwind.UnwindThrowBasicBlockBuilder;
import org.qbicc.plugin.verification.ClassInitializingBasicBlockBuilder;
import org.qbicc.plugin.verification.ClassLoadingBasicBlockBuilder;
import org.qbicc.plugin.verification.LowerVerificationBasicBlockBuilder;
import org.qbicc.plugin.verification.MemberResolvingBasicBlockBuilder;
import org.qbicc.plugin.vfs.VFS;
import org.qbicc.plugin.vio.VIO;
import org.qbicc.tool.llvm.LlvmToolChain;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.definition.classfile.BciRangeExceptionHandlerBasicBlockBuilder;
import org.qbicc.type.definition.classfile.IndyResolvingBasicBlockBuilder;
import org.qbicc.type.definition.element.ElementVisitor;
import org.qbicc.type.definition.element.ExecutableElement;
import picocli.CommandLine;

public class Main
implements Callable<DiagnosticContext> {
    private final List<ClassPathEntry> bootPaths;
    private final List<ClassPathEntry> appPaths;
    private final Runtime.Version classLibVersion;
    private final Path outputPath;
    private final String outputName;
    private final Path sourceOutputPath;
    private final Consumer<Iterable<Diagnostic>> diagnosticsHandler;
    private final String mainClass;
    private final List<String> buildTimeInitRootClasses;
    private final List<String> propertyDefines;
    private final String gc;
    private final boolean isPie;
    private final GraphGenConfig graphGenConfig;
    private final boolean compileOutput;
    private final boolean optMemoryTracking;
    private final boolean optPhis;
    private final boolean optGotos;
    private final boolean optInlining;
    private final boolean optEscapeAnalysis;
    private final Platform platform;
    private final boolean smallTypeIds;
    private final List<Path> librarySearchPaths;
    private final List<URL> qbiccYamlFeatures;
    private final List<QbiccFeature> qbiccFeatures;
    private final ClassPathResolver classPathResolver;
    private final Backend backend;
    private final LLVMConfiguration.Builder llvmConfigurationBuilder;

    Main(Builder builder) {
        this.outputPath = builder.outputPath;
        this.outputName = builder.outputName;
        this.sourceOutputPath = builder.sourceOutputPath;
        this.diagnosticsHandler = builder.diagnosticsHandler;
        this.mainClass = Assert.checkNotEmptyParam((String)"builder.mainClass", (String)builder.mainClass);
        this.buildTimeInitRootClasses = builder.buildTimeInitRootClasses;
        this.propertyDefines = builder.propertyDefines;
        this.gc = builder.gc;
        this.isPie = builder.isPie;
        this.graphGenConfig = builder.graphGenConfig;
        this.compileOutput = builder.compileOutput;
        this.optMemoryTracking = builder.optMemoryTracking;
        this.optInlining = builder.optInlining;
        this.optPhis = builder.optPhis;
        this.optGotos = builder.optGotos;
        this.optEscapeAnalysis = builder.optEscapeAnalysis;
        this.platform = builder.platform;
        this.smallTypeIds = builder.smallTypeIds;
        this.backend = builder.backend;
        ArrayList<ClassPathEntry> bootPaths = new ArrayList<ClassPathEntry>(builder.bootPathsPrepend.size() + 6 + builder.bootPathsAppend.size());
        bootPaths.addAll(builder.bootPathsPrepend);
        bootPaths.add(this.getCoreComponent("qbicc-runtime-api"));
        bootPaths.add(this.getCoreComponent("qbicc-runtime-llvm"));
        bootPaths.add(this.getCoreComponent("qbicc-runtime-main"));
        bootPaths.add(this.getCoreComponent("qbicc-runtime-unwind"));
        boolean nogc = this.gc.equals("none");
        if (nogc) {
            bootPaths.add(this.getCoreComponent("qbicc-runtime-gc-nogc"));
        }
        bootPaths.add(ClassPathEntry.ofClassLibraries(builder.classLibVersion));
        bootPaths.addAll(builder.bootPathsAppend);
        this.bootPaths = bootPaths;
        this.appPaths = List.copyOf(builder.appPaths);
        this.librarySearchPaths = builder.librarySearchPaths;
        this.qbiccYamlFeatures = builder.qbiccYamlFeatures;
        this.qbiccFeatures = builder.qbiccFeatures;
        this.classPathResolver = builder.classPathResolver == null ? this::resolveClassPath : builder.classPathResolver;
        this.llvmConfigurationBuilder = builder.llvmConfigurationBuilder;
        this.classLibVersion = Runtime.Version.parse(builder.classLibVersion.split("\\.")[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiagnosticContext call() {
        BaseDiagnosticContext ctxt = new BaseDiagnosticContext();
        long stackSize = 0x1000000L;
        Thread mainThread = new Thread(Thread.currentThread().getThreadGroup(), () -> {
            try {
                this.call0(ctxt);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                ctxt.error(t, "Compilation failed due to an exception", new Object[0]);
            }
        }, "Main compiler thread", stackSize, false);
        mainThread.start();
        boolean intr = false;
        try {
            while (true) {
                try {
                    mainThread.join();
                }
                catch (InterruptedException ie) {
                    mainThread.interrupt();
                    intr = true;
                    continue;
                }
                break;
            }
            this.diagnosticsHandler.accept(ctxt.getDiagnostics());
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
        return ctxt;
    }

    void call0(BaseDiagnosticContext initialContext) {
        block51: {
            Driver.Builder builder = Driver.builder();
            builder.setInitialContext(initialContext);
            boolean nogc = this.gc.equals("none");
            boolean llvm = this.backend.equals((Object)Backend.llvm);
            int errors = initialContext.errors();
            if (errors == 0) {
                builder.setOutputDirectory(this.outputPath);
                ArrayList bootItems = new ArrayList();
                ArrayList appItems = new ArrayList();
                try {
                    this.classPathResolver.resolveClassPath((DiagnosticContext)initialContext, bootItems::add, this.bootPaths, this.classLibVersion);
                }
                catch (IOException e) {
                    return;
                }
                try {
                    this.classPathResolver.resolveClassPath((DiagnosticContext)initialContext, appItems::add, this.appPaths, this.classLibVersion);
                }
                catch (IOException e) {
                    return;
                }
                bootItems.forEach(arg_0 -> ((Driver.Builder)builder).addBootClassPathItem(arg_0));
                appItems.forEach(arg_0 -> ((Driver.Builder)builder).addAppClassPathItem(arg_0));
                Platform target = this.platform;
                builder.setTargetPlatform(target);
                Optional optionalProvider = ObjectFileProvider.findProvider((ObjectType)target.getObjectType(), (ClassLoader)Main.class.getClassLoader());
                if (optionalProvider.isEmpty()) {
                    initialContext.error("No object file provider found for %s", new Object[]{target.getObjectType()});
                } else {
                    ObjectFileProvider objectFileProvider = (ObjectFileProvider)optionalProvider.get();
                    Iterator toolChains = CToolChain.findAllCToolChains((Platform)target, t -> true, (ClassLoader)Main.class.getClassLoader()).iterator();
                    if (!toolChains.hasNext()) {
                        initialContext.error("No working C compiler found", new Object[0]);
                    } else {
                        CToolChain toolChain = (CToolChain)toolChains.next();
                        builder.setToolChain(toolChain);
                        try {
                            PlatformTypeSystemLoader platformTypeSystemLoader = new PlatformTypeSystemLoader(this.platform, toolChain, objectFileProvider, (DiagnosticContext)initialContext, PlatformTypeSystemLoader.ReferenceType.POINTER, this.smallTypeIds, nogc);
                            TypeSystem typeSystem = platformTypeSystemLoader.load();
                            builder.setTypeSystem(typeSystem);
                            builder.setVmFactory(cc -> {
                                QbiccFeatureProcessor.process((CompilationContext)cc, this.qbiccYamlFeatures, this.qbiccFeatures);
                                CoreClasses.init((CompilationContext)cc);
                                ExceptionOnThreadStrategy.initialize((CompilationContext)cc);
                                UnwindExceptionStrategy.init((CompilationContext)cc);
                                return VmImpl.create((CompilationContext)cc, (Consumer)new BasicHeaderManualInitializer(cc)).setPropertyDefines(this.propertyDefines);
                            });
                            builder.setObjectFileProvider(objectFileProvider);
                            ServiceLoader<DriverPlugin> loader = ServiceLoader.load(DriverPlugin.class);
                            Iterator<DriverPlugin> iterator = loader.iterator();
                            while (true) {
                                try {
                                    while (iterator.hasNext()) {
                                        DriverPlugin plugin = iterator.next();
                                        plugin.accept(builder);
                                    }
                                }
                                catch (ServiceConfigurationError error) {
                                    initialContext.error((Throwable)error, "Failed to load plugin", new Object[0]);
                                    continue;
                                }
                                break;
                            }
                            errors = initialContext.errors();
                            LlvmToolChain llvmToolChain = null;
                            LLVMConfiguration tempLlVmConfiguration = null;
                            if (errors == 0 && llvm) {
                                Iterator llvmTools = LlvmToolChain.findAllLlvmToolChains((Platform)target, t -> true, (ClassLoader)Main.class.getClassLoader()).iterator();
                                while (llvmTools.hasNext() && (llvmToolChain = (LlvmToolChain)llvmTools.next()).compareVersionTo("12") < 0) {
                                    llvmToolChain = null;
                                }
                                if (llvmToolChain == null) {
                                    initialContext.error("No working LLVM toolchain found", new Object[0]);
                                    errors = initialContext.errors();
                                } else {
                                    builder.setLlvmToolChain(llvmToolChain);
                                    VersionIterator vi = VersionScheme.BASIC.iterate(llvmToolChain.getVersion());
                                    vi.next();
                                    tempLlVmConfiguration = this.llvmConfigurationBuilder.setMajorVersion(vi.getNumberPartAsInt()).build();
                                }
                            }
                            LLVMConfiguration llvmConfiguration = tempLlVmConfiguration;
                            if (errors != 0) break block51;
                            assert (this.mainClass != null);
                            builder.setMainClass(this.mainClass.replace('.', '/'));
                            builder.addTypeBuilderFactory(ExternExportTypeBuilder::new);
                            builder.addTypeBuilderFactory(NativeTypeBuilder::new);
                            builder.addTypeBuilderFactory(ThreadLocalTypeBuilder::new);
                            builder.addTypeBuilderFactory(CoreAnnotationTypeBuilder::new);
                            builder.addTypeBuilderFactory(ReachabilityAnnotationTypeBuilder::new);
                            builder.addTypeBuilderFactory(ReflectiveElementTypeBuilder::new);
                            builder.addTypeBuilderFactory(Patcher::getTypeBuilder);
                            builder.addTypeBuilderFactory(InitAtRuntimeTypeBuilder::new);
                            builder.addTypeBuilderFactory(AccessorTypeBuilder::new);
                            builder.setClassContextListener(Patcher::initialize);
                            builder.addNativeMethodConfiguratorFactory(NativeBindingMethodConfigurator::new);
                            builder.addResolverFactory(PatcherTypeResolver::create);
                            builder.addResolverFactory(ConstTypeResolver::new);
                            builder.addResolverFactory(FunctionTypeResolver::new);
                            builder.addResolverFactory(PointerTypeResolver::new);
                            builder.addResolverFactory(InternalNativeTypeResolver::new);
                            builder.addResolverFactory(NativeTypeResolver::new);
                            builder.addPreHook(Phase.ADD, c -> c.setTaskRunner((wrapper, ctxt) -> {
                                Vm vm = ctxt.getVm();
                                vm.doAttached(vm.newThread(Thread.currentThread().getName(), vm.getMainThreadGroup(), false, Thread.currentThread().getPriority()), () -> wrapper.accept(ctxt));
                            }));
                            builder.addPreHook(Phase.ADD, ReachabilityFactsSetup::setupAdd);
                            builder.addPreHook(Phase.ADD, ReflectionFactsSetup::setupAdd);
                            builder.addPreHook(Phase.ADD, ctxt -> SafePoints.selectStrategy((CompilationContext)ctxt, (SafePoints.Strategy)(nogc ? SafePoints.Strategy.NONE : SafePoints.Strategy.GLOBAL_FLAG)));
                            if (llvm) {
                                builder.addPreHook(Phase.ADD, LLVMIntrinsics::register);
                            }
                            builder.addPreHook(Phase.ADD, SafePoints::enqueueMethods);
                            builder.addPreHook(Phase.ADD, CoreIntrinsics::register);
                            builder.addPreHook(Phase.ADD, CoreClasses::get);
                            builder.addPreHook(Phase.ADD, ReflectionIntrinsics::register);
                            builder.addPreHook(Phase.ADD, Reflection::get);
                            builder.addPreHook(Phase.ADD, UnwindExceptionStrategy::get);
                            builder.addPreHook(Phase.ADD, GcCommon::registerIntrinsics);
                            builder.addPreHook(Phase.ADD, compilationContext -> {
                                Vm vm = compilationContext.getVm();
                                VmThread initThread = vm.newThread("initialization", vm.getMainThreadGroup(), false, Thread.currentThread().getPriority());
                                vm.doAttached(initThread, () -> ((Vm)vm).initialize());
                            });
                            builder.addPreHook(Phase.ADD, VIO::get);
                            builder.addPreHook(Phase.ADD, VFS::initialize);
                            builder.addPreHook(Phase.ADD, Main::mountInitialFileSystem);
                            builder.addPreHook(Phase.ADD, (Consumer)new VMHelpersSetupHook());
                            builder.addPreHook(Phase.ADD, (Consumer)new InitAppClassLoaderHook());
                            builder.addPreHook(Phase.ADD, compilationContext -> {
                                Vm vm = compilationContext.getVm();
                                VmThread initThread = vm.newThread("initialization 2", vm.getMainThreadGroup(), false, Thread.currentThread().getPriority());
                                vm.doAttached(initThread, () -> ((Vm)vm).initialize2());
                            });
                            builder.addPreHook(Phase.ADD, (Consumer)new AddMainClassHook());
                            if (nogc) {
                                builder.addPreHook(Phase.ADD, (Consumer)new NoGcSetupHook());
                            }
                            builder.addPreHook(Phase.ADD, ReachabilityInfo::forceCoreClassesReachable);
                            builder.addPreHook(Phase.ADD, ReflectiveElementRegistry::ensureReflectiveClassesLoaded);
                            builder.addPreHook(Phase.ADD, compilationContext -> {
                                if (!this.buildTimeInitRootClasses.isEmpty()) {
                                    for (String toInit : this.buildTimeInitRootClasses) {
                                        compilationContext.submitTask((Object)toInit, className -> {
                                            Vm vm = compilationContext.getVm();
                                            VmThread loadingThread = vm.newThread("build time init", vm.getMainThreadGroup(), false, Thread.currentThread().getPriority());
                                            VmClassLoader appClassLoader = AppClassLoader.get((CompilationContext)compilationContext).getAppClassLoader();
                                            vm.doAttached(loadingThread, () -> {
                                                VmClass vmClass = appClassLoader.loadClass(className.replace('.', '/'));
                                                vm.initialize(vmClass);
                                            });
                                        });
                                    }
                                }
                            });
                            builder.addPreHook(Phase.ADD, (Consumer)new ElementReachableAdapter(new ElementBodyCreator().andThen((Consumer)new BuildTimeOnlyElementHandler()).andThen(new ElementInitializer())));
                            builder.addPreHook(Phase.ADD, (Consumer)new ElementReachableAdapter(ReachabilityInfo::processReachableElement));
                            builder.addPreHook(Phase.ADD, (Consumer)new ElementReachableAdapter((Consumer<ExecutableElement>)new ElementVisitorAdapter((ElementVisitor)new DotGenerator(Phase.ADD, this.graphGenConfig))));
                            builder.addPreHook(Phase.ADD, (Consumer)new ElementReachableAdapter(CallSiteTable::computeMethodType));
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, IntrinsicBasicBlockBuilder::createForAddPhase);
                            if (nogc) {
                                builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, MultiNewArrayExpansionBasicBlockBuilder::new);
                            }
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, PatcherResolverBasicBlockBuilder::createIfNeeded);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, ClassLoadingBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, NativeBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, VarHandleResolvingBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, MemberResolvingBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, AccessorBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, StructMemberAccessBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, PointerBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, ClassInitializingBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, ConstantDefiningBasicBlockBuilder::createIfNeeded);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, ConstantBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, CoreClassesBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, DevirtualizingBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, BciRangeExceptionHandlerBasicBlockBuilder::createIfNeeded);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, IndyResolvingBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.TRANSFORM, SynchronizedMethodBasicBlockBuilder::createIfNeeded);
                            if (this.optMemoryTracking) {
                                // empty if block
                            }
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.CORRECT, RuntimeChecksBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.OPTIMIZE, LocalOptBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.INTEGRITY, DeferenceBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.INTEGRITY, ReachabilityBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ADD, BuilderStage.INTEGRITY, StaticChecksBasicBlockBuilder::new);
                            builder.addPostHook(Phase.ADD, ctxt -> {
                                Vm vm = ctxt.getVm();
                                vm.doAttached(vm.newThread("ReflectionData Generation", vm.getMainThreadGroup(), false, Thread.currentThread().getPriority()), () -> Reflection.get((CompilationContext)ctxt).transferToReflectionData());
                            });
                            builder.addPostHook(Phase.ADD, ctxt -> {
                                Vm vm = ctxt.getVm();
                                vm.doAttached(vm.newThread("ServiceProvider Serialization", vm.getMainThreadGroup(), false, Thread.currentThread().getPriority()), () -> ServiceLoaderAnalyzer.get((CompilationContext)ctxt).serializeProviderConfig());
                            });
                            builder.addPostHook(Phase.ADD, ctxt -> {
                                Vm vm = ctxt.getVm();
                                vm.doAttached(vm.newThread("Resource Serialization", vm.getMainThreadGroup(), false, Thread.currentThread().getPriority()), () -> RuntimeResourceManager.get((CompilationContext)ctxt).findAndSerializeResources());
                            });
                            builder.addPostHook(Phase.ADD, ReachabilityInfo::reportStats);
                            builder.addPostHook(Phase.ADD, ReachabilityInfo::clear);
                            builder.addPreHook(Phase.ANALYZE, ReachabilityFactsSetup::setupAnalyze);
                            builder.addPreHook(Phase.ANALYZE, SafePoints::enqueueMethods);
                            builder.addPreHook(Phase.ANALYZE, (Consumer)new VMHelpersSetupHook());
                            builder.addPreHook(Phase.ANALYZE, ReachabilityInfo::forceCoreClassesReachable);
                            builder.addPreHook(Phase.ANALYZE, ReachabilityRoots::processRootsForAnalyze);
                            builder.addPreHook(Phase.ANALYZE, (Consumer)new ElementReachableAdapter(ReachabilityInfo::processReachableElement));
                            builder.addPreHook(Phase.ANALYZE, (Consumer)new ElementReachableAdapter((Consumer<ExecutableElement>)new ElementBodyCopier()));
                            if (this.optEscapeAnalysis) {
                                builder.addPreHook(Phase.ANALYZE, (Consumer)new ElementReachableAdapter((Consumer<ExecutableElement>)new ElementVisitorAdapter((ElementVisitor)new EscapeAnalysisIntraMethodAnalysis())));
                                builder.addPreHook(Phase.ANALYZE, (Consumer)new ElementReachableAdapter((Consumer<ExecutableElement>)new ElementVisitorAdapter((ElementVisitor)new DotGenerator(Phase.ANALYZE, "analyze-intra", this.graphGenConfig).addVisitorFactory(EscapeAnalysisDotVisitor::new))));
                            } else {
                                builder.addPreHook(Phase.ANALYZE, (Consumer)new ElementReachableAdapter((Consumer<ExecutableElement>)new ElementVisitorAdapter((ElementVisitor)new DotGenerator(Phase.ANALYZE, this.graphGenConfig))));
                            }
                            if (this.optGotos) {
                                builder.addCopyFactory(Phase.ANALYZE, GotoRemovingVisitor::new);
                            }
                            if (this.optPhis) {
                                builder.addCopyFactory(Phase.ANALYZE, BlockParameterOptimizingVisitor::new);
                            }
                            builder.addBuilderFactory(Phase.ANALYZE, BuilderStage.TRANSFORM, IntrinsicBasicBlockBuilder::createForAnalyzePhase);
                            builder.addBuilderFactory(Phase.ANALYZE, BuilderStage.TRANSFORM, FinalFieldLoadOptimizer::new);
                            builder.addBuilderFactory(Phase.ANALYZE, BuilderStage.TRANSFORM, ThreadLocalBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ANALYZE, BuilderStage.TRANSFORM, DevirtualizingBasicBlockBuilder::new);
                            if (this.optMemoryTracking) {
                                builder.addBuilderFactory(Phase.ANALYZE, BuilderStage.TRANSFORM, LocalMemoryTrackingBasicBlockBuilder::new);
                            }
                            builder.addBuilderFactory(Phase.ANALYZE, BuilderStage.TRANSFORM, ConstraintMaterializingBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ANALYZE, BuilderStage.CORRECT, NumericalConversionBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ANALYZE, BuilderStage.OPTIMIZE, LocalOptBasicBlockBuilder::new);
                            if (this.optInlining) {
                                builder.addBuilderFactory(Phase.ANALYZE, BuilderStage.OPTIMIZE, InliningBasicBlockBuilder::new);
                            }
                            builder.addBuilderFactory(Phase.ANALYZE, BuilderStage.INTEGRITY, ReachabilityBlockBuilder::new);
                            builder.addBuilderFactory(Phase.ANALYZE, BuilderStage.INTEGRITY, StaticChecksBasicBlockBuilder::new);
                            if (this.optEscapeAnalysis) {
                                builder.addPostHook(Phase.ANALYZE, (Consumer)new EscapeAnalysisInterMethodAnalysis());
                                builder.addPostHook(Phase.ANALYZE, (Consumer)new EscapeAnalysisDotGenerator(this.graphGenConfig));
                            }
                            builder.addPreHook(Phase.LOWER, ReachabilityInfo::reportStats);
                            builder.addPreHook(Phase.LOWER, (Consumer)new DispatchTableBuilder());
                            builder.addPreHook(Phase.LOWER, (Consumer)new SupersDisplayBuilder());
                            builder.addPreHook(Phase.LOWER, ReachabilityFactsSetup::setupLower);
                            builder.addPreHook(Phase.LOWER, SafePoints::enqueueMethods);
                            builder.addPreHook(Phase.LOWER, ReachabilityRoots::processRootsForLower);
                            builder.addPreHook(Phase.LOWER, (Consumer)new ClassObjectSerializer());
                            if (this.optEscapeAnalysis) {
                                builder.addCopyFactory(Phase.LOWER, EscapeAnalysisOptimizeVisitor::new);
                            }
                            builder.addPreHook(Phase.LOWER, (Consumer)new ElementReachableAdapter((Consumer<ExecutableElement>)new FunctionLoweringElementHandler()));
                            builder.addPreHook(Phase.LOWER, (Consumer)new ElementReachableAdapter((Consumer<ExecutableElement>)new ElementVisitorAdapter((ElementVisitor)new DotGenerator(Phase.LOWER, this.graphGenConfig))));
                            if (this.sourceOutputPath != null) {
                                HashMap sourcePaths = new HashMap();
                                builder.addPreHook(Phase.LOWER, ctxt -> this.createSourcePaths((CompilationContext)ctxt, bootItems, appItems, sourcePaths));
                                builder.addPreHook(Phase.LOWER, (Consumer)new ElementReachableAdapter((Consumer<ExecutableElement>)new SourceEmittingElementHandler(this.sourceOutputPath, sourcePaths)));
                            }
                            if (this.optGotos) {
                                builder.addCopyFactory(Phase.LOWER, GotoRemovingVisitor::new);
                            }
                            if (this.optPhis) {
                                builder.addCopyFactory(Phase.LOWER, BlockParameterOptimizingVisitor::new);
                            }
                            builder.addCopyFactory(Phase.LOWER, BooleanAccessCopier::new);
                            builder.addCopyFactory(Phase.LOWER, InitialHeapLiteralSerializingVisitor::new);
                            builder.addCopyFactory(Phase.LOWER, MemberPointerCopier::new);
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, SafePointPlacementBasicBlockBuilder::createIfNeeded);
                            if (this.platform.isWasm()) {
                                builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, AbortingThrowLoweringBasicBlockBuilder::new);
                            } else {
                                builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, ExceptionOnThreadStrategy::loweringBuilder);
                                builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, UnwindThrowBasicBlockBuilder::new);
                            }
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, DevirtualizingBasicBlockBuilder::new);
                            if (nogc) {
                                builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, NoGcBasicBlockBuilder::new);
                            }
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, IntrinsicBasicBlockBuilder::createForLowerPhase);
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, InvocationLoweringBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, InstanceOfCheckCastBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, InitCheckLoweringBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, ObjectAccessLoweringBuilder::new);
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, ObjectMonitorBasicBlockBuilder::new);
                            if (llvm) {
                                builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, (ctxt, delegate) -> new LLVMCompatibleBasicBlockBuilder(ctxt, delegate, llvmConfiguration));
                            }
                            if (this.optMemoryTracking) {
                                builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, LocalMemoryTrackingBasicBlockBuilder::new);
                            }
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, SafePoints::createBasicBlockBuilder);
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.TRANSFORM, MethodDataStringsSerializer::new);
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.OPTIMIZE, LocalOptBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.INTEGRITY, LowerVerificationBasicBlockBuilder::new);
                            builder.addBuilderFactory(Phase.LOWER, BuilderStage.INTEGRITY, StaticChecksBasicBlockBuilder::new);
                            builder.addPostHook(Phase.LOWER, NativeXtorLoweringHook::process);
                            builder.addPostHook(Phase.LOWER, BuildtimeHeap::reportStats);
                            builder.addPreHook(Phase.GENERATE, ReachabilityFactsSetup::setupGenerate);
                            builder.addPreHook(Phase.GENERATE, (Consumer)new StringInternTableEmitter());
                            builder.addPreHook(Phase.GENERATE, (Consumer)new SupersDisplayEmitter());
                            builder.addPreHook(Phase.GENERATE, (Consumer)new DispatchTableEmitter());
                            if (llvm) {
                                builder.addPreHook(Phase.GENERATE, (Consumer)new LLVMGenerator(llvmConfiguration));
                            }
                            builder.addPostHook(Phase.GENERATE, (Consumer)new DotGenerator(Phase.GENERATE, this.graphGenConfig));
                            if (llvm && llvmConfiguration.isStatepointEnabled()) {
                                builder.addPostHook(Phase.GENERATE, LLVMStackMapCollector::execute);
                                builder.addPostHook(Phase.GENERATE, (Consumer)new LLVMStripStackMapStage());
                            }
                            if (!this.platform.isWasm()) {
                                builder.addPostHook(Phase.GENERATE, CallSiteTable::writeCallSiteTable);
                            }
                            if (llvm) {
                                builder.addPostHook(Phase.GENERATE, (Consumer)new LLVMDefaultModuleCompileStage(llvmConfiguration));
                            }
                            if (this.compileOutput) {
                                builder.addPostHook(Phase.GENERATE, (Consumer)new LinkStage(this.outputName, this.isPie, this.librarySearchPaths));
                            }
                            try (Driver driver = builder.build();){
                                CompilationContext ctxt2 = driver.getCompilationContext();
                                MainMethod.get((CompilationContext)ctxt2).setMainClass(this.mainClass);
                                driver.execute();
                            }
                        }
                        catch (IOException e) {
                            initialContext.error((Throwable)e, "Failed to probe system types from tool chain", new Object[0]);
                        }
                    }
                }
            }
        }
    }

    private void createSourcePaths(CompilationContext ctxt, List<ClassPathItem> bootItems, List<ClassPathItem> appItems, Map<ClassContext, List<ClassPathElement>> sourcePaths) {
        ClassContext bootCtxt = ctxt.getBootstrapClassContext();
        VmClassLoader platCl = ctxt.getVm().getPlatformClassLoader();
        ClassContext platCtxt = platCl == null ? null : platCl.getClassContext();
        VmClassLoader appCl = ctxt.getVm().getAppClassLoader();
        ClassContext appCtxt = appCl == null ? null : appCl.getClassContext();
        List<ClassPathElement> sourceElements = this.getSourceEntries(bootItems);
        sourcePaths.put(bootCtxt, sourceElements);
        if (platCtxt != null) {
            sourcePaths.put(platCtxt, sourceElements);
        }
        if (appCtxt != null) {
            sourcePaths.put(appCtxt, this.getSourceEntries(appItems));
        }
    }

    private List<ClassPathElement> getSourceEntries(List<ClassPathItem> items) {
        ArrayList<ClassPathElement> output = new ArrayList<ClassPathElement>(64);
        for (ClassPathItem item : items) {
            output.addAll(item.sourceRoots());
        }
        return output;
    }

    private ClassPathEntry getCoreComponent(String artifactId) {
        return ClassPathEntry.of((Artifact)new DefaultArtifact("org.qbicc", artifactId, "jar", Version.QBICC_VERSION));
    }

    private void resolveClassPath(DiagnosticContext ctxt, Consumer<ClassPathItem> classPathItemConsumer, List<ClassPathEntry> paths, Runtime.Version version) throws IOException {
        Settings settings;
        MavenFactory mavenFactory = MavenFactory.create();
        RepositorySystem system = mavenFactory.getRepositorySystem();
        File globalSettings = MavenFactory.getGlobalSettingsLocation();
        File userSettings = MavenFactory.getUserSettingsLocation();
        try {
            settings = mavenFactory.createSettingsFromContainer(globalSettings, userSettings, problem -> {
                Location loc = Location.builder().setSourceFilePath(problem.getSource()).setLineNumber(problem.getLineNumber()).build();
                SettingsProblem.Severity severity = problem.getSeverity();
                Diagnostic.Level level = switch (severity) {
                    default -> throw new IncompatibleClassChangeError();
                    case SettingsProblem.Severity.FATAL, SettingsProblem.Severity.ERROR -> Diagnostic.Level.ERROR;
                    case SettingsProblem.Severity.WARNING -> Diagnostic.Level.WARNING;
                };
                ctxt.msg(null, loc, level, "Maven settings problem: %s", new Object[]{problem.getMessage()});
            });
        }
        catch (SettingsBuildingException e) {
            throw new IOException(e);
        }
        List remoteRepositoryList = MavenFactory.createRemoteRepositoryList((Settings)settings);
        RepositorySystemSession session = mavenFactory.createSession(settings);
        DefaultArtifactRequestor requestor = new DefaultArtifactRequestor();
        List<ClassPathItem> result = requestor.requestArtifactsFromRepositories(system, session, remoteRepositoryList, paths, ctxt, version);
        result.forEach(classPathItemConsumer);
    }

    static List<Path> splitPathString(String str) {
        if (str == null || str.isEmpty()) {
            return List.of();
        }
        char psc = File.pathSeparatorChar;
        int start = 0;
        int idx = str.indexOf(psc);
        ArrayList<Path> list = new ArrayList<Path>();
        while (true) {
            String subStr;
            if (!(subStr = idx == -1 ? str.substring(start) : str.substring(start, idx)).isEmpty()) {
                list.add(Path.of(subStr, new String[0]));
            }
            if (idx == -1) {
                return list;
            }
            start = idx + 1;
            idx = str.indexOf(psc, start);
        }
    }

    private static void mountInitialFileSystem(CompilationContext ctxt) {
        VFS vfs = VFS.get((CompilationContext)ctxt);
        VirtualFileSystem fileSystem = vfs.getFileSystem();
        Driver driver = Driver.get((CompilationContext)ctxt);
        AbsoluteVirtualPath javaHome = vfs.getQbiccPath().resolve("java.home");
        try {
            fileSystem.mkdirs((VirtualPath)javaHome, 493);
        }
        catch (IOException e) {
            ctxt.error((Throwable)e, "Failed to create %s", new Object[]{javaHome});
        }
        AbsoluteVirtualPath modulesPath = javaHome.resolve("modules");
        Collection bootModuleNames = driver.getBootModuleNames();
        for (String bootModuleName : bootModuleNames) {
            ClassPathItem bootItem = driver.getBootModuleClassPathItem(bootModuleName);
            try {
                bootItem.mount(fileSystem, (VirtualPath)modulesPath.resolve(bootModuleName));
            }
            catch (IOException e) {
                ctxt.error((Throwable)e, "Failed to mount %s", new Object[]{bootItem});
            }
        }
        for (String bootModuleName : bootModuleNames) {
            AbsoluteVirtualPath moduleJavaHome = modulesPath.resolve(bootModuleName).resolve("META-INF").resolve("java.home");
            try {
                int attrs = fileSystem.getBooleanAttributes((VirtualPath)moduleJavaHome, false);
                if ((attrs & 1) == 0) continue;
                Main.linkIn(fileSystem, javaHome, moduleJavaHome);
            }
            catch (IOException e) {
                ctxt.error((Throwable)e, "Failed to remount %s", new Object[]{moduleJavaHome});
            }
        }
    }

    private static void linkIn(VirtualFileSystem fileSystem, AbsoluteVirtualPath toDir, AbsoluteVirtualPath fromDir) throws IOException {
        Collection names = fileSystem.getDirectoryEntries((VirtualPath)fromDir, false);
        for (String name : names) {
            AbsoluteVirtualPath fromPath = fromDir.resolve(name);
            AbsoluteVirtualPath toPath = toDir.resolve(name);
            fileSystem.mkdirs((VirtualPath)toPath.getParent(), 493);
            if ((fileSystem.getBooleanAttributes((VirtualPath)fromPath, false) & 4) != 0) {
                Main.linkIn(fileSystem, toPath, fromPath);
                continue;
            }
            fileSystem.link((VirtualPath)toPath, (VirtualPath)fromPath, false);
        }
    }

    public static void main(String[] args) {
        System.setProperty("java.util.logging.manager", LogManager.class.getName());
        CommandLineProcessor optionsProcessor = new CommandLineProcessor();
        CmdResult result = optionsProcessor.process(args);
        if (result != CmdResult.CMD_RESULT_OK) {
            return;
        }
        if (optionsProcessor.mainClass.isEmpty() && optionsProcessor.inputJar == null) {
            System.err.println("Must either provide a <mainClass> or use --jar <executableJar>");
            return;
        }
        Platform platform = optionsProcessor.platform;
        if (platform == null) {
            platform = Platform.HOST_PLATFORM;
        }
        Builder mainBuilder = Main.builder();
        mainBuilder.setClassLibVersion(optionsProcessor.rtVersion).appendBootPaths(optionsProcessor.appendedBootPathEntries).prependBootPaths(optionsProcessor.prependedBootPathEntries).addAppPaths(optionsProcessor.appPathEntries).processJarArgument(optionsProcessor.inputJar).addQbiccYamlFeatures(optionsProcessor.qbiccFeatures.stream().toList()).setOutputPath(optionsProcessor.outputPath).setOutputName(optionsProcessor.outputName).setMainClass(optionsProcessor.mainClass).setDiagnosticsHandler(diagnostics -> {
            for (Diagnostic diagnostic : diagnostics) {
                try {
                    diagnostic.appendTo((Appendable)System.err);
                }
                catch (IOException e) {
                    break;
                }
            }
        }).setGc(optionsProcessor.gc.toString()).setIsPie(optionsProcessor.isPie).setCompileOutput(optionsProcessor.compileOutput).setOptMemoryTracking(optionsProcessor.optArgs.optMemoryTracking).setOptInlining(optionsProcessor.optArgs.optInlining).setOptGotos(optionsProcessor.optArgs.optGotos).setOptPhis(optionsProcessor.optArgs.optPhis).setOptEscapeAnalysis(optionsProcessor.optArgs.optEscapeAnalysis).setSmallTypeIds(optionsProcessor.smallTypeIds).setBackend(optionsProcessor.backend).setGraphGenConfig(optionsProcessor.graphGenConfig).setLlvmConfigurationBuilder(LLVMConfiguration.builder().setEmitAssembly(optionsProcessor.emitAssembly).setEmitIr(optionsProcessor.llvmArgs.emitIr).setCompileOutput(optionsProcessor.compileOutput).setPie(optionsProcessor.isPie).setPlatform(platform).setReferenceStrategy(platform.isWasm() ? ReferenceStrategy.POINTER : ReferenceStrategy.POINTER_AS1).addLlcOptions(optionsProcessor.llvmArgs.llcOptions).setStatepointEnabled(!platform.isWasm()).setOpaquePointers(optionsProcessor.llvmArgs.opaquePointers)).setPlatform(platform).addLibrarySearchPaths(Main.splitPathString(System.getenv("LIBRARY_PATH"))).addLibrarySearchPaths(optionsProcessor.libSearchPaths);
        if (optionsProcessor.sourceOutputPath != null) {
            mainBuilder.setSourceOutputPath(optionsProcessor.sourceOutputPath);
        }
        Main main = mainBuilder.build();
        DiagnosticContext context = main.call();
        int errors = context.errors();
        int warnings = context.warnings();
        if (errors > 0) {
            if (warnings > 0) {
                System.err.printf("Compilation failed with %d error(s) and %d warning(s)%n", errors, warnings);
            } else {
                System.err.printf("Compilation failed with %d error(s)%n", errors);
            }
        } else if (warnings > 0) {
            System.err.printf("Compilation completed with %d warning(s)%n", warnings);
        }
        System.exit(errors == 0 ? 0 : 1);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<ClassPathEntry> bootPathsPrepend = new ArrayList<ClassPathEntry>();
        private final List<ClassPathEntry> bootPathsAppend = new ArrayList<ClassPathEntry>();
        private final List<ClassPathEntry> appPaths = new ArrayList<ClassPathEntry>();
        private String classLibVersion = Version.CLASSLIB_DEFAULT_VERSION;
        private Path outputPath;
        private String outputName = "a.out";
        private Path sourceOutputPath;
        private Consumer<Iterable<Diagnostic>> diagnosticsHandler = diagnostics -> {};
        private Platform platform = Platform.HOST_PLATFORM;
        private String mainClass;
        private List<String> buildTimeInitRootClasses = new ArrayList<String>();
        private List<String> propertyDefines = new ArrayList<String>();
        private String gc = "none";
        private boolean isPie = false;
        private boolean compileOutput = true;
        private boolean optMemoryTracking = false;
        private boolean optInlining = false;
        private boolean optPhis = true;
        private boolean optGotos = true;
        private boolean optEscapeAnalysis = false;
        private GraphGenConfig graphGenConfig;
        private boolean smallTypeIds = false;
        private Backend backend = Backend.llvm;
        private List<Path> librarySearchPaths = List.of();
        private List<URL> qbiccYamlFeatures = new ArrayList<URL>();
        private List<QbiccFeature> qbiccFeatures = new ArrayList<QbiccFeature>();
        private ClassPathResolver classPathResolver;
        private LLVMConfiguration.Builder llvmConfigurationBuilder;

        Builder() {
        }

        public Builder appendBootPath(ClassPathEntry entry) {
            Assert.checkNotNullParam((String)"entry", (Object)entry);
            this.bootPathsAppend.add(entry);
            return this;
        }

        public Builder appendBootPaths(List<ClassPathEntry> entry) {
            Assert.checkNotNullParam((String)"entry", entry);
            this.bootPathsAppend.addAll(entry);
            return this;
        }

        public Builder prependBootPath(ClassPathEntry entry) {
            Assert.checkNotNullParam((String)"entry", (Object)entry);
            this.bootPathsPrepend.add(entry);
            return this;
        }

        public Builder prependBootPaths(List<ClassPathEntry> entry) {
            Assert.checkNotNullParam((String)"entry", entry);
            this.bootPathsPrepend.addAll(entry);
            return this;
        }

        public Builder setClassLibVersion(String classLibVersion) {
            Assert.checkNotNullParam((String)"classLibVersion", (Object)classLibVersion);
            this.classLibVersion = classLibVersion;
            return this;
        }

        public Builder addAppPath(ClassPathEntry entry) {
            Assert.checkNotNullParam((String)"entry", (Object)entry);
            this.appPaths.add(entry);
            return this;
        }

        public Builder addAppPaths(List<ClassPathEntry> entry) {
            Assert.checkNotNullParam((String)"entry", entry);
            this.appPaths.addAll(entry);
            return this;
        }

        public Builder addQbiccYamlFeatures(List<URL> configs) {
            this.qbiccYamlFeatures.addAll(configs);
            return this;
        }

        public Builder addQbiccFeature(QbiccFeature feature) {
            this.qbiccFeatures.add(feature);
            return this;
        }

        public Builder addBuildTimeInitRootClass(String className) {
            this.buildTimeInitRootClasses.add(className);
            return this;
        }

        public Builder addPropertyDefine(String property, String value) {
            this.propertyDefines.add(property);
            this.propertyDefines.add(value);
            return this;
        }

        public Builder setOutputPath(Path path) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            this.outputPath = path;
            return this;
        }

        public Builder setOutputName(String outputName) {
            Assert.checkNotNullParam((String)"outputName", (Object)outputName);
            this.outputName = outputName;
            return this;
        }

        public Builder setSourceOutputPath(Path path) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            this.sourceOutputPath = path;
            return this;
        }

        public Builder setPlatform(Platform platform) {
            Assert.checkNotNullParam((String)"platform", (Object)platform);
            this.platform = platform;
            return this;
        }

        public Builder setDiagnosticsHandler(Consumer<Iterable<Diagnostic>> handler) {
            Assert.checkNotNullParam((String)"handler", handler);
            this.diagnosticsHandler = handler;
            return this;
        }

        public Builder processJarArgument(Path inputJar) {
            if (inputJar == null) {
                return this;
            }
            try {
                JarInputStream jarStream = new JarInputStream(new FileInputStream(inputJar.toAbsolutePath().toString()));
                this.appPaths.add(ClassPathEntry.of(inputJar));
                this.mainClass = jarStream.getManifest().getMainAttributes().getValue("Main-Class");
                String classPath = jarStream.getManifest().getMainAttributes().getValue("Class-Path");
                if (classPath != null && !classPath.equals("")) {
                    Path parentDir = inputJar.toAbsolutePath().getParent();
                    for (String e : classPath.split(" ")) {
                        if (e.isEmpty()) continue;
                        ClassPathEntry.FilePath cpe = ClassPathEntry.of(parentDir.resolve(e));
                        this.appPaths.add(cpe);
                    }
                }
            }
            catch (IOException e) {
                System.err.println("Error processing argument \"-jar " + inputJar + "\": " + e.getMessage());
            }
            return this;
        }

        public Builder setMainClass(String mainClass) {
            if (!mainClass.equals("")) {
                this.mainClass = mainClass;
            }
            return this;
        }

        public Builder setGc(String gc) {
            this.gc = (String)Assert.checkNotNullParam((String)"gc", (Object)gc);
            return this;
        }

        public Builder setIsPie(boolean isPie) {
            this.isPie = isPie;
            return this;
        }

        public Builder setGraphGenConfig(GraphGenConfig graphGenConfig) {
            Assert.checkNotNullParam((String)"graphGenConfig", (Object)graphGenConfig);
            this.graphGenConfig = graphGenConfig;
            return this;
        }

        public Builder setCompileOutput(boolean compileOutput) {
            this.compileOutput = compileOutput;
            return this;
        }

        public Builder setOptMemoryTracking(boolean optMemoryTracking) {
            this.optMemoryTracking = optMemoryTracking;
            return this;
        }

        public Builder setOptInlining(boolean optInlining) {
            this.optInlining = optInlining;
            return this;
        }

        public Builder setOptPhis(boolean optPhis) {
            this.optPhis = optPhis;
            return this;
        }

        public Builder setOptGotos(boolean optGotos) {
            this.optGotos = optGotos;
            return this;
        }

        public Builder setOptEscapeAnalysis(boolean optEscapeAnalysis) {
            this.optEscapeAnalysis = optEscapeAnalysis;
            return this;
        }

        public Builder setBackend(Backend backend) {
            this.backend = (Backend)((Object)Assert.checkNotNullParam((String)"backend", (Object)((Object)backend)));
            return this;
        }

        public Builder setSmallTypeIds(boolean smallTypeIds) {
            this.smallTypeIds = smallTypeIds;
            return this;
        }

        public Builder addLibrarySearchPaths(List<Path> librarySearchPaths) {
            if (librarySearchPaths != null && !librarySearchPaths.isEmpty()) {
                if (this.librarySearchPaths.isEmpty()) {
                    this.librarySearchPaths = List.copyOf(librarySearchPaths);
                } else {
                    Path[] p1 = (Path[])this.librarySearchPaths.toArray(Path[]::new);
                    Path[] p2 = (Path[])librarySearchPaths.toArray(Path[]::new);
                    Path[] finalPaths = Arrays.copyOf(p1, p1.length + p2.length);
                    System.arraycopy(p2, 0, finalPaths, p1.length, p2.length);
                    this.librarySearchPaths = List.of(finalPaths);
                }
            }
            return this;
        }

        public Builder setClassPathResolver(ClassPathResolver classPathResolver) {
            this.classPathResolver = classPathResolver;
            return this;
        }

        public Builder setLlvmConfigurationBuilder(LLVMConfiguration.Builder builder) {
            this.llvmConfigurationBuilder = (LLVMConfiguration.Builder)Assert.checkNotNullParam((String)"builder", (Object)builder);
            return this;
        }

        public Main build() {
            return new Main(this);
        }
    }

    @CommandLine.Command(versionProvider=VersionProvider.class, mixinStandardHelpOptions=true)
    private static final class CommandLineProcessor {
        private final List<ClassPathEntry> prependedBootPathEntries = new ArrayList<ClassPathEntry>();
        private final List<ClassPathEntry> appendedBootPathEntries = new ArrayList<ClassPathEntry>();
        @CommandLine.Option(names={"--rt-version"})
        private String rtVersion = Version.CLASSLIB_DEFAULT_VERSION;
        private final List<ClassPathEntry> appPathEntries = new ArrayList<ClassPathEntry>();
        private final Set<URL> qbiccFeatures = new HashSet<URL>();
        @CommandLine.Option(names={"--jar"}, description={"Compile an executable jar"})
        private Path inputJar;
        @CommandLine.Option(names={"--output-path"}, description={"Specify directory where build files are placed"})
        private Path outputPath;
        @CommandLine.Option(names={"--output-name", "-o"}, defaultValue="a.out", description={"Specify the name of the output executable file or library"})
        private String outputName;
        @CommandLine.Option(names={"--no-compile-output"}, negatable=true, defaultValue="true", description={"Enable/disable compilation of output files"})
        boolean compileOutput;
        @CommandLine.Option(names={"--source-output-path"}, required=false, description={"Specify directory where sources for debugging are placed"})
        private Path sourceOutputPath;
        @CommandLine.Option(names={"--debug"})
        private boolean debug;
        @CommandLine.Option(names={"--debug-vtables"})
        private boolean debugVTables;
        @CommandLine.Option(names={"--dispatch-stats"})
        private boolean dispatchStats;
        @CommandLine.Option(names={"--debug-reachability"})
        private boolean debugReachability;
        @CommandLine.Option(names={"--debug-supers"})
        private boolean debugSupers;
        @CommandLine.Option(names={"--debug-devirt"})
        private boolean debugDevirt;
        @CommandLine.Option(names={"--debug-interpreter"})
        private boolean debugInterpreter;
        @CommandLine.Option(names={"--emit-asm"}, negatable=true, defaultValue="false", description={"Enable emitting assembly for each class"})
        private boolean emitAssembly;
        @CommandLine.Option(names={"--gc"}, defaultValue="none", description={"Type of GC to use. Valid values: ${COMPLETION-CANDIDATES}"})
        private GCType gc;
        @CommandLine.Option(names={"--heap-stats"})
        private boolean heapStats;
        @CommandLine.Option(names={"--method-data-stats"})
        private boolean methodDataStats;
        @CommandLine.Option(names={"--pie"}, negatable=true, defaultValue="false", description={"[Disable|Enable] generation of position independent executable"})
        private boolean isPie;
        @CommandLine.Option(names={"--platform"}, converter={PlatformConverter.class})
        private Platform platform;
        @CommandLine.Option(names={"--string-pool-stats"})
        private boolean stringPoolStats;
        @CommandLine.Option(names={"--library-search-path", "-L"}, description={"Additional library search paths"})
        private List<Path> libSearchPaths;
        @CommandLine.Option(names={"--small-type-ids"}, negatable=true, defaultValue="false", description={"Use narrow (16-bit) type ID values if true, wide (32-bit) type ID values if false"})
        private boolean smallTypeIds;
        @CommandLine.Option(names={"--backend"}, defaultValue="llvm", description={"The backend type to use. Valid values: ${COMPLETION-CANDIDATES}"})
        private Backend backend;
        @CommandLine.Parameters(index="0", arity="1", defaultValue="", description={"Application main class"})
        private String mainClass;
        @CommandLine.ArgGroup(exclusive=false, multiplicity="0..1", heading="Options for controlling generation of graphs for methods%n")
        private GraphGenArgs graphGenArgs;
        @CommandLine.ArgGroup(exclusive=false, heading="Options for controlling optimizations%n")
        private OptArgs optArgs = new OptArgs();
        @CommandLine.ArgGroup(exclusive=false, heading="Options for controlling the LLVM backend%n")
        private LLVMArgs llvmArgs = new LLVMArgs();
        private GraphGenConfig graphGenConfig = new GraphGenConfig();

        private CommandLineProcessor() {
        }

        @CommandLine.Option(names={"--boot-path-prepend-artifact"}, converter={ClassPathEntry.MavenArtifact.Converter.class})
        void prependBootPathArtifact(List<ClassPathEntry.MavenArtifact> artifact) {
            this.prependedBootPathEntries.addAll(artifact);
        }

        @CommandLine.Option(names={"--boot-path-prepend-file"}, converter={ClassPathEntry.FilePath.Converter.class})
        void prependBootPathFile(List<ClassPathEntry.FilePath> filePath) {
            this.prependedBootPathEntries.addAll(filePath);
        }

        @CommandLine.Option(names={"--boot-path-append-artifact"}, converter={ClassPathEntry.MavenArtifact.Converter.class})
        void appendBootPathArtifact(List<ClassPathEntry.MavenArtifact> artifact) {
            this.appendedBootPathEntries.addAll(artifact);
        }

        @CommandLine.Option(names={"--boot-path-append-file"}, converter={ClassPathEntry.FilePath.Converter.class})
        void appendBootPathFile(List<ClassPathEntry.FilePath> filePath) {
            this.appendedBootPathEntries.addAll(filePath);
        }

        @CommandLine.Option(names={"--app-path-artifact"}, converter={ClassPathEntry.MavenArtifact.Converter.class})
        void addAppPathArtifact(List<ClassPathEntry.MavenArtifact> artifact) {
            this.appPathEntries.addAll(artifact);
        }

        @CommandLine.Option(names={"--app-path-file"}, converter={ClassPathEntry.FilePath.Converter.class})
        void addAppPathFile(List<ClassPathEntry.FilePath> filePath) {
            this.appPathEntries.addAll(filePath);
        }

        @CommandLine.Option(names={"--qbicc-feature"}, description={"qbicc build configuration file"})
        void addQbiccFeature(List<Path> features) {
            for (Path p : features) {
                try {
                    this.qbiccFeatures.add(p.toAbsolutePath().toUri().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }

        public CmdResult process(String[] args) {
            try {
                CommandLine commandLine = new CommandLine((Object)this);
                CommandLine.ParseResult parseResult = commandLine.parseArgs(args);
                if (CommandLine.printHelpIfRequested((CommandLine.ParseResult)parseResult)) {
                    return CmdResult.CMD_RESULT_HELP;
                }
            }
            catch (CommandLine.ParameterException ex) {
                System.err.println(ex.getMessage());
                ex.getCommandLine().usage(System.err);
                return CmdResult.CMD_RESULT_ERROR;
            }
            if (this.debug) {
                Logger.getLogger((String)"").setLevel((Level)org.jboss.logmanager.Level.DEBUG);
            }
            if (this.debugVTables) {
                Logger.getLogger((String)"org.qbicc.plugin.dispatch.tables").setLevel((Level)org.jboss.logmanager.Level.DEBUG);
            }
            if (this.dispatchStats) {
                Logger.getLogger((String)"org.qbicc.plugin.dispatch.stats").setLevel((Level)org.jboss.logmanager.Level.DEBUG);
            }
            if (this.debugReachability) {
                Logger.getLogger((String)"org.qbicc.plugin.reachability").setLevel((Level)org.jboss.logmanager.Level.DEBUG);
            }
            if (this.debugSupers) {
                Logger.getLogger((String)"org.qbicc.plugin.instanceofcheckcast.supers").setLevel((Level)org.jboss.logmanager.Level.DEBUG);
            }
            if (this.debugDevirt) {
                Logger.getLogger((String)"org.qbicc.plugin.dispatch.devirt").setLevel((Level)org.jboss.logmanager.Level.DEBUG);
            }
            if (this.debugInterpreter) {
                Logger.getLogger((String)"org.qbicc.interpreter").setLevel((Level)org.jboss.logmanager.Level.DEBUG);
            }
            if (this.heapStats) {
                Logger.getLogger((String)"org.qbicc.plugin.serialization.stats").setLevel((Level)org.jboss.logmanager.Level.DEBUG);
            }
            if (this.methodDataStats) {
                Logger.getLogger((String)"org.qbicc.plugin.methodinfo.stats").setLevel((Level)org.jboss.logmanager.Level.DEBUG);
            }
            if (this.stringPoolStats) {
                Logger.getLogger((String)"org.qbicc.plugin.stringpool.stats").setLevel((Level)org.jboss.logmanager.Level.DEBUG);
            }
            if (this.outputPath == null) {
                this.outputPath = Path.of(System.getProperty("java.io.tmpdir"), "qbicc-output-" + Integer.toHexString(ThreadLocalRandom.current().nextInt()));
            }
            if (this.graphGenArgs != null && this.graphGenArgs.genGraph) {
                this.graphGenConfig.setEnabled(true);
                if (this.graphGenArgs.methodsAndPhases == null) {
                    this.graphGenConfig.addMethodAndPhase("all", "all");
                } else {
                    for (GraphGenMethodsPhases option : this.graphGenArgs.methodsAndPhases) {
                        for (String method : option.methods) {
                            for (String phase : option.phases) {
                                this.graphGenConfig.addMethodAndPhase(method, phase);
                            }
                        }
                    }
                }
            }
            return CmdResult.CMD_RESULT_OK;
        }

        static class OptArgs {
            @CommandLine.Option(names={"--opt-memory-tracking"}, negatable=true, defaultValue="false", description={"Enable/disable redundant store/load tracking and elimination"})
            boolean optMemoryTracking;
            @CommandLine.Option(names={"--opt-inlining"}, negatable=true, defaultValue="false", description={"Enable/disable inliner"})
            boolean optInlining;
            @CommandLine.Option(names={"--no-opt-phis"}, negatable=true, defaultValue="true", description={"Enable/disable `phi` elimination"})
            boolean optPhis;
            @CommandLine.Option(names={"--no-opt-gotos"}, negatable=true, defaultValue="true", description={"Enable/disable `goto` elimination"})
            boolean optGotos;
            @CommandLine.Option(names={"--escape-analysis"}, negatable=true, defaultValue="false", description={"Enable/disable escape analysis"})
            boolean optEscapeAnalysis;

            OptArgs() {
            }
        }

        static class LLVMArgs {
            @CommandLine.Option(names={"--emit-llvm-ir"}, negatable=true, defaultValue="false", description={"Enable emitting LLVM IR for each class"})
            boolean emitIr;
            @CommandLine.Option(names={"--llvm-llc-option"}, split=",", description={"Pass options to the LLVM llc command"})
            private List<String> llcOptions = new ArrayList<String>();
            @CommandLine.Option(names={"--llvm-opaque-pointers"}, negatable=true, defaultValue="false", description={"Enable LLVM opaque pointers"})
            boolean opaquePointers;

            LLVMArgs() {
            }
        }

        private static class GraphGenArgs {
            @CommandLine.Option(names={"-g", "--gen-graph"}, required=true, description={"Enable generation of graphs"})
            boolean genGraph;
            @CommandLine.ArgGroup(exclusive=false, multiplicity="0..*")
            List<GraphGenMethodsPhases> methodsAndPhases;

            private GraphGenArgs() {
            }
        }

        private static class GraphGenMethodsPhases {
            @CommandLine.Option(names={"-m", "--methods"}, required=false, split=",", defaultValue="all", description={"List of methods separated by comma. Default: ${DEFAULT-VALUE}"})
            List<String> methods;
            @CommandLine.Option(names={"-p", "--phases"}, required=false, split=",", defaultValue="all", description={"List of phases separated by comma. Default: ${DEFAULT-VALUE}"})
            List<String> phases;

            private GraphGenMethodsPhases() {
            }
        }

        private static enum GCType {
            NONE("none");

            private final String gcType;

            private GCType(String type) {
                this.gcType = type;
            }

            public String toString() {
                return this.gcType;
            }
        }
    }

    private static enum CmdResult {
        CMD_RESULT_HELP,
        CMD_RESULT_OK,
        CMD_RESULT_ERROR;

    }

    static class VersionProvider
    implements CommandLine.IVersionProvider {
        VersionProvider() {
        }

        public String[] getVersion() {
            return new String[]{"Qbicc version " + Version.QBICC_VERSION};
        }
    }
}

