/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.main;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.jboss.logging.Logger;
import org.qbicc.context.DiagnosticContext;
import org.qbicc.machine.arch.Platform;
import org.qbicc.machine.object.ObjectFileProvider;
import org.qbicc.machine.probe.CProbe;
import org.qbicc.machine.tool.CToolChain;
import org.qbicc.plugin.gc.nogc.NoGcTypeSystemConfigurator;
import org.qbicc.type.TypeSystem;

public class PlatformTypeSystemLoader {
    private static final Logger log = Logger.getLogger((String)"org.qbicc.main.PlatformTypeSystemLoader");
    private static final CProbe.Type char_t = CProbe.Type.builder().setName("char").build();
    private static final CProbe.Type int8_t = CProbe.Type.builder().setName("int8_t").build();
    private static final CProbe.Type int16_t = CProbe.Type.builder().setName("int16_t").build();
    private static final CProbe.Type int32_t = CProbe.Type.builder().setName("int32_t").build();
    private static final CProbe.Type int64_t = CProbe.Type.builder().setName("int64_t").build();
    private static final CProbe.Type float_t = CProbe.Type.builder().setName("float").build();
    private static final CProbe.Type double_t = CProbe.Type.builder().setName("double").build();
    private static final CProbe.Type _Bool = CProbe.Type.builder().setName("_Bool").build();
    private static final CProbe.Type void_p = CProbe.Type.builder().setName("void *").build();
    private static final CProbe.Type max_align_t = CProbe.Type.builder().setName("max_align_t").build();
    private final Platform platform;
    private final CToolChain toolChain;
    private final ObjectFileProvider objectFileProvider;
    private final DiagnosticContext initialContext;
    private final ReferenceType referenceType;
    private final boolean smallTypeIds;
    private final boolean nogc;

    public PlatformTypeSystemLoader(Platform platform, CToolChain toolChain, ObjectFileProvider objectFileProvider, DiagnosticContext initialContext, ReferenceType referenceType, boolean smallTypeIds, boolean nogc) {
        this.platform = platform;
        this.toolChain = toolChain;
        this.objectFileProvider = objectFileProvider;
        this.initialContext = initialContext;
        this.smallTypeIds = smallTypeIds;
        this.nogc = nogc;
        this.referenceType = referenceType;
    }

    private static CProbe makeProbe() {
        CProbe.Builder probeBuilder = CProbe.builder();
        probeBuilder.include("<stdint.h>");
        probeBuilder.include("<limits.h>");
        probeBuilder.probeType(char_t);
        probeBuilder.probeType(int8_t);
        probeBuilder.probeType(int16_t);
        probeBuilder.probeType(int32_t);
        probeBuilder.probeType(int64_t);
        probeBuilder.probeType(float_t);
        probeBuilder.probeType(double_t);
        probeBuilder.probeType(_Bool);
        probeBuilder.probeType(void_p);
        probeBuilder.probeConstant("CHAR_BIT");
        probeBuilder.probeType(max_align_t);
        return probeBuilder.build();
    }

    TypeSystem load() throws IOException {
        TypeSystem typeSystem = this.fromYaml();
        if (typeSystem == null) {
            log.warnf("Failed to load type info for platform %s, using probe.", (Object)this.platform);
            typeSystem = this.fromProbe();
        }
        return typeSystem;
    }

    TypeSystem fromProbe() throws IOException {
        CProbe probe = PlatformTypeSystemLoader.makeProbe();
        CProbe.Result probeResult = probe.run(this.toolChain, this.objectFileProvider, this.initialContext);
        if (probeResult != null) {
            long charSize = probeResult.getTypeInfo(char_t).getSize();
            if (charSize != 1L) {
                this.initialContext.error("Unexpected size of `char`: %d", new Object[]{charSize});
            }
            TypeSystem.Builder tsBuilder = TypeSystem.builder();
            tsBuilder.setBoolSize((int)probeResult.getTypeInfo(_Bool).getSize());
            tsBuilder.setBoolAlignment((int)probeResult.getTypeInfo(_Bool).getAlign());
            tsBuilder.setByteBits(probeResult.getConstantInfo("CHAR_BIT").getValueAsInt());
            tsBuilder.setSignedChar(probeResult.getTypeInfo(char_t).isSigned());
            tsBuilder.setInt8Size((int)probeResult.getTypeInfo(int8_t).getSize());
            tsBuilder.setInt8Alignment((int)probeResult.getTypeInfo(int8_t).getAlign());
            tsBuilder.setInt16Size((int)probeResult.getTypeInfo(int16_t).getSize());
            tsBuilder.setInt16Alignment((int)probeResult.getTypeInfo(int16_t).getAlign());
            tsBuilder.setInt32Size((int)probeResult.getTypeInfo(int32_t).getSize());
            tsBuilder.setInt32Alignment((int)probeResult.getTypeInfo(int32_t).getAlign());
            tsBuilder.setInt64Size((int)probeResult.getTypeInfo(int64_t).getSize());
            tsBuilder.setInt64Alignment((int)probeResult.getTypeInfo(int64_t).getAlign());
            tsBuilder.setFloat32Size((int)probeResult.getTypeInfo(float_t).getSize());
            tsBuilder.setFloat32Alignment((int)probeResult.getTypeInfo(float_t).getAlign());
            tsBuilder.setFloat64Size((int)probeResult.getTypeInfo(double_t).getSize());
            tsBuilder.setFloat64Alignment((int)probeResult.getTypeInfo(double_t).getAlign());
            tsBuilder.setPointerSize((int)probeResult.getTypeInfo(void_p).getSize());
            tsBuilder.setPointerAlignment((int)probeResult.getTypeInfo(void_p).getAlign());
            tsBuilder.setMaxAlignment((int)probeResult.getTypeInfo(max_align_t).getAlign());
            tsBuilder.setReferenceSize((int)probeResult.getTypeInfo(this.referenceType.type).getSize());
            tsBuilder.setReferenceAlignment((int)probeResult.getTypeInfo(this.referenceType.type).getAlign());
            CProbe.Type type_id_type = this.smallTypeIds ? int16_t : int32_t;
            tsBuilder.setTypeIdSize((int)probeResult.getTypeInfo(type_id_type).getSize());
            tsBuilder.setTypeIdAlignment((int)probeResult.getTypeInfo(type_id_type).getAlign());
            tsBuilder.setEndianness(probeResult.getByteOrder());
            if (this.nogc) {
                new NoGcTypeSystemConfigurator().accept(tsBuilder);
            }
            return tsBuilder.build();
        }
        this.initialContext.error("Type system probe compiler execution failed", new Object[0]);
        return null;
    }

    TypeSystem fromYaml() throws IOException {
        String fpath = "bundles/" + this.platform.toString() + "/platform-type-info.yaml";
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(fpath);
        if (stream == null) {
            return null;
        }
        JsonNode jsonNode = new ObjectMapper((JsonFactory)new YAMLFactory()).readTree(stream);
        JsonNode platformTypeInfo = jsonNode.get("platform-type-info");
        TypeSystem.Builder tsBuilder = TypeSystem.builder();
        JsonNode boolean_t = platformTypeInfo.get("boolean");
        tsBuilder.setBoolSize(boolean_t.get("size").asInt());
        tsBuilder.setBoolAlignment(boolean_t.get("align").asInt());
        tsBuilder.setByteBits(platformTypeInfo.get("byte-bits").asInt());
        tsBuilder.setSignedChar(platformTypeInfo.get("signed-char").asBoolean());
        JsonNode int8_t = platformTypeInfo.get("int8");
        tsBuilder.setInt8Size(int8_t.get("size").asInt());
        tsBuilder.setInt8Alignment(int8_t.get("align").asInt());
        JsonNode int16_t = platformTypeInfo.get("int16");
        tsBuilder.setInt16Size(int16_t.get("size").asInt());
        tsBuilder.setInt16Alignment(int16_t.get("align").asInt());
        JsonNode int32_t = platformTypeInfo.get("int32");
        tsBuilder.setInt32Size(int32_t.get("size").asInt());
        tsBuilder.setInt32Alignment(int32_t.get("align").asInt());
        JsonNode int64_t = platformTypeInfo.get("int64");
        tsBuilder.setInt64Size(int64_t.get("size").asInt());
        tsBuilder.setInt64Alignment(int64_t.get("align").asInt());
        JsonNode float32_t = platformTypeInfo.get("float32");
        tsBuilder.setFloat32Size(float32_t.get("size").asInt());
        tsBuilder.setFloat32Alignment(float32_t.get("align").asInt());
        JsonNode float64_t = platformTypeInfo.get("float64");
        tsBuilder.setFloat64Size(float64_t.get("size").asInt());
        tsBuilder.setFloat64Alignment(float64_t.get("align").asInt());
        JsonNode pointer_t = platformTypeInfo.get("pointer");
        tsBuilder.setPointerSize(pointer_t.get("size").asInt());
        tsBuilder.setPointerAlignment(pointer_t.get("align").asInt());
        tsBuilder.setMaxAlignment(platformTypeInfo.get("max-alignment").asInt());
        JsonNode reference_t = platformTypeInfo.get(this.referenceType.jsonField);
        tsBuilder.setReferenceSize(reference_t.get("size").asInt());
        tsBuilder.setReferenceAlignment(reference_t.get("align").asInt());
        JsonNode type_id_t = this.smallTypeIds ? int16_t : int32_t;
        tsBuilder.setTypeIdSize(type_id_t.get("size").asInt());
        tsBuilder.setTypeIdAlignment(type_id_t.get("align").asInt());
        tsBuilder.setEndianness(this.endianness(platformTypeInfo.get("endian").asText()));
        if (this.nogc) {
            new NoGcTypeSystemConfigurator().accept(tsBuilder);
        }
        return tsBuilder.build();
    }

    ByteOrder endianness(String endianness) {
        return switch (endianness) {
            case "little" -> ByteOrder.LITTLE_ENDIAN;
            case "big" -> ByteOrder.BIG_ENDIAN;
            default -> throw new IllegalArgumentException(endianness);
        };
    }

    public static enum ReferenceType {
        POINTER(void_p, "pointer"),
        INT64(int64_t, "int64"),
        INT32(int32_t, "int32");

        private final CProbe.Type type;
        private final String jsonField;

        private ReferenceType(CProbe.Type type, String jsonField) {
            this.type = type;
            this.jsonField = jsonField;
        }
    }
}

