/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.constants;

import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMap;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.literal.BooleanLiteral;
import org.qbicc.graph.literal.FloatLiteral;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.graph.literal.StaticFieldLiteral;
import org.qbicc.graph.literal.StaticMethodLiteral;
import org.qbicc.graph.literal.StringLiteral;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.interpreter.Thrown;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmThread;
import org.qbicc.plugin.constants.Constants;
import org.qbicc.type.FloatType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.NullableType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.StaticMethodType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.definition.element.StaticMethodElement;

public class ConstantBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();
    private static final Object[] NO_ARGS = new Object[0];

    public ConstantBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value load(Value pointer, ReadAccessMode accessMode) {
        if (pointer instanceof StaticFieldLiteral) {
            Literal initialValue;
            StaticFieldLiteral sf = (StaticFieldLiteral)pointer;
            StaticFieldElement fieldElement = sf.getVariableElement();
            Value constantValue = Constants.get(this.ctxt).getConstantValue((FieldElement)fieldElement);
            if (constantValue != null) {
                return constantValue;
            }
            if (fieldElement.isReallyFinal() && (initialValue = fieldElement.getInitialValue()) != null) {
                return initialValue;
            }
        }
        return this.getDelegate().load(pointer, accessMode);
    }

    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        if (targetPtr.isFold()) {
            try {
                return this.fold(targetPtr, arguments);
            }
            catch (Thrown t) {
                throw new BlockEarlyTermination(this.throw_((Value)this.getLiteralFactory().literalOf((VmObject)t.getThrowable())));
            }
        }
        return super.call(targetPtr, receiver, arguments);
    }

    public Value callNoSideEffects(Value targetPtr, Value receiver, List<Value> arguments) {
        return targetPtr.isFold() ? this.fold(targetPtr, arguments) : super.callNoSideEffects(targetPtr, receiver, arguments);
    }

    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        if (targetPtr.isFold()) {
            try {
                return this.return_(this.fold(targetPtr, arguments));
            }
            catch (Thrown t) {
                return this.throw_((Value)this.getLiteralFactory().literalOf((VmObject)t.getThrowable()));
            }
        }
        return super.tailCall(targetPtr, receiver, arguments);
    }

    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        if (targetPtr.isFold()) {
            ImmutableMap immutableMap = Maps.immutable.ofMap(targetArguments);
            try {
                Value result = this.fold(targetPtr, arguments);
                this.goto_(resumeLabel, immutableMap.newWithKeyValue((Object)Slot.result(), (Object)result).castToMap());
                return result;
            }
            catch (Thrown t) {
                this.goto_(catchLabel, immutableMap.newWithKeyValue((Object)Slot.thrown(), (Object)this.getLiteralFactory().literalOf((VmObject)t.getThrowable())).castToMap());
            }
        }
        return super.invoke(targetPtr, receiver, arguments, catchLabel, resumeLabel, targetArguments);
    }

    private Value fold(Value targetPtr, List<Value> arguments) throws Thrown {
        if (targetPtr instanceof StaticMethodLiteral) {
            ValueType valueType;
            StaticMethodLiteral sh = (StaticMethodLiteral)targetPtr;
            StaticMethodType smt = sh.getPointeeType();
            int size = arguments.size();
            Object[] args = size == 0 ? NO_ARGS : new Object[size];
            for (int i = 0; i < size; ++i) {
                args[i] = this.mapValue(arguments.get(i));
            }
            StaticMethodElement method = sh.getExecutable();
            VmThread thread = Vm.requireCurrentThread();
            Vm vm = thread.getVM();
            Object resultObj = vm.invokeExact((MethodElement)method, null, List.of(args));
            if (resultObj instanceof Boolean) {
                Boolean result = (Boolean)resultObj;
                return this.ctxt.getLiteralFactory().literalOf(result.booleanValue());
            }
            if (resultObj instanceof Byte) {
                Byte result = (Byte)resultObj;
                return this.ctxt.getLiteralFactory().literalOf(result.byteValue());
            }
            if (resultObj instanceof Short) {
                Short result = (Short)resultObj;
                return this.ctxt.getLiteralFactory().literalOf(result.shortValue());
            }
            if (resultObj instanceof Integer) {
                Integer result = (Integer)resultObj;
                return this.ctxt.getLiteralFactory().literalOf(result.intValue());
            }
            if (resultObj instanceof Long) {
                Long result = (Long)resultObj;
                return this.ctxt.getLiteralFactory().literalOf(result.longValue());
            }
            if (resultObj instanceof Character) {
                Character result = (Character)resultObj;
                return this.ctxt.getLiteralFactory().literalOf(result.charValue());
            }
            if (resultObj instanceof Float) {
                Float result = (Float)resultObj;
                return this.ctxt.getLiteralFactory().literalOf(result.floatValue());
            }
            if (resultObj instanceof Double) {
                Double result = (Double)resultObj;
                return this.ctxt.getLiteralFactory().literalOf(result.doubleValue());
            }
            if (resultObj instanceof VmObject) {
                VmObject result = (VmObject)resultObj;
                return this.ctxt.getLiteralFactory().literalOf(result);
            }
            if (resultObj instanceof ValueType) {
                ValueType result = (ValueType)resultObj;
                return this.ctxt.getLiteralFactory().literalOfType(result);
            }
            if (resultObj == null && (valueType = smt.getReturnType()) instanceof NullableType) {
                NullableType nt = (NullableType)valueType;
                return this.ctxt.getLiteralFactory().nullLiteralOfType(nt);
            }
            this.ctxt.error(this.getLocation(), "Unmappable constant-folded return value %s", new Object[]{resultObj});
            throw new BlockEarlyTermination(this.unreachable());
        }
        this.ctxt.error(this.getLocation(), "Only static methods may be folded", new Object[0]);
        throw new BlockEarlyTermination(this.unreachable());
    }

    private Object mapValue(Value value) {
        if (value instanceof IntegerLiteral) {
            IntegerLiteral lit = (IntegerLiteral)value;
            IntegerType type = lit.getType();
            boolean signed = type instanceof SignedIntegerType;
            if (type.getMinBits() == 8) {
                return lit.byteValue();
            }
            if (type.getMinBits() == 16) {
                if (signed) {
                    return lit.shortValue();
                }
                return Character.valueOf(lit.charValue());
            }
            if (type.getMinBits() == 32) {
                return lit.intValue();
            }
            if (type.getMinBits() == 64) {
                return lit.longValue();
            }
        } else {
            if (value instanceof BooleanLiteral) {
                BooleanLiteral lit = (BooleanLiteral)value;
                return lit.booleanValue();
            }
            if (value instanceof FloatLiteral) {
                FloatLiteral lit = (FloatLiteral)value;
                FloatType type = lit.getType();
                if (type.getMinBits() == 32) {
                    return Float.valueOf(lit.floatValue());
                }
                if (type.getMinBits() == 64) {
                    return lit.doubleValue();
                }
            } else {
                if (value instanceof ObjectLiteral) {
                    ObjectLiteral lit = (ObjectLiteral)value;
                    return lit.getValue();
                }
                if (value instanceof StringLiteral) {
                    StringLiteral lit = (StringLiteral)value;
                    return Vm.requireCurrent().intern(lit.getValue());
                }
                if (value instanceof TypeLiteral) {
                    TypeLiteral lit = (TypeLiteral)value;
                    return lit.getValue();
                }
            }
        }
        this.ctxt.error(this.getLocation(), "Unmappable parameter value %s for constant folding (must be a constant/literal value)", new Object[]{value});
        throw new BlockEarlyTermination(this.unreachable());
    }
}

