/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.constants;

import io.smallrye.common.function.Functions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Value;
import org.qbicc.type.definition.element.FieldElement;

public final class Constants {
    private static final AttachmentKey<Constants> KEY = new AttachmentKey();
    private final ConcurrentMap<FieldElement, Supplier<Value>> constants = new ConcurrentHashMap<FieldElement, Supplier<Value>>(128);

    Constants() {
    }

    public static Constants get(CompilationContext ctxt) {
        Constants appearing;
        Constants constants = (Constants)ctxt.getAttachment(KEY);
        if (constants == null && (appearing = (Constants)ctxt.putAttachmentIfAbsent(KEY, (Object)(constants = new Constants()))) != null) {
            constants = appearing;
        }
        return constants;
    }

    public boolean registerConstant(FieldElement element, Supplier<Value> factory) {
        return this.constants.putIfAbsent(element, new ConstantFactory(element, factory)) == null;
    }

    public Value getConstantValue(FieldElement element) {
        Supplier supplier = (Supplier)this.constants.get(element);
        return supplier == null ? null : (Value)supplier.get();
    }

    final class ConstantFactory
    implements Supplier<Value> {
        private final FieldElement fieldElement;
        private final Supplier<Value> probe;
        private volatile Value value;

        ConstantFactory(FieldElement fieldElement, Supplier<Value> probe) {
            this.fieldElement = fieldElement;
            this.probe = probe;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Value get() {
            Value value = this.value;
            if (value == null) {
                ConstantFactory constantFactory = this;
                synchronized (constantFactory) {
                    value = this.value;
                    if (value == null) {
                        this.value = value = this.probe.get();
                        Constants.this.constants.replace(this.fieldElement, this, Functions.constantSupplier((Object)value));
                    }
                }
            }
            return value;
        }
    }
}

