/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.conversion;

import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.MethodLiteral;
import org.qbicc.type.BooleanType;
import org.qbicc.type.FloatType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.TypeType;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.LoadedTypeDefinition;

public class NumericalConversionBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();

    public NumericalConversionBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value truncate(Value from, WordType toType) {
        ValueType fromTypeRaw = from.getType();
        if (fromTypeRaw instanceof WordType) {
            WordType fromType = (WordType)fromTypeRaw;
            if (fromType instanceof SignedIntegerType) {
                if (toType instanceof SignedIntegerType) {
                    if (fromType.getMinBits() > toType.getMinBits()) {
                        return super.truncate(from, toType);
                    }
                    if (fromType.getMinBits() <= toType.getMinBits()) {
                        return from;
                    }
                } else {
                    if (toType instanceof UnsignedIntegerType) {
                        return this.truncate(this.bitCast(from, (WordType)((SignedIntegerType)fromType).asUnsigned()), toType);
                    }
                    if (toType instanceof BooleanType) {
                        return super.truncate(from, toType);
                    }
                    if (toType instanceof TypeType) {
                        if (fromType.getMinBits() > toType.getMinBits()) {
                            return super.truncate(from, toType);
                        }
                        return from;
                    }
                }
            } else if (fromType instanceof UnsignedIntegerType) {
                if (toType instanceof UnsignedIntegerType) {
                    if (fromType.getMinBits() > toType.getMinBits()) {
                        return super.truncate(from, toType);
                    }
                    if (fromType.getMinBits() <= toType.getMinBits()) {
                        return from;
                    }
                } else {
                    if (toType instanceof SignedIntegerType) {
                        return this.truncate(this.bitCast(from, (WordType)((UnsignedIntegerType)fromType).asSigned()), toType);
                    }
                    if (toType instanceof BooleanType) {
                        return super.truncate(from, toType);
                    }
                }
            } else if (fromType instanceof FloatType) {
                if (toType instanceof FloatType) {
                    if (fromType.getMinBits() > toType.getMinBits()) {
                        return super.truncate(from, toType);
                    }
                    if (fromType.getMinBits() <= toType.getMinBits()) {
                        return from;
                    }
                }
            } else if (fromType instanceof BooleanType && toType instanceof BooleanType) {
                return from;
            }
        }
        this.ctxt.error(this.getLocation(), "Invalid truncation of %s to %s", new Object[]{fromTypeRaw, toType});
        return super.truncate(from, toType);
    }

    public Value extend(Value from, WordType toType) {
        ValueType fromTypeRaw = from.getType();
        if (fromTypeRaw instanceof WordType) {
            WordType fromType = (WordType)fromTypeRaw;
            if (fromType instanceof SignedIntegerType) {
                if (toType instanceof SignedIntegerType) {
                    if (fromType.getMinBits() < toType.getMinBits()) {
                        return super.extend(from, toType);
                    }
                    if (fromType.getMinBits() >= toType.getMinBits()) {
                        return from;
                    }
                } else if (toType instanceof UnsignedIntegerType) {
                    this.ctxt.error(this.getLocation(), "Cannot extend a signed integer of type %s into a wider unsigned integer of type %s: either sign-extend to %s first or cast to %s first", new Object[]{fromType, toType, ((UnsignedIntegerType)toType).asSigned(), ((SignedIntegerType)fromType).asUnsigned()});
                    return super.extend(from, toType);
                }
            } else if (fromType instanceof UnsignedIntegerType || fromType instanceof BooleanType) {
                if (toType instanceof UnsignedIntegerType) {
                    if (fromType.getMinBits() < toType.getMinBits() || fromType instanceof BooleanType) {
                        return super.extend(from, toType);
                    }
                    if (fromType.getMinBits() >= toType.getMinBits()) {
                        return from;
                    }
                } else if (toType instanceof SignedIntegerType) {
                    return this.bitCast(super.extend(from, (WordType)((SignedIntegerType)toType).asUnsigned()), toType);
                }
            } else if (fromType instanceof FloatType) {
                if (toType instanceof FloatType) {
                    if (fromType.getMinBits() < toType.getMinBits()) {
                        return super.extend(from, toType);
                    }
                    if (fromType.getMinBits() >= toType.getMinBits()) {
                        return from;
                    }
                }
            } else if (fromType instanceof TypeType && toType instanceof IntegerType) {
                if (fromType.getMinBits() < toType.getMinBits()) {
                    return super.extend(from, toType);
                }
                if (fromType.getMinBits() >= toType.getMinBits()) {
                    return from;
                }
            }
        }
        this.ctxt.error(this.getLocation(), "Invalid extension of %s to %s", new Object[]{fromTypeRaw, toType});
        return super.extend(from, toType);
    }

    public Value bitCast(Value from, WordType toType) {
        WordType fromType;
        ValueType fromTypeRaw = from.getType();
        if (fromTypeRaw.equals((ValueType)toType)) {
            return from;
        }
        if (from instanceof IntegerLiteral && ((IntegerLiteral)from).isZero()) {
            return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)toType);
        }
        if (fromTypeRaw instanceof WordType && (fromType = (WordType)fromTypeRaw).getMinBits() == toType.getMinBits()) {
            return super.bitCast(from, toType);
        }
        this.ctxt.error(this.getLocation(), "Invalid bitcast from %s to %s", new Object[]{fromTypeRaw, toType});
        return super.bitCast(from, toType);
    }

    public Value valueConvert(Value from, WordType toTypeRaw) {
        BasicBlockBuilder fb = this.getFirstBuilder();
        LiteralFactory lf = this.getLiteralFactory();
        ValueType fromTypeRaw = from.getType();
        if (fromTypeRaw instanceof FloatType) {
            FloatType fromType = (FloatType)fromTypeRaw;
            if (toTypeRaw instanceof IntegerType) {
                IntegerType toType = (IntegerType)toTypeRaw;
                ClassContext bcc = this.ctxt.getBootstrapClassContext();
                LoadedTypeDefinition cNative = bcc.findDefinedType("org/qbicc/runtime/CNative").load();
                if (fromType.getMinBits() == 32) {
                    if (toType.getMinBits() == 32) {
                        MethodLiteral floatToInt = lf.literalOf(cNative.requireSingleMethod(me -> me.nameEquals("floatToInt")));
                        return fb.callNoSideEffects((Value)floatToInt, List.of(from));
                    }
                    if (toType.getMinBits() == 64) {
                        MethodLiteral floatToLong = lf.literalOf(cNative.requireSingleMethod(me -> me.nameEquals("floatToLong")));
                        return fb.callNoSideEffects((Value)floatToLong, List.of(from));
                    }
                } else if (fromType.getMinBits() == 64) {
                    if (toType.getMinBits() == 32) {
                        MethodLiteral doubleToInt = lf.literalOf(cNative.requireSingleMethod(me -> me.nameEquals("doubleToInt")));
                        return fb.callNoSideEffects((Value)doubleToInt, List.of(from));
                    }
                    if (toType.getMinBits() == 64) {
                        MethodLiteral doubleToLong = lf.literalOf(cNative.requireSingleMethod(me -> me.nameEquals("doubleToLong")));
                        return fb.callNoSideEffects((Value)doubleToLong, List.of(from));
                    }
                }
                this.ctxt.error(this.getLocation(), "Unsupported floating-point conversion from %s to %s", new Object[]{fromTypeRaw, toTypeRaw});
                return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)toTypeRaw);
            }
        } else if (fromTypeRaw instanceof IntegerType) {
            if (toTypeRaw instanceof FloatType) {
                return super.valueConvert(from, toTypeRaw);
            }
            if (toTypeRaw instanceof PointerType) {
                if (fromTypeRaw.getSize() < toTypeRaw.getSize()) {
                    this.ctxt.error(this.getLocation(), "Invalid pointer conversion from narrower type %s", new Object[]{fromTypeRaw});
                }
                return super.valueConvert(from, toTypeRaw);
            }
        } else if (fromTypeRaw instanceof PointerType) {
            if (toTypeRaw instanceof IntegerType) {
                if (fromTypeRaw.getSize() > toTypeRaw.getSize()) {
                    this.ctxt.error(this.getLocation(), "Invalid pointer conversion to narrower type %s", new Object[]{fromTypeRaw});
                }
                return super.valueConvert(from, toTypeRaw);
            }
            if (toTypeRaw instanceof ReferenceType) {
                return super.valueConvert(from, toTypeRaw);
            }
        } else if (fromTypeRaw instanceof ReferenceType) {
            if (toTypeRaw instanceof PointerType) {
                return super.valueConvert(from, toTypeRaw);
            }
        } else if (fromTypeRaw instanceof TypeType && toTypeRaw instanceof IntegerType) {
            if (fromTypeRaw.getSize() > toTypeRaw.getSize()) {
                this.ctxt.error(this.getLocation(), "Invalid typeid conversion to narrower type %s", new Object[]{fromTypeRaw});
            } else if (fromTypeRaw.getSize() < toTypeRaw.getSize()) {
                return this.extend(from, toTypeRaw);
            }
            return super.valueConvert(from, toTypeRaw);
        }
        this.ctxt.error(this.getLocation(), "Invalid conversion from %s to %s", new Object[]{fromTypeRaw, toTypeRaw});
        return super.valueConvert(from, toTypeRaw);
    }
}

