/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.dispatch;

import org.jboss.logging.Logger;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Value;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.MethodElement;

public class DevirtualizingBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private static final Logger log = Logger.getLogger((String)"org.qbicc.plugin.dispatch.devirt");

    public DevirtualizingBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value lookupInterfaceMethod(Value reference, InstanceMethodElement method) {
        MethodElement exactTarget = this.staticallyBind((MethodElement)method);
        if (exactTarget != null) {
            return this.getLiteralFactory().literalOf(exactTarget);
        }
        InstanceMethodElement virtualTarget = this.virtualizeInvokeInterface(reference, method);
        if (virtualTarget != null) {
            return this.getFirstBuilder().lookupVirtualMethod(reference, virtualTarget);
        }
        return super.lookupInterfaceMethod(reference, method);
    }

    public Value lookupVirtualMethod(Value reference, InstanceMethodElement method) {
        MethodElement exactTarget = this.staticallyBind((MethodElement)method);
        return exactTarget != null ? this.getLiteralFactory().literalOf(exactTarget) : super.lookupVirtualMethod(reference, method);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InstanceMethodElement virtualizeInvokeInterface(Value reference, InstanceMethodElement target) {
        ClassObjectType classType;
        ValueType type = reference.getType();
        if (type instanceof ReferenceType) {
            PhysicalObjectType upperBound = ((ReferenceType)type).getUpperBound();
            if (!(upperBound instanceof ClassObjectType)) return null;
            classType = (ClassObjectType)upperBound;
        } else {
            if (!(type instanceof ClassObjectType)) return null;
            classType = (ClassObjectType)type;
        }
        if (!classType.isSubtypeOf(target.getEnclosingType().load().getObjectType())) {
            return null;
        }
        LoadedTypeDefinition definition = classType.getDefinition().load();
        InstanceMethodElement virtual = (InstanceMethodElement)definition.resolveMethodElementVirtual(this.getCurrentClassContext(), target.getName(), target.getDescriptor());
        if (virtual == null) return null;
        log.debugf("Deinterfacing call to %s::%s", (Object)target.getEnclosingType().getDescriptor(), (Object)target.getName());
        return virtual;
    }

    private MethodElement staticallyBind(MethodElement target) {
        if (target.isFinal() || target.getEnclosingType().isFinal() || target.isPrivate()) {
            log.debugf("Devirtualizing call to %s::%s", (Object)target.getEnclosingType().getDescriptor(), (Object)target.getName());
            return target;
        }
        return null;
    }
}

