/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.gc.common;

import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.plugin.intrinsics.Intrinsics;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class GcCommon {
    private GcCommon() {
    }

    public static void registerIntrinsics(CompilationContext ctxt) {
        GcCommon.registerHeapIntrinsics(ctxt);
    }

    private static void registerHeapIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get((CompilationContext)ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        LiteralFactory lf = classContext.getLiteralFactory();
        TypeSystem ts = classContext.getTypeSystem();
        ClassTypeDescriptor heapDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/gc/heap/Heap");
        MethodDescriptor emptyToLong = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, List.of());
        MethodDescriptor emptyToInt = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of());
        intrinsics.registerIntrinsic((TypeDescriptor)heapDesc, "getConfiguredMinHeapSize", emptyToLong, (builder, targetPtr, arguments) -> lf.literalOf(0x1000000L));
        intrinsics.registerIntrinsic((TypeDescriptor)heapDesc, "getConfiguredMaxHeapSize", emptyToLong, (builder, targetPtr, arguments) -> lf.literalOf(0x8000000L));
        intrinsics.registerIntrinsic((TypeDescriptor)heapDesc, "getConfiguredHeapAlignment", emptyToLong, (builder, targetPtr, arguments) -> lf.literalOf(0x1000000L));
        intrinsics.registerIntrinsic((TypeDescriptor)heapDesc, "getConfiguredObjectAlignment", emptyToInt, (builder, targetPtr, arguments) -> lf.literalOf(ts.getPointerAlignment()));
    }
}

