/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.gc.common;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.type.IntegerType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public class MultiNewArrayExpansionBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private static final Slot TEMP0 = Slot.temp((int)0);

    public MultiNewArrayExpansionBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value multiNewArray(ArrayTypeDescriptor desc, List<Value> dimensions) {
        return this.multiNewArray(desc, dimensions.iterator());
    }

    private Value multiNewArray(ArrayTypeDescriptor desc, Iterator<Value> dimensions) {
        Value dimension = dimensions.next();
        Value newArray = this.newArray(desc, dimension);
        if (!dimensions.hasNext()) {
            return newArray;
        }
        TypeDescriptor elementDesc = desc.getElementTypeDescriptor();
        if (!(elementDesc instanceof ArrayTypeDescriptor)) {
            this.getContext().error(this.getLocation(), "Unexpected array descriptor: %s", new Object[]{elementDesc});
            throw new BlockEarlyTermination(this.unreachable());
        }
        LiteralFactory lf = this.getLiteralFactory();
        TypeSystem ts = this.getTypeSystem();
        SignedIntegerType s32 = ts.getSignedInteger32Type();
        BlockLabel loop = new BlockLabel();
        BlockLabel exit = new BlockLabel();
        BlockLabel resume = new BlockLabel();
        this.goto_(loop, TEMP0, (Value)lf.literalOf((IntegerType)s32, 0L));
        this.begin(loop);
        BlockParameter bp = this.addParam(loop, TEMP0, (ValueType)s32);
        this.if_(this.isEq((Value)bp, dimension), exit, resume, Map.of());
        try {
            this.begin(resume);
            Value innerArray = this.multiNewArray((ArrayTypeDescriptor)elementDesc, dimensions);
            this.store(this.elementOf(this.decodeReference(newArray), (Value)bp), innerArray);
            this.goto_(loop, TEMP0, this.add((Value)bp, (Value)lf.literalOf((IntegerType)s32, 1L)));
        }
        catch (BlockEarlyTermination blockEarlyTermination) {
            // empty catch block
        }
        this.begin(exit);
        return newArray;
    }
}

