/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.gc.common.safepoint;

import java.util.List;
import java.util.function.Consumer;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.plugin.patcher.Patcher;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.MethodBodyFactory;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.descriptor.MethodDescriptor;

public abstract class AbstractSafePointStrategy {
    static final String SAFE_POINT_INT_NAME = "org/qbicc/runtime/main/SafePoint";
    private static final String ENTER_SAFE_POINT = "enterSafePoint";
    private static final String REQUEST_GLOBAL_SAFE_POINT = "requestGlobalSafePoint";
    private static final String CLEAR_GLOBAL_SAFE_POINT = "clearGlobalSafePoint";
    protected final CompilationContext ctxt;

    protected AbstractSafePointStrategy(CompilationContext ctxt) {
        this.ctxt = ctxt;
        Patcher patcher = Patcher.get((CompilationContext)ctxt);
        patcher.replaceMethodBody(ctxt.getBootstrapClassContext(), SAFE_POINT_INT_NAME, REQUEST_GLOBAL_SAFE_POINT, MethodDescriptor.VOID_METHOD_DESCRIPTOR, AbstractSafePointStrategy.adapt(this::implementRequestGlobalSafePoint), 0);
        patcher.replaceMethodBody(ctxt.getBootstrapClassContext(), SAFE_POINT_INT_NAME, CLEAR_GLOBAL_SAFE_POINT, MethodDescriptor.VOID_METHOD_DESCRIPTOR, AbstractSafePointStrategy.adapt(this::implementClearGlobalSafePoint), 0);
    }

    static MethodBodyFactory adapt(Consumer<BasicBlockBuilder> consumer) {
        return (index, element) -> {
            BasicBlockBuilder bbb = element.getEnclosingType().getContext().newBasicBlockBuilder(element);
            consumer.accept(bbb);
            bbb.finish();
            BasicBlock entry = bbb.getFirstBlock();
            return MethodBody.of((BasicBlock)entry, List.of());
        };
    }

    public final void registerReachableMethods(CompilationContext ctxt) {
        LoadedTypeDefinition safePointClass = ctxt.getBootstrapClassContext().findDefinedType(SAFE_POINT_INT_NAME).load();
        this.forEachSafePointMethod(name -> ctxt.enqueue((ExecutableElement)safePointClass.requireSingleMethod(name)));
    }

    protected void forEachSafePointMethod(Consumer<String> consumer) {
        consumer.accept(ENTER_SAFE_POINT);
        consumer.accept(REQUEST_GLOBAL_SAFE_POINT);
        consumer.accept(CLEAR_GLOBAL_SAFE_POINT);
    }

    public abstract void safePoint(BasicBlockBuilder var1);

    public abstract void implementRequestGlobalSafePoint(BasicBlockBuilder var1);

    public abstract void implementClearGlobalSafePoint(BasicBlockBuilder var1);
}

