/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.gc.common.safepoint;

import java.util.List;
import java.util.Map;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.plugin.gc.common.safepoint.AbstractMethodBasedSafePointStrategy;
import org.qbicc.plugin.patcher.Patcher;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.definition.element.StaticMethodElement;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeSignature;

public final class GlobalFlagSafePointStrategy
extends AbstractMethodBasedSafePointStrategy {
    private static final String REQUEST_SAFE_POINT_FIELD = "requestSafePoint";

    public GlobalFlagSafePointStrategy(CompilationContext ctxt) {
        super(ctxt);
        Patcher patcher = Patcher.get((CompilationContext)ctxt);
        FieldResolver requestSafePointResolver = (index, enclosing, builder) -> {
            builder.setModifiers(0x80000A);
            builder.setEnclosingType(enclosing);
            builder.setSignature(TypeSignature.synthesize((ClassContext)enclosing.getContext(), (TypeDescriptor)builder.getDescriptor()));
            return builder.build();
        };
        patcher.addField(ctxt.getBootstrapClassContext(), "org/qbicc/runtime/main/SafePoint", REQUEST_SAFE_POINT_FIELD, (TypeDescriptor)BaseTypeDescriptor.Z, requestSafePointResolver, 0, 0);
    }

    private StaticFieldElement getField() {
        return this.ctxt.getBootstrapClassContext().findDefinedType("org/qbicc/runtime/main/SafePoint").load().findStaticField(REQUEST_SAFE_POINT_FIELD);
    }

    @Override
    public void implementRequestGlobalSafePoint(BasicBlockBuilder bbb) {
        LiteralFactory lf = bbb.getLiteralFactory();
        bbb.begin(new BlockLabel());
        bbb.store((Value)lf.literalOf(this.getField()), (Value)lf.literalOf(true), AccessModes.SingleRelease);
        bbb.return_();
    }

    @Override
    public void implementClearGlobalSafePoint(BasicBlockBuilder bbb) {
        LiteralFactory lf = bbb.getLiteralFactory();
        bbb.begin(new BlockLabel());
        bbb.store((Value)lf.literalOf(this.getField()), (Value)lf.literalOf(false), AccessModes.SingleRelease);
        bbb.return_();
    }

    @Override
    public void implementPollSafePoint(BasicBlockBuilder bbb) {
        LiteralFactory lf = bbb.getLiteralFactory();
        bbb.begin(new BlockLabel());
        Value flag = bbb.load((Value)lf.literalOf(this.getField()), AccessModes.SingleAcquire);
        BlockLabel enterSafePoint = new BlockLabel();
        BlockLabel resume = new BlockLabel();
        bbb.if_(flag, enterSafePoint, resume, Map.of());
        try {
            bbb.begin(enterSafePoint);
            StaticMethodElement enterSafePointMethod = (StaticMethodElement)bbb.getContext().getBootstrapClassContext().findDefinedType("org/qbicc/runtime/main/SafePoint").load().requireSingleMethod("enterSafePoint");
            bbb.tailCall((Value)bbb.getLiteralFactory().literalOf(enterSafePointMethod), List.of());
        }
        catch (BlockEarlyTermination blockEarlyTermination) {
            // empty catch block
        }
        try {
            bbb.begin(resume);
            bbb.return_();
        }
        catch (BlockEarlyTermination blockEarlyTermination) {
            // empty catch block
        }
    }
}

