/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.gc.common.safepoint;

import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.plugin.gc.common.safepoint.AbstractSafePointStrategy;
import org.qbicc.plugin.gc.common.safepoint.GlobalFlagSafePointStrategy;
import org.qbicc.plugin.gc.common.safepoint.NoSafePointStrategy;

public final class SafePoints {
    private static final AttachmentKey<AbstractSafePointStrategy> IMPL_KEY = new AttachmentKey();

    private SafePoints() {
    }

    public static void selectStrategy(CompilationContext ctxt, Strategy strategy) {
        AbstractSafePointStrategy existing = (AbstractSafePointStrategy)ctxt.putAttachmentIfAbsent(IMPL_KEY, (Object)strategy.create(ctxt));
        if (existing != null) {
            throw new IllegalStateException("Already installed");
        }
    }

    public static void enqueueMethods(CompilationContext ctxt) {
        ((AbstractSafePointStrategy)ctxt.getAttachment(IMPL_KEY)).registerReachableMethods(ctxt);
    }

    public static BasicBlockBuilder createBasicBlockBuilder(BasicBlockBuilder.FactoryContext fc, BasicBlockBuilder delegate) {
        final AbstractSafePointStrategy strategy = (AbstractSafePointStrategy)delegate.getContext().getAttachment(IMPL_KEY);
        return new DelegatingBasicBlockBuilder(delegate){

            public Node safePoint() {
                strategy.safePoint(this.getFirstBuilder());
                return this.nop();
            }
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Strategy {
        NONE{

            @Override
            AbstractSafePointStrategy create(CompilationContext ctxt) {
                return new NoSafePointStrategy(ctxt);
            }
        }
        ,
        GLOBAL_FLAG{

            @Override
            AbstractSafePointStrategy create(CompilationContext ctxt) {
                return new GlobalFlagSafePointStrategy(ctxt);
            }
        };


        abstract AbstractSafePointStrategy create(CompilationContext var1);
    }
}

