/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.gc.nogc;

import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.MethodElement;

public final class NoGc {
    private final CompilationContext ctxt;
    private final MethodElement allocateMethod;
    private final MethodElement copyMethod;
    private final MethodElement zeroMethod;
    private final ClassObjectType stackObjectType;
    private static final AttachmentKey<NoGc> KEY = new AttachmentKey();

    private NoGc(CompilationContext ctxt) {
        this.ctxt = ctxt;
        ClassContext classContext = ctxt.getBootstrapClassContext();
        DefinedTypeDefinition defined = classContext.findDefinedType("org/qbicc/runtime/gc/nogc/NoGcHelpers");
        if (defined == null) {
            throw NoGc.runtimeMissing();
        }
        LoadedTypeDefinition loaded = defined.load();
        int index = loaded.findMethodIndex(e -> e.getName().equals("allocate"));
        if (index == -1) {
            throw NoGc.methodMissing();
        }
        this.allocateMethod = loaded.getMethod(index);
        index = loaded.findMethodIndex(e -> e.getName().equals("copy"));
        if (index == -1) {
            throw NoGc.methodMissing();
        }
        this.copyMethod = loaded.getMethod(index);
        index = loaded.findMethodIndex(e -> e.getName().equals("clear"));
        if (index == -1) {
            throw NoGc.methodMissing();
        }
        this.zeroMethod = loaded.getMethod(index);
        defined = classContext.findDefinedType("org/qbicc/runtime/StackObject");
        if (defined == null) {
            throw NoGc.runtimeMissing();
        }
        loaded = defined.load();
        this.stackObjectType = loaded.getClassType();
    }

    private static IllegalStateException methodMissing() {
        return new IllegalStateException("Required method is missing from the NoGC helpers");
    }

    private static IllegalStateException runtimeMissing() {
        return new IllegalStateException("The NoGC helpers runtime classes are not present in the bootstrap class path");
    }

    public static NoGc get(CompilationContext ctxt) {
        return (NoGc)ctxt.computeAttachmentIfAbsent(KEY, () -> new NoGc(ctxt));
    }

    public MethodElement getAllocateMethod() {
        return this.allocateMethod;
    }

    public MethodElement getCopyMethod() {
        return this.copyMethod;
    }

    public MethodElement getZeroMethod() {
        return this.zeroMethod;
    }

    public ClassObjectType getStackObjectType() {
        return this.stackObjectType;
    }
}

