/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.initializationcontrol;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;

public class InitAtRuntimeRegistry {
    private static final AttachmentKey<InitAtRuntimeRegistry> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final Set<String> runtimeInitializedClasses = ConcurrentHashMap.newKeySet();

    private InitAtRuntimeRegistry(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static InitAtRuntimeRegistry get(CompilationContext ctxt) {
        InitAtRuntimeRegistry appearing;
        InitAtRuntimeRegistry patcher = (InitAtRuntimeRegistry)ctxt.getAttachment(KEY);
        if (patcher == null && (appearing = (InitAtRuntimeRegistry)ctxt.putAttachmentIfAbsent(KEY, (Object)(patcher = new InitAtRuntimeRegistry(ctxt)))) != null) {
            patcher = appearing;
        }
        return patcher;
    }

    public void addRuntimeInitializedClass(String internalName) {
        this.runtimeInitializedClasses.add(internalName);
    }

    public boolean isRuntimeInitializedClass(String internalName) {
        return this.runtimeInitializedClasses.contains(internalName);
    }
}

