/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.intrinsics;

import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMap;
import org.jboss.logging.Logger;
import org.qbicc.context.CompilationContext;
import org.qbicc.driver.Phase;
import org.qbicc.graph.AbstractMethodLookup;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.InstanceMethodLiteral;
import org.qbicc.graph.literal.StaticMethodLiteral;
import org.qbicc.plugin.intrinsics.InstanceIntrinsic;
import org.qbicc.plugin.intrinsics.Intrinsics;
import org.qbicc.plugin.intrinsics.StaticIntrinsic;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.MethodElement;

public final class IntrinsicBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    public static final Logger log = Logger.getLogger((String)"org.qbicc.plugin.intrinsics");
    private final CompilationContext ctxt;
    private final Phase phase;

    private IntrinsicBasicBlockBuilder(BasicBlockBuilder delegate, Phase phase) {
        super(delegate);
        this.phase = phase;
        this.ctxt = this.getContext();
    }

    public static IntrinsicBasicBlockBuilder createForAddPhase(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        return new IntrinsicBasicBlockBuilder(delegate, Phase.ADD);
    }

    public static IntrinsicBasicBlockBuilder createForAnalyzePhase(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        return new IntrinsicBasicBlockBuilder(delegate, Phase.ANALYZE);
    }

    public static IntrinsicBasicBlockBuilder createForLowerPhase(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        return new IntrinsicBasicBlockBuilder(delegate, Phase.LOWER);
    }

    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        if (targetPtr instanceof StaticMethodLiteral) {
            Value result;
            StaticMethodLiteral lit = (StaticMethodLiteral)targetPtr;
            StaticIntrinsic intrinsic = Intrinsics.get(this.ctxt).getStaticIntrinsic(this.phase, (MethodElement)lit.getExecutable());
            if (intrinsic != null && (result = intrinsic.emitIntrinsic(this.getFirstBuilder(), lit, arguments)) != null) {
                return result;
            }
        } else if (targetPtr instanceof InstanceMethodLiteral) {
            Value result;
            InstanceMethodLiteral lit = (InstanceMethodLiteral)targetPtr;
            InstanceIntrinsic intrinsic = Intrinsics.get(this.ctxt).getInstanceIntrinsic(this.phase, (MethodElement)lit.getExecutable());
            if (intrinsic != null && (result = intrinsic.emitIntrinsic(this.getFirstBuilder(), receiver, lit, arguments)) != null) {
                return result;
            }
        } else if (targetPtr instanceof AbstractMethodLookup) {
            Value result;
            AbstractMethodLookup lookup = (AbstractMethodLookup)targetPtr;
            InstanceMethodElement method = lookup.getMethod();
            InstanceIntrinsic intrinsic = Intrinsics.get(this.ctxt).getInstanceIntrinsic(this.phase, (MethodElement)method);
            if (intrinsic != null && (result = intrinsic.emitIntrinsic(this.getFirstBuilder(), receiver, this.getLiteralFactory().literalOf(method), arguments)) != null) {
                return result;
            }
        }
        return super.call(targetPtr, receiver, arguments);
    }

    public Value callNoSideEffects(Value targetPtr, Value receiver, List<Value> arguments) {
        if (targetPtr instanceof StaticMethodLiteral) {
            Value result;
            StaticMethodLiteral lit = (StaticMethodLiteral)targetPtr;
            StaticIntrinsic intrinsic = Intrinsics.get(this.ctxt).getStaticIntrinsic(this.phase, (MethodElement)lit.getExecutable());
            if (intrinsic != null && (result = intrinsic.emitIntrinsic(this.getFirstBuilder(), lit, arguments)) != null) {
                return result;
            }
        } else if (targetPtr instanceof InstanceMethodLiteral) {
            Value result;
            InstanceMethodLiteral lit = (InstanceMethodLiteral)targetPtr;
            InstanceIntrinsic intrinsic = Intrinsics.get(this.ctxt).getInstanceIntrinsic(this.phase, (MethodElement)lit.getExecutable());
            if (intrinsic != null && (result = intrinsic.emitIntrinsic(this.getFirstBuilder(), receiver, lit, arguments)) != null) {
                return result;
            }
        }
        return super.callNoSideEffects(targetPtr, receiver, arguments);
    }

    public BasicBlock callNoReturn(Value targetPtr, Value receiver, List<Value> arguments) {
        if (targetPtr instanceof StaticMethodLiteral) {
            StaticMethodLiteral lit = (StaticMethodLiteral)targetPtr;
            StaticIntrinsic intrinsic = Intrinsics.get(this.ctxt).getStaticIntrinsic(this.phase, (MethodElement)lit.getExecutable());
            if (intrinsic != null) {
                intrinsic.emitIntrinsic(this.getFirstBuilder(), lit, arguments);
                return this.unreachable();
            }
        } else if (targetPtr instanceof InstanceMethodLiteral) {
            InstanceMethodLiteral lit = (InstanceMethodLiteral)targetPtr;
            InstanceIntrinsic intrinsic = Intrinsics.get(this.ctxt).getInstanceIntrinsic(this.phase, (MethodElement)lit.getExecutable());
            if (intrinsic != null) {
                intrinsic.emitIntrinsic(this.getFirstBuilder(), receiver, lit, arguments);
                return this.unreachable();
            }
        }
        return super.callNoReturn(targetPtr, receiver, arguments);
    }

    public BasicBlock invokeNoReturn(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        if (targetPtr instanceof StaticMethodLiteral) {
            StaticMethodLiteral lit = (StaticMethodLiteral)targetPtr;
            StaticIntrinsic intrinsic = Intrinsics.get(this.ctxt).getStaticIntrinsic(this.phase, (MethodElement)lit.getExecutable());
            if (intrinsic != null) {
                intrinsic.emitIntrinsic(this.getFirstBuilder(), lit, arguments);
                return this.unreachable();
            }
        } else if (targetPtr instanceof InstanceMethodLiteral) {
            InstanceMethodLiteral lit = (InstanceMethodLiteral)targetPtr;
            InstanceIntrinsic intrinsic = Intrinsics.get(this.ctxt).getInstanceIntrinsic(this.phase, (MethodElement)lit.getExecutable());
            if (intrinsic != null) {
                intrinsic.emitIntrinsic(this.getFirstBuilder(), receiver, lit, arguments);
                return this.unreachable();
            }
        }
        return super.invokeNoReturn(targetPtr, receiver, arguments, catchLabel, targetArguments);
    }

    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        if (targetPtr instanceof StaticMethodLiteral) {
            Value result;
            StaticMethodLiteral lit = (StaticMethodLiteral)targetPtr;
            StaticIntrinsic intrinsic = Intrinsics.get(this.ctxt).getStaticIntrinsic(this.phase, (MethodElement)lit.getExecutable());
            if (intrinsic != null && (result = intrinsic.emitIntrinsic(this.getFirstBuilder(), lit, arguments)) != null) {
                return this.return_(result);
            }
        } else if (targetPtr instanceof InstanceMethodLiteral) {
            Value result;
            InstanceMethodLiteral lit = (InstanceMethodLiteral)targetPtr;
            InstanceIntrinsic intrinsic = Intrinsics.get(this.ctxt).getInstanceIntrinsic(this.phase, (MethodElement)lit.getExecutable());
            if (intrinsic != null && (result = intrinsic.emitIntrinsic(this.getFirstBuilder(), receiver, lit, arguments)) != null) {
                return this.return_(result);
            }
        }
        return super.tailCall(targetPtr, receiver, arguments);
    }

    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        if (targetPtr instanceof StaticMethodLiteral) {
            Value result;
            StaticMethodLiteral lit = (StaticMethodLiteral)targetPtr;
            StaticIntrinsic intrinsic = Intrinsics.get(this.ctxt).getStaticIntrinsic(this.phase, (MethodElement)lit.getExecutable());
            if (intrinsic != null && (result = intrinsic.emitIntrinsic(this.getFirstBuilder(), lit, arguments)) != null) {
                ImmutableMap immutableMap = Maps.immutable.ofMap(targetArguments);
                this.goto_(resumeLabel, immutableMap.newWithKeyValue((Object)Slot.result(), (Object)result).castToMap());
                return result;
            }
        } else if (targetPtr instanceof InstanceMethodLiteral) {
            Value result;
            InstanceMethodLiteral lit = (InstanceMethodLiteral)targetPtr;
            InstanceIntrinsic intrinsic = Intrinsics.get(this.ctxt).getInstanceIntrinsic(this.phase, (MethodElement)lit.getExecutable());
            if (intrinsic != null && (result = intrinsic.emitIntrinsic(this.getFirstBuilder(), receiver, lit, arguments)) != null) {
                ImmutableMap immutableMap = Maps.immutable.ofMap(targetArguments);
                this.goto_(resumeLabel, immutableMap.newWithKeyValue((Object)Slot.result(), (Object)result).castToMap());
                return result;
            }
        }
        return super.invoke(targetPtr, receiver, arguments, catchLabel, resumeLabel, targetArguments);
    }
}

