/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.intrinsics.core;

import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.driver.Phase;
import org.qbicc.machine.arch.ArmCpu;
import org.qbicc.machine.arch.Cpu;
import org.qbicc.machine.arch.OS;
import org.qbicc.machine.arch.ObjectType;
import org.qbicc.machine.arch.Platform;
import org.qbicc.plugin.intrinsics.Intrinsics;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

final class BuildIntrinsics {
    BuildIntrinsics() {
    }

    public static void register(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        BuildIntrinsics.registerTopLevelIntrinsics(intrinsics, ctxt);
        BuildIntrinsics.registerHostIntrinsics(intrinsics, ctxt);
        BuildIntrinsics.registerTargetIntrinsics(intrinsics, ctxt);
    }

    private static void registerTopLevelIntrinsics(Intrinsics intrinsics, CompilationContext ctxt) {
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor buildDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/Build");
        MethodDescriptor emptyToBool = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of());
        intrinsics.registerIntrinsic(Phase.ANALYZE, (TypeDescriptor)buildDesc, "isHost", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(false));
        intrinsics.registerIntrinsic(Phase.ANALYZE, (TypeDescriptor)buildDesc, "isTarget", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(true));
        intrinsics.registerIntrinsic((TypeDescriptor)buildDesc, "isJvm", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(false));
    }

    private static void registerHostIntrinsics(Intrinsics intrinsics, CompilationContext ctxt) {
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor hostDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/Build$Host");
        MethodDescriptor emptyToBool = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of());
        OS os = Platform.HOST_PLATFORM.getOs();
        intrinsics.registerIntrinsic((TypeDescriptor)hostDesc, "isLinux", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(os == OS.LINUX));
        intrinsics.registerIntrinsic((TypeDescriptor)hostDesc, "isWindows", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(os == OS.WIN32));
        intrinsics.registerIntrinsic((TypeDescriptor)hostDesc, "isMacOs", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(os == OS.DARWIN));
        Cpu cpu = Platform.HOST_PLATFORM.getCpu();
        intrinsics.registerIntrinsic((TypeDescriptor)hostDesc, "isAmd64", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(cpu == Cpu.X86_64));
        intrinsics.registerIntrinsic((TypeDescriptor)hostDesc, "isI386", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(cpu == Cpu.X86));
        intrinsics.registerIntrinsic((TypeDescriptor)hostDesc, "isArm", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(cpu instanceof ArmCpu));
        intrinsics.registerIntrinsic((TypeDescriptor)hostDesc, "isAarch64", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(cpu == Cpu.AARCH64));
    }

    private static void registerTargetIntrinsics(Intrinsics intrinsics, CompilationContext ctxt) {
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor targetDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/Build$Target");
        MethodDescriptor emptyToBool = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of());
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isVirtual", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(true));
        OS os = ctxt.getPlatform().getOs();
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isUnix", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(os == OS.LINUX || os == OS.DARWIN));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isLinux", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(os == OS.LINUX));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isWindows", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(os == OS.WIN32));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isApple", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(os == OS.DARWIN));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isMacOs", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(os == OS.DARWIN));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isIOS", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(false));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isAix", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(false));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isPosix", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(os == OS.LINUX || os == OS.DARWIN));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isWasi", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(os == OS.WASI));
        Cpu cpu = ctxt.getPlatform().getCpu();
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isAmd64", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(cpu == Cpu.X86_64));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isI386", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(cpu == Cpu.X86));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isArm", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(cpu instanceof ArmCpu));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isAarch64", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(cpu == Cpu.AARCH64));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isWasm", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(cpu == Cpu.WASM32));
        ObjectType objectType = ctxt.getPlatform().getObjectType();
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isElf", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(objectType == ObjectType.ELF));
        intrinsics.registerIntrinsic((TypeDescriptor)targetDesc, "isMachO", emptyToBool, (builder, targetPtr, arguments) -> builder.getLiteralFactory().literalOf(objectType == ObjectType.MACH_O));
    }
}

