/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.intrinsics.core;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BitCast;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.ClassOf;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.Dereference;
import org.qbicc.graph.Extend;
import org.qbicc.graph.Load;
import org.qbicc.graph.MemberOf;
import org.qbicc.graph.MemberOfUnion;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Truncate;
import org.qbicc.graph.Value;
import org.qbicc.graph.WordCastValue;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.GlobalReadWriteAccessMode;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.InstanceMethodLiteral;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.graph.literal.ProgramObjectLiteral;
import org.qbicc.graph.literal.StringLiteral;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.graph.literal.UndefinedLiteral;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmString;
import org.qbicc.object.Data;
import org.qbicc.object.ModuleSection;
import org.qbicc.object.ProgramObject;
import org.qbicc.plugin.apploader.AppClassLoader;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.intrinsics.InstanceIntrinsic;
import org.qbicc.plugin.intrinsics.Intrinsics;
import org.qbicc.plugin.intrinsics.StaticIntrinsic;
import org.qbicc.type.BooleanType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.FloatType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.NullableType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.TypeType;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

final class CNativeIntrinsics {
    CNativeIntrinsics() {
    }

    public static void register(CompilationContext ctxt) {
        CNativeIntrinsics.registerTopLevelIntrinsics(ctxt);
        CNativeIntrinsics.registerNObjectIntrinsics(ctxt);
        CNativeIntrinsics.registerWordIntrinsics(ctxt);
        CNativeIntrinsics.registerPtrIntrinsics(ctxt);
    }

    private static void registerTopLevelIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor cNativeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative");
        ClassTypeDescriptor typeIdDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$type_id");
        ClassTypeDescriptor referenceDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$reference");
        ClassTypeDescriptor objDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
        ArrayTypeDescriptor objArrayDesc = ArrayTypeDescriptor.of((ClassContext)classContext, (TypeDescriptor)objDesc);
        ClassTypeDescriptor nObjDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$object");
        ClassTypeDescriptor ptrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$ptr");
        ClassTypeDescriptor functionDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$function");
        ClassTypeDescriptor constCharPtrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$const_char_ptr");
        ClassTypeDescriptor wordDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$word");
        ClassTypeDescriptor tgDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/ThreadGroup");
        ClassTypeDescriptor thrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Thread");
        ClassTypeDescriptor strDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/String");
        ClassTypeDescriptor classDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Class");
        ClassTypeDescriptor boolPtrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$_Bool_ptr");
        ClassTypeDescriptor float32ptrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$_Float32_ptr");
        ClassTypeDescriptor float64ptrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$_Float64_ptr");
        ClassTypeDescriptor uint16ptrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/stdc/Stdint$uint16_t_ptr");
        ClassTypeDescriptor int8ptrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/stdc/Stdint$int8_t_ptr");
        ClassTypeDescriptor int16ptrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/stdc/Stdint$int16_t_ptr");
        ClassTypeDescriptor int32ptrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/stdc/Stdint$int32_t_ptr");
        ClassTypeDescriptor int64ptrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/stdc/Stdint$int64_t_ptr");
        ClassTypeDescriptor sizeTDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/stdc/Stddef$size_t");
        MethodDescriptor objTypeIdDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)typeIdDesc, List.of(objDesc));
        MethodDescriptor objArrayTypeIdDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)typeIdDesc, List.of(objArrayDesc));
        MethodDescriptor objToReference = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)referenceDesc, List.of(objDesc));
        MethodDescriptor wordToReference = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)referenceDesc, List.of(wordDesc));
        MethodDescriptor toObject = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of());
        MethodDescriptor objToFunction = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)functionDesc, List.of(objDesc));
        intrinsics.registerIntrinsic((TypeDescriptor)referenceDesc, "of", objToReference, (builder, targetPtr, arguments) -> (Value)arguments.get(0));
        intrinsics.registerIntrinsic((TypeDescriptor)referenceDesc, "fromWord", wordToReference, (builder, targetPtr, arguments) -> {
            Value wordVal = (Value)arguments.get(0);
            WordType wordType = (WordType)wordVal.getType(WordType.class);
            TypeSystem ts = builder.getTypeSystem();
            ClassObjectType object = (ClassObjectType)builder.getContext().getBootstrapClassContext().resolveTypeFromClassName("java/lang", "Object");
            int refBits = ts.getReferenceSize() * 8;
            if (wordType instanceof IntegerType) {
                IntegerType it = (IntegerType)wordType;
                if (wordType.getMinBits() > refBits) {
                    wordVal = builder.truncate(wordVal, (WordType)it.asSized(refBits));
                }
            } else {
                ctxt.error(builder.getLocation(), "Only integers can currently be converted to references", new Object[0]);
                return builder.getLiteralFactory().nullLiteralOfType((NullableType)object.getReference());
            }
            return builder.bitCast(wordVal, (WordType)object.getReference());
        });
        intrinsics.registerIntrinsic((TypeDescriptor)referenceDesc, "toObject", toObject, (builder, instance, targetPtr, arguments) -> instance);
        intrinsics.registerIntrinsic((TypeDescriptor)functionDesc, "of", objToFunction, (builder, targetPtr, arguments) -> {
            Dereference d;
            Value value = (Value)arguments.get(0);
            if (value instanceof Dereference && (d = (Dereference)value).getType() instanceof FunctionType) {
                return value;
            }
            builder.getContext().error(builder.getLocation(), "Invalid argument to `function.of()`; expected a dereferenced function pointer but got %s", new Object[]{value});
            throw new BlockEarlyTermination(builder.unreachable());
        });
        intrinsics.registerIntrinsic((TypeDescriptor)functionDesc, "toInvokable", toObject, (builder, instance, targetPtr, arguments) -> instance);
        StaticIntrinsic typeOf = (builder, target, arguments) -> builder.loadTypeId((Value)arguments.get(0));
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "typeIdOf", objTypeIdDesc, typeOf);
        InstanceFieldElement elementTypeField = CoreClasses.get((CompilationContext)ctxt).getRefArrayElementTypeIdField();
        StaticIntrinsic elementTypeOf = (builder, target, arguments) -> builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), elementTypeField));
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "elementTypeIdOf", objArrayTypeIdDesc, elementTypeOf);
        StaticIntrinsic addrOf = (builder, target, arguments) -> {
            Value value = (Value)arguments.get(0);
            if (value instanceof Dereference) {
                Dereference deref = (Dereference)value;
                return deref.getPointer();
            }
            while (value instanceof BitCast || value instanceof Extend || value instanceof Truncate) {
                value = ((WordCastValue)value).getInput();
            }
            if (value instanceof Load) {
                Load load = (Load)value;
                return load.getPointer();
            }
            ctxt.error(builder.getLocation(), "Cannot take address of value", new Object[0]);
            return ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)value.getType().getPointer());
        };
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "addr_of", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)int8ptrDesc, List.of(BaseTypeDescriptor.B)), addrOf);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "addr_of", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)uint16ptrDesc, List.of(BaseTypeDescriptor.C)), addrOf);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "addr_of", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)float64ptrDesc, List.of(BaseTypeDescriptor.D)), addrOf);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "addr_of", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)float32ptrDesc, List.of(BaseTypeDescriptor.F)), addrOf);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "addr_of", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)int32ptrDesc, List.of(BaseTypeDescriptor.I)), addrOf);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "addr_of", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)int64ptrDesc, List.of(BaseTypeDescriptor.J)), addrOf);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "addr_of", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)int16ptrDesc, List.of(BaseTypeDescriptor.S)), addrOf);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "addr_of", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)boolPtrDesc, List.of(BaseTypeDescriptor.Z)), addrOf);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "addr_of", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ptrDesc, List.of(nObjDesc)), addrOf);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "addr_of", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ptrDesc, List.of(objDesc)), addrOf);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "addr_of", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ptrDesc, List.of(nObjDesc)), addrOf);
        StaticIntrinsic refToPtr = (builder, target, arguments) -> {
            Value value = (Value)arguments.get(0);
            if (value.getType() instanceof ReferenceType) {
                return builder.decodeReference(value);
            }
            ctxt.error(builder.getLocation(), "Cannot convert non-reference to pointer", new Object[0]);
            return ctxt.getLiteralFactory().nullLiteralOfType((NullableType)ctxt.getTypeSystem().getVoidType().getPointer());
        };
        StaticIntrinsic deref1 = (builder, target, arguments) -> builder.deref((Value)arguments.get(0));
        StaticIntrinsic deref2 = (builder, target, arguments) -> {
            ClassOf classOf;
            Value patt12408$temp;
            Object patt12359$temp = arguments.get(1);
            if (patt12359$temp instanceof ClassOf && (patt12408$temp = (classOf = (ClassOf)patt12359$temp).getInput()) instanceof TypeLiteral) {
                TypeLiteral typeLiteral = (TypeLiteral)patt12408$temp;
                PointerType pt = typeLiteral.getValue().getPointer();
                return builder.deref(builder.bitCast((Value)arguments.get(0), (WordType)pt));
            }
            ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
            return builder.emptyVoid();
        };
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "deref", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of(ptrDesc)), deref1);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "deref", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of(ptrDesc, classDesc)), deref2);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "refToPtr", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ptrDesc, List.of(objDesc)), refToPtr);
        StaticIntrinsic ptrToRef = (builder, target, arguments) -> {
            Value value = (Value)arguments.get(0);
            ValueType patt13356$temp = value.getType();
            if (patt13356$temp instanceof PointerType) {
                PointerType pt = (PointerType)patt13356$temp;
                ValueType patt13425$temp = pt.getPointeeType();
                if (patt13425$temp instanceof ObjectType) {
                    ObjectType ot = (ObjectType)patt13425$temp;
                    return builder.valueConvert(value, (WordType)ot.getReference());
                }
                ReferenceType objRef = ctxt.getBootstrapClassContext().findDefinedType("java/lang/Object").load().getObjectType().getReference();
                return builder.valueConvert(value, (WordType)objRef);
            }
            ctxt.error(builder.getLocation(), "Cannot convert non-pointer to reference", new Object[0]);
            throw new BlockEarlyTermination(builder.unreachable());
        };
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "ptrToRef", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of(ptrDesc)), ptrToRef);
        StaticIntrinsic attachNewThread = (builder, target, arguments) -> {
            Value thread = builder.new_(thrDesc);
            builder.store(builder.currentThread(), thread, (WriteAccessMode)AccessModes.SingleUnshared);
            DefinedTypeDefinition jlt = classContext.findDefinedType("java/lang/Thread");
            LoadedTypeDefinition jltVal = jlt.load();
            InstanceFieldElement nameFld = jltVal.findInstanceField("name");
            InstanceFieldElement tidFld = jltVal.findInstanceField("tid");
            InstanceFieldElement groupFld = jltVal.findInstanceField("group");
            InstanceFieldElement threadStatusFld = jltVal.findInstanceField("threadStatus");
            InstanceFieldElement priorityFld = jltVal.findInstanceField("priority");
            InstanceFieldElement contextClassLoaderFld = jltVal.findInstanceField("contextClassLoader");
            LiteralFactory lf = ctxt.getLiteralFactory();
            Value threadRef = builder.decodeReference(thread);
            builder.store(builder.instanceFieldOf(threadRef, nameFld), (Value)arguments.get(0), (WriteAccessMode)AccessModes.SingleUnshared);
            builder.store(builder.instanceFieldOf(threadRef, groupFld), (Value)arguments.get(1), (WriteAccessMode)AccessModes.SingleUnshared);
            Value tid = builder.call(builder.resolveStaticMethod((TypeDescriptor)thrDesc, "nextThreadID", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, List.of())), List.of());
            builder.store(builder.instanceFieldOf(threadRef, tidFld), tid, (WriteAccessMode)AccessModes.SingleUnshared);
            Value normPriority = builder.load((Value)lf.literalOf(jltVal.findStaticField("NORM_PRIORITY")), (ReadAccessMode)AccessModes.SingleUnshared);
            builder.store(builder.instanceFieldOf(threadRef, priorityFld), normPriority, (WriteAccessMode)AccessModes.SingleUnshared);
            builder.store(builder.instanceFieldOf(threadRef, threadStatusFld), (Value)lf.literalOf(5), (WriteAccessMode)AccessModes.SingleUnshared);
            VmClassLoader appCl = AppClassLoader.get((CompilationContext)ctxt).getAppClassLoader();
            builder.store(builder.instanceFieldOf(threadRef, contextClassLoaderFld), (Value)lf.literalOf((VmObject)appCl));
            return lf.zeroInitializerLiteralOfType((ValueType)ctxt.getTypeSystem().getVoidType());
        };
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "attachNewThread", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(strDesc, tgDesc)), attachNewThread);
        StaticIntrinsic identityStatic = (builder, target, arguments) -> (Value)arguments.get(0);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "word", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)wordDesc, List.of(BaseTypeDescriptor.Z)), identityStatic);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "word", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)wordDesc, List.of(BaseTypeDescriptor.I)), identityStatic);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "word", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)wordDesc, List.of(BaseTypeDescriptor.J)), identityStatic);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "word", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)wordDesc, List.of(BaseTypeDescriptor.F)), identityStatic);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "word", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)wordDesc, List.of(BaseTypeDescriptor.D)), identityStatic);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "word", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)wordDesc, List.of(BaseTypeDescriptor.Z)), identityStatic);
        StaticIntrinsic toUnsigned = (builder, target, arguments) -> builder.bitCast((Value)arguments.get(0), (WordType)((IntegerType)((Value)arguments.get(0)).getType()).asUnsigned());
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "uword", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)wordDesc, List.of(BaseTypeDescriptor.I)), toUnsigned);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "uword", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)wordDesc, List.of(BaseTypeDescriptor.J)), toUnsigned);
        MethodDescriptor wordWordToWord = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)wordDesc, List.of(wordDesc, wordDesc));
        MethodDescriptor wordToWord = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)wordDesc, List.of(wordDesc));
        StaticIntrinsic wordAnd = (builder, target, arguments) -> builder.and((Value)arguments.get(0), (Value)arguments.get(1));
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "wordAnd", wordWordToWord, wordAnd);
        StaticIntrinsic wordOr = (builder, target, arguments) -> builder.or((Value)arguments.get(0), (Value)arguments.get(1));
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "wordOr", wordWordToWord, wordOr);
        StaticIntrinsic wordXor = (builder, target, arguments) -> builder.xor((Value)arguments.get(0), (Value)arguments.get(1));
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "wordXor", wordWordToWord, wordXor);
        StaticIntrinsic wordComp = (builder, target, arguments) -> builder.complement((Value)arguments.get(0));
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "wordComp", wordToWord, wordComp);
        StaticIntrinsic sizeof = (builder, target, arguments) -> {
            long size = ((Value)arguments.get(0)).getType().getSize();
            IntegerType returnType = (IntegerType)target.getReturnType();
            return ctxt.getLiteralFactory().literalOf(returnType, size);
        };
        StaticIntrinsic sizeofClass = (builder, target, arguments) -> {
            long size;
            TypeLiteral input;
            ClassOf co;
            Value patt20064$temp;
            Value arg = (Value)arguments.get(0);
            if (arg instanceof ClassOf && (patt20064$temp = (co = (ClassOf)arg).getInput()) instanceof TypeLiteral && !((input = (TypeLiteral)patt20064$temp).getValue() instanceof ObjectType)) {
                size = input.getValue().getSize();
            } else {
                ctxt.error(builder.getLocation(), "unexpected type for sizeof(Class)", new Object[0]);
                size = arg.getType().getSize();
            }
            IntegerType returnType = (IntegerType)target.getReturnType();
            return ctxt.getLiteralFactory().literalOf(returnType, size);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "sizeof", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)sizeTDesc, List.of(nObjDesc)), sizeof);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "sizeof", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)sizeTDesc, List.of(ArrayTypeDescriptor.of((ClassContext)classContext, (TypeDescriptor)nObjDesc))), sizeof);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "sizeof", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)sizeTDesc, List.of(classDesc)), sizeofClass);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "sizeofArray", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)sizeTDesc, List.of(ArrayTypeDescriptor.of((ClassContext)classContext, (TypeDescriptor)classDesc))), sizeofClass);
        StaticIntrinsic alignof = (builder, target, arguments) -> {
            ValueType argType = ((Value)arguments.get(0)).getType();
            long align = argType instanceof TypeType ? (long)((TypeType)argType).getUpperBound().getAlign() : (long)argType.getAlign();
            IntegerType returnType = (IntegerType)target.getReturnType();
            return ctxt.getLiteralFactory().literalOf(returnType, align);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "alignof", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)sizeTDesc, List.of(nObjDesc)), alignof);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "alignof", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)sizeTDesc, List.of(classDesc)), alignof);
        StaticIntrinsic offsetof = (builder, target, arguments) -> {
            Value objExpr = (Value)arguments.get(0);
            long offset = 0L;
            if (objExpr instanceof Dereference) {
                Dereference deref = (Dereference)objExpr;
                Value patt22226$temp = deref.getPointer();
                if (patt22226$temp instanceof MemberOf) {
                    MemberOf memberOf = (MemberOf)patt22226$temp;
                    offset = memberOf.getMember().getOffset();
                } else if (deref.getPointer() instanceof MemberOfUnion) {
                    ctxt.warning(builder.getLocation(), "offset of union member is always zero", new Object[0]);
                } else {
                    ctxt.error(builder.getLocation(), "unexpected argument expression for offsetof(obj.field)", new Object[0]);
                }
            } else {
                ctxt.error(builder.getLocation(), "unexpected argument expression for offsetof(obj.field)", new Object[0]);
            }
            IntegerType returnType = (IntegerType)target.getReturnType();
            return ctxt.getLiteralFactory().literalOf(returnType, offset);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "offsetof", offsetof);
        StaticIntrinsic defined = (builder, target, arguments) -> ctxt.getLiteralFactory().literalOf(!(arguments.get(0) instanceof UndefinedLiteral));
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "defined", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(nObjDesc)), defined);
        StaticIntrinsic isComplete = (builder, target, arguments) -> ctxt.getLiteralFactory().literalOf(((Value)arguments.get(0)).getType().isComplete());
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "isComplete", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(nObjDesc)), isComplete);
        StaticIntrinsic isSigned = (builder, target, arguments) -> ctxt.getLiteralFactory().literalOf(((Value)arguments.get(0)).getType() instanceof SignedIntegerType);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "isSigned", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(nObjDesc)), isSigned);
        StaticIntrinsic isUnsigned = (builder, target, arguments) -> ctxt.getLiteralFactory().literalOf(((Value)arguments.get(0)).getType() instanceof UnsignedIntegerType);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "isUnsigned", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(nObjDesc)), isUnsigned);
        StaticIntrinsic typesAreEquivalent = (builder, target, arguments) -> ctxt.getLiteralFactory().literalOf(((Value)arguments.get(0)).getType().equals(((Value)arguments.get(1)).getType()));
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "typesAreEquivalent", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, Collections.nCopies(2, nObjDesc)), typesAreEquivalent);
        StaticIntrinsic zero = (builder, target, arguments) -> ctxt.getLiteralFactory().literalOf(0);
        StaticIntrinsic auto = (builder, target, arguments) -> builder.auto((Value)ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)ctxt.getTypeSystem().getVoidType()));
        StaticIntrinsic autoInit = (builder, target, arguments) -> builder.auto((Value)arguments.get(0));
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "zero", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)nObjDesc, List.of()), zero);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "auto", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)nObjDesc, List.of()), auto);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "auto", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)nObjDesc, List.of(nObjDesc)), autoInit);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "auto", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.B, List.of(BaseTypeDescriptor.B)), autoInit);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "auto", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.C, List.of(BaseTypeDescriptor.C)), autoInit);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "auto", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.D, List.of(BaseTypeDescriptor.D)), autoInit);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "auto", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.F, List.of(BaseTypeDescriptor.F)), autoInit);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "auto", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(BaseTypeDescriptor.I)), autoInit);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "auto", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, List.of(BaseTypeDescriptor.J)), autoInit);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "auto", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.S, List.of(BaseTypeDescriptor.S)), autoInit);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "auto", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(BaseTypeDescriptor.Z)), autoInit);
        StaticIntrinsic constant = (builder, target, arguments) -> ctxt.getLiteralFactory().constantLiteralOfType((ValueType)ctxt.getTypeSystem().getPoisonType());
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "constant", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)nObjDesc, List.of()), constant);
        ConcurrentHashMap utf8zCache = new ConcurrentHashMap();
        AtomicInteger cnt = new AtomicInteger();
        StaticIntrinsic utf8z = (builder, target, arguments) -> {
            String content;
            LiteralFactory lf = ctxt.getLiteralFactory();
            TypeSystem ts = ctxt.getTypeSystem();
            PointerType returnType = (PointerType)target.getReturnType();
            Object patt27608$temp = arguments.get(0);
            if (patt27608$temp instanceof StringLiteral) {
                StringLiteral sl = (StringLiteral)patt27608$temp;
                content = sl.getValue();
            } else {
                ObjectLiteral ol;
                VmObject patt27765$temp;
                Object patt27720$temp = arguments.get(0);
                if (patt27720$temp instanceof ObjectLiteral && (patt27765$temp = (ol = (ObjectLiteral)patt27720$temp).getValue()) instanceof VmString) {
                    VmString vs = (VmString)patt27765$temp;
                    content = vs.getContent();
                } else {
                    ctxt.error(builder.getLocation(), "Argument to CNative.utf8z() must be a string literal", new Object[0]);
                    return lf.nullLiteralOfType((NullableType)returnType);
                }
            }
            byte[] bytes = ((String)(content.endsWith("\u0000") ? content : content + "\u0000")).getBytes(StandardCharsets.UTF_8);
            assert (bytes[bytes.length - 1] == 0);
            Literal literal = lf.literalOf(ts.getArrayType((ValueType)ts.getNativeCharType(), (long)bytes.length), bytes);
            Data data = utf8zCache.computeIfAbsent(literal, bal -> {
                ExecutableElement currentElement = builder.getCurrentElement();
                ModuleSection section = ctxt.getImplicitSection(currentElement);
                return section.addData(null, "utf8z_" + cnt.incrementAndGet(), (Value)bal);
            });
            IntegerLiteral z = lf.literalOf(0);
            ProgramObjectLiteral global = lf.literalOf((ProgramObject)ctxt.getOrAddProgramModule(builder.getCurrentElement().getEnclosingType()).declareData(data));
            return builder.elementOf((Value)global, (Value)z);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "utf8z", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)constCharPtrDesc, List.of(strDesc)), utf8z);
        StaticIntrinsic alloca = (builder, target, arguments) -> builder.stackAllocate((ValueType)ctxt.getTypeSystem().getUnsignedInteger8Type(), (Value)arguments.get(0), (Value)ctxt.getLiteralFactory().literalOf(1));
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "alloca", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ptrDesc, List.of(sizeTDesc)), alloca);
        StaticIntrinsic cast = (builder, targetPtr, arguments) -> (Value)arguments.get(0);
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "cast", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of(objDesc)), cast);
    }

    private static void registerNObjectIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor nObjDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$object");
        ClassTypeDescriptor classDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Class");
        InstanceIntrinsic castToType = (builder, input, target, arguments) -> {
            Value typeLit;
            Value arg0 = (Value)arguments.get(0);
            if (arg0 instanceof ClassOf && (typeLit = ((ClassOf)arg0).getInput()) instanceof TypeLiteral) {
                ValueType toType = ((TypeLiteral)typeLit).getValue();
                if (toType instanceof WordType) {
                    return CNativeIntrinsics.smartConvert(builder, input, (WordType)toType, false);
                }
                return input;
            }
            ctxt.error(builder.getLocation(), "Expected class literal as argument to cast", new Object[0]);
            return input;
        };
        InstanceIntrinsic identity = (builder, instance, target, arguments) -> instance;
        intrinsics.registerIntrinsic((TypeDescriptor)nObjDesc, "cast", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)nObjDesc, List.of()), identity);
        intrinsics.registerIntrinsic((TypeDescriptor)nObjDesc, "cast", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)nObjDesc, List.of(classDesc)), castToType);
    }

    private static void registerWordIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor wordDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$word");
        InstanceIntrinsic xxxValue = (builder, instance, target, arguments) -> {
            WordType to = (WordType)target.getReturnType();
            return CNativeIntrinsics.smartConvert(builder, instance, to, true);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "byteValue", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.B, List.of()), xxxValue);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "booleanValue", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of()), xxxValue);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "charValue", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.C, List.of()), xxxValue);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "doubleValue", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.D, List.of()), xxxValue);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "floatValue", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.F, List.of()), xxxValue);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "intValue", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of()), xxxValue);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "longValue", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, List.of()), xxxValue);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "shortValue", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.S, List.of()), xxxValue);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "ubyteValue", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of()), (builder, instance, target, arguments) -> {
            WordType to = (WordType)target.getReturnType();
            return builder.extend(CNativeIntrinsics.smartConvert(builder, instance, (WordType)ctxt.getTypeSystem().getUnsignedInteger8Type(), true), to);
        });
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "ushortValue", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of()), (builder, instance, target, arguments) -> {
            WordType to = (WordType)target.getReturnType();
            return builder.extend(CNativeIntrinsics.smartConvert(builder, instance, (WordType)ctxt.getTypeSystem().getUnsignedInteger16Type(), true), to);
        });
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "uintValue", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, List.of()), (builder, instance, target, arguments) -> {
            WordType to = (WordType)target.getReturnType();
            return builder.extend(CNativeIntrinsics.smartConvert(builder, instance, (WordType)ctxt.getTypeSystem().getUnsignedInteger32Type(), true), to);
        });
        InstanceIntrinsic isZero = (builder, instance, target, arguments) -> builder.isEq(instance, (Value)ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType()));
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "isZero", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of()), isZero);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "isNull", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of()), isZero);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "isFalse", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of()), isZero);
        InstanceIntrinsic isNonZero = (builder, instance, target, arguments) -> builder.isNe(instance, (Value)ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType()));
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "isNonZero", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of()), isNonZero);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "isNonNull", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of()), isNonZero);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "isTrue", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of()), isNonZero);
        InstanceIntrinsic isLt = (builder, instance, target, arguments) -> builder.isLt(instance, (Value)arguments.get(0));
        InstanceIntrinsic isGt = (builder, instance, target, arguments) -> builder.isGt(instance, (Value)arguments.get(0));
        InstanceIntrinsic isLe = (builder, instance, target, arguments) -> builder.isLe(instance, (Value)arguments.get(0));
        InstanceIntrinsic isGe = (builder, instance, target, arguments) -> builder.isGe(instance, (Value)arguments.get(0));
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "isLt", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(wordDesc)), isLt);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "isGt", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(wordDesc)), isGt);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "isLe", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(wordDesc)), isLe);
        intrinsics.registerIntrinsic((TypeDescriptor)wordDesc, "isGe", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(wordDesc)), isGe);
    }

    private static void registerPtrIntrinsics(CompilationContext ctxt) {
        InstanceIntrinsic opWithType;
        InstanceIntrinsic op;
        InstanceIntrinsic casWithType;
        InstanceIntrinsic cas;
        WriteAccessMode writeMode;
        ReadAccessMode readMode;
        ReadAccessMode mode;
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor objDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
        ClassTypeDescriptor classDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Class");
        ClassTypeDescriptor ptrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$ptr");
        ClassTypeDescriptor ptrDiffTDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/stdc/Stddef$ptrdiff_t");
        ClassTypeDescriptor sizeTDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/stdc/Stddef$size_t");
        MethodDescriptor emptyToObjDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of());
        MethodDescriptor classToObjDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of(classDesc));
        MethodDescriptor objToVoidDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(objDesc));
        MethodDescriptor classObjToVoidDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(classDesc, objDesc));
        MethodDescriptor objObjToBoolDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(objDesc, objDesc));
        MethodDescriptor classObjObjToBoolDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(classDesc, objDesc, objDesc));
        MethodDescriptor objObjToObjDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of(objDesc, objDesc));
        MethodDescriptor classObjObjToObjDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of(classDesc, objDesc, objDesc));
        MethodDescriptor objToObjDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of(objDesc));
        MethodDescriptor classObjToObjDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of(classDesc, objDesc));
        InstanceIntrinsic identity = (builder, instance, target, arguments) -> instance;
        intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "asArray", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ArrayTypeDescriptor.of((ClassContext)classContext, (TypeDescriptor)objDesc), List.of()), identity);
        InstanceIntrinsic get = (builder, instance, target, arguments) -> builder.load(builder.offsetPointer(instance, (Value)arguments.get(0)), (ReadAccessMode)AccessModes.SingleUnshared);
        intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "get", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of(BaseTypeDescriptor.I)), get);
        InstanceIntrinsic set = (builder, instance, target, arguments) -> {
            builder.store(builder.offsetPointer(instance, (Value)arguments.get(0)), (Value)arguments.get(1), (WriteAccessMode)AccessModes.SingleUnshared);
            return builder.emptyVoid();
        };
        intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "set", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(BaseTypeDescriptor.I, objDesc)), set);
        InstanceIntrinsic plus = (builder, instance, target, arguments) -> builder.offsetPointer(instance, (Value)arguments.get(0));
        intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "plus", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ptrDesc, List.of(BaseTypeDescriptor.I)), plus);
        intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "plus", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ptrDesc, List.of(BaseTypeDescriptor.J)), plus);
        InstanceIntrinsic minus = (builder, instance, target, arguments) -> builder.offsetPointer(instance, builder.negate((Value)arguments.get(0)));
        intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "minus", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ptrDesc, List.of(BaseTypeDescriptor.I)), minus);
        intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "minus", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ptrDesc, List.of(ptrDiffTDesc)), minus);
        intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "minus", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ptrDesc, List.of(sizeTDesc)), minus);
        InstanceIntrinsic ptrPtrMinus = (builder, instance, targetPtr, arguments) -> builder.pointerDifference(instance, (Value)arguments.get(0));
        intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "minus", MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ptrDiffTDesc, List.of(ptrDesc)), ptrPtrMinus);
        Literal zeroVoid = ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)ctxt.getTypeSystem().getVoidType());
        InstanceIntrinsic sel = (builder, instance, target, arguments) -> builder.deref(instance);
        InstanceIntrinsic selWithType = (builder, instance, target, arguments) -> {
            ClassOf classOf;
            Value patt41091$temp;
            Object patt41042$temp = arguments.get(0);
            if (patt41042$temp instanceof ClassOf && (patt41091$temp = (classOf = (ClassOf)patt41042$temp).getInput()) instanceof TypeLiteral) {
                TypeLiteral typeLiteral = (TypeLiteral)patt41091$temp;
                PointerType pt = typeLiteral.getValue().getPointer();
                return builder.deref(builder.bitCast(instance, (WordType)pt));
            }
            ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
            return zeroVoid;
        };
        intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "sel", emptyToObjDesc, sel);
        intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "sel", classToObjDesc, selWithType);
        Map<String, GlobalReadWriteAccessMode> readModeMap = Map.of("Unshared", AccessModes.SingleUnshared, "Plain", AccessModes.SinglePlain, "Opaque", AccessModes.SingleOpaque, "SingleAcquire", AccessModes.SingleAcquire, "SingleRelease", AccessModes.SinglePlain, "Acquire", AccessModes.GlobalAcquire, "Release", AccessModes.GlobalPlain, "", AccessModes.GlobalSeqCst, "Volatile", AccessModes.GlobalSeqCst);
        Map<String, GlobalReadWriteAccessMode> writeModeMap = Map.of("Unshared", AccessModes.SingleUnshared, "Plain", AccessModes.SinglePlain, "Opaque", AccessModes.SingleOpaque, "SingleAcquire", AccessModes.SinglePlain, "SingleRelease", AccessModes.SingleRelease, "Acquire", AccessModes.GlobalPlain, "Release", AccessModes.GlobalRelease, "", AccessModes.GlobalSeqCst, "Volatile", AccessModes.GlobalSeqCst);
        for (String name : List.of("Unshared", "Plain", "Opaque", "SingleAcquire", "Acquire", "Volatile")) {
            mode = (ReadAccessMode)readModeMap.get(name);
            InstanceIntrinsic load = (builder, instance, target, arguments) -> builder.load(instance, mode);
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "load" + name, emptyToObjDesc, load);
            InstanceIntrinsic loadWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt43006$temp;
                Object patt42957$temp = arguments.get(0);
                if (patt42957$temp instanceof ClassOf && (patt43006$temp = (classOf = (ClassOf)patt42957$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt43006$temp;
                    return builder.load(builder.bitCast(instance, (WordType)typeLiteral.getValue().getPointer()), mode);
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "load" + name, classToObjDesc, loadWithType);
        }
        for (String name : List.of("Unshared", "Plain", "Opaque", "SingleRelease", "Release", "Volatile")) {
            mode = (WriteAccessMode)writeModeMap.get(name);
            InstanceIntrinsic store = (arg_0, arg_1, arg_2, arg_3) -> CNativeIntrinsics.lambda$registerPtrIntrinsics$58((WriteAccessMode)mode, zeroVoid, arg_0, arg_1, arg_2, arg_3);
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "store" + name, objToVoidDesc, store);
            InstanceIntrinsic storeWithType = (arg_0, arg_1, arg_2, arg_3) -> CNativeIntrinsics.lambda$registerPtrIntrinsics$59((WriteAccessMode)mode, ctxt, zeroVoid, arg_0, arg_1, arg_2, arg_3);
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "store" + name, classObjToVoidDesc, storeWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            cas = (builder, instance, target, arguments) -> {
                PointerType pt = (PointerType)instance.getType();
                Value res = builder.cmpAndSwap(instance, (Value)arguments.get(0), (Value)arguments.get(1), readMode, writeMode, CmpAndSwap.Strength.STRONG);
                return builder.extractMember(res, CmpAndSwap.getResultType((CompilationContext)ctxt, (ValueType)pt.getPointeeType()).getMember(1));
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "compareAndSet" + name, objObjToBoolDesc, cas);
            casWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt45560$temp;
                Object patt45511$temp = arguments.get(0);
                if (patt45511$temp instanceof ClassOf && (patt45560$temp = (classOf = (ClassOf)patt45511$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt45560$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    Value res = builder.cmpAndSwap(builder.bitCast(instance, (WordType)pt), (Value)arguments.get(1), (Value)arguments.get(2), readMode, writeMode, CmpAndSwap.Strength.STRONG);
                    return builder.extractMember(res, CmpAndSwap.getResultType((CompilationContext)ctxt, (ValueType)pt.getPointeeType()).getMember(1));
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "compareAndSet" + name, classObjObjToBoolDesc, casWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            cas = (builder, instance, target, arguments) -> {
                PointerType pt = (PointerType)instance.getType();
                Value res = builder.cmpAndSwap(instance, (Value)arguments.get(0), (Value)arguments.get(1), readMode, writeMode, CmpAndSwap.Strength.STRONG);
                return builder.extractMember(res, CmpAndSwap.getResultType((CompilationContext)ctxt, (ValueType)pt.getPointeeType()).getMember(0));
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "compareAndSwap" + name, objObjToObjDesc, cas);
            casWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt47267$temp;
                Object patt47218$temp = arguments.get(0);
                if (patt47218$temp instanceof ClassOf && (patt47267$temp = (classOf = (ClassOf)patt47218$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt47267$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    Value res = builder.cmpAndSwap(builder.bitCast(instance, (WordType)pt), (Value)arguments.get(1), (Value)arguments.get(2), readMode, writeMode, CmpAndSwap.Strength.STRONG);
                    return builder.extractMember(res, CmpAndSwap.getResultType((CompilationContext)ctxt, (ValueType)pt.getPointeeType()).getMember(0));
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "compareAndSwap" + name, classObjObjToObjDesc, casWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            cas = (builder, instance, target, arguments) -> {
                PointerType pt = (PointerType)instance.getType();
                Value res = builder.cmpAndSwap(instance, (Value)arguments.get(0), (Value)arguments.get(1), readMode, writeMode, CmpAndSwap.Strength.WEAK);
                return builder.extractMember(res, CmpAndSwap.getResultType((CompilationContext)ctxt, (ValueType)pt.getPointeeType()).getMember(1));
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "weakCompareAndSet" + name, objObjToBoolDesc, cas);
            casWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt48979$temp;
                Object patt48930$temp = arguments.get(0);
                if (patt48930$temp instanceof ClassOf && (patt48979$temp = (classOf = (ClassOf)patt48930$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt48979$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    Value res = builder.cmpAndSwap(builder.bitCast(instance, (WordType)pt), (Value)arguments.get(1), (Value)arguments.get(2), readMode, writeMode, CmpAndSwap.Strength.WEAK);
                    return builder.extractMember(res, CmpAndSwap.getResultType((CompilationContext)ctxt, (ValueType)pt.getPointeeType()).getMember(1));
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "weakCompareAndSet" + name, classObjObjToBoolDesc, casWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            cas = (builder, instance, target, arguments) -> {
                PointerType pt = (PointerType)instance.getType();
                Value res = builder.cmpAndSwap(instance, (Value)arguments.get(0), (Value)arguments.get(1), readMode, writeMode, CmpAndSwap.Strength.WEAK);
                return builder.extractMember(res, CmpAndSwap.getResultType((CompilationContext)ctxt, (ValueType)pt.getPointeeType()).getMember(0));
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "weakCompareAndSwap" + name, objObjToObjDesc, cas);
            casWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt50694$temp;
                Object patt50645$temp = arguments.get(0);
                if (patt50645$temp instanceof ClassOf && (patt50694$temp = (classOf = (ClassOf)patt50645$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt50694$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    Value res = builder.cmpAndSwap(builder.bitCast(instance, (WordType)pt), (Value)arguments.get(1), (Value)arguments.get(2), readMode, writeMode, CmpAndSwap.Strength.WEAK);
                    return builder.extractMember(res, CmpAndSwap.getResultType((CompilationContext)ctxt, (ValueType)pt.getPointeeType()).getMember(0));
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "weakCompareAndSwap" + name, classObjObjToObjDesc, casWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            op = (builder, instance, target, arguments) -> builder.readModifyWrite(instance, ReadModifyWrite.Op.SET, (Value)arguments.get(0), readMode, writeMode);
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndSet" + name, objToObjDesc, op);
            opWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt52141$temp;
                Object patt52092$temp = arguments.get(0);
                if (patt52092$temp instanceof ClassOf && (patt52141$temp = (classOf = (ClassOf)patt52092$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt52141$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    return builder.readModifyWrite(builder.bitCast(instance, (WordType)pt), ReadModifyWrite.Op.SET, (Value)arguments.get(1), readMode, writeMode);
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndSet" + name, classObjToObjDesc, opWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            op = (builder, instance, target, arguments) -> builder.readModifyWrite(instance, ReadModifyWrite.Op.MIN, (Value)arguments.get(0), readMode, writeMode);
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndSetMin" + name, objToObjDesc, op);
            opWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt53440$temp;
                Object patt53391$temp = arguments.get(0);
                if (patt53391$temp instanceof ClassOf && (patt53440$temp = (classOf = (ClassOf)patt53391$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt53440$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    return builder.readModifyWrite(builder.bitCast(instance, (WordType)pt), ReadModifyWrite.Op.MIN, (Value)arguments.get(1), readMode, writeMode);
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndSetMin" + name, classObjToObjDesc, opWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            op = (builder, instance, target, arguments) -> builder.readModifyWrite(instance, ReadModifyWrite.Op.MAX, (Value)arguments.get(0), readMode, writeMode);
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndSetMax" + name, objToObjDesc, op);
            opWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt54742$temp;
                Object patt54693$temp = arguments.get(0);
                if (patt54693$temp instanceof ClassOf && (patt54742$temp = (classOf = (ClassOf)patt54693$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt54742$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    return builder.readModifyWrite(builder.bitCast(instance, (WordType)pt), ReadModifyWrite.Op.MAX, (Value)arguments.get(1), readMode, writeMode);
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndSetMax" + name, classObjToObjDesc, opWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            op = (builder, instance, target, arguments) -> builder.readModifyWrite(instance, ReadModifyWrite.Op.ADD, (Value)arguments.get(0), readMode, writeMode);
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndAdd" + name, objToObjDesc, op);
            opWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt56038$temp;
                Object patt55989$temp = arguments.get(0);
                if (patt55989$temp instanceof ClassOf && (patt56038$temp = (classOf = (ClassOf)patt55989$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt56038$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    return builder.readModifyWrite(builder.bitCast(instance, (WordType)pt), ReadModifyWrite.Op.ADD, (Value)arguments.get(1), readMode, writeMode);
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndAdd" + name, classObjToObjDesc, opWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            op = (builder, instance, target, arguments) -> builder.readModifyWrite(instance, ReadModifyWrite.Op.SUB, (Value)arguments.get(0), readMode, writeMode);
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndSubtract" + name, objToObjDesc, op);
            opWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt57341$temp;
                Object patt57292$temp = arguments.get(0);
                if (patt57292$temp instanceof ClassOf && (patt57341$temp = (classOf = (ClassOf)patt57292$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt57341$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    return builder.readModifyWrite(builder.bitCast(instance, (WordType)pt), ReadModifyWrite.Op.SUB, (Value)arguments.get(1), readMode, writeMode);
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndSubtract" + name, classObjToObjDesc, opWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            op = (builder, instance, target, arguments) -> builder.readModifyWrite(instance, ReadModifyWrite.Op.BITWISE_AND, (Value)arguments.get(0), readMode, writeMode);
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndBitwiseAnd" + name, objToObjDesc, op);
            opWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt58661$temp;
                Object patt58612$temp = arguments.get(0);
                if (patt58612$temp instanceof ClassOf && (patt58661$temp = (classOf = (ClassOf)patt58612$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt58661$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    return builder.readModifyWrite(builder.bitCast(instance, (WordType)pt), ReadModifyWrite.Op.BITWISE_AND, (Value)arguments.get(1), readMode, writeMode);
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndBitwiseAnd" + name, classObjToObjDesc, opWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            op = (builder, instance, target, arguments) -> builder.readModifyWrite(instance, ReadModifyWrite.Op.BITWISE_OR, (Value)arguments.get(0), readMode, writeMode);
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndBitwiseOr" + name, objToObjDesc, op);
            opWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt59988$temp;
                Object patt59939$temp = arguments.get(0);
                if (patt59939$temp instanceof ClassOf && (patt59988$temp = (classOf = (ClassOf)patt59939$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt59988$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    return builder.readModifyWrite(builder.bitCast(instance, (WordType)pt), ReadModifyWrite.Op.BITWISE_OR, (Value)arguments.get(1), readMode, writeMode);
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndBitwiseOr" + name, classObjToObjDesc, opWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            op = (builder, instance, target, arguments) -> builder.readModifyWrite(instance, ReadModifyWrite.Op.BITWISE_XOR, (Value)arguments.get(0), readMode, writeMode);
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndBitwiseXor" + name, objToObjDesc, op);
            opWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt61316$temp;
                Object patt61267$temp = arguments.get(0);
                if (patt61267$temp instanceof ClassOf && (patt61316$temp = (classOf = (ClassOf)patt61267$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt61316$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    return builder.readModifyWrite(builder.bitCast(instance, (WordType)pt), ReadModifyWrite.Op.BITWISE_XOR, (Value)arguments.get(1), readMode, writeMode);
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndBitwiseXor" + name, classObjToObjDesc, opWithType);
        }
        for (String name : List.of("Opaque", "Acquire", "Release", "")) {
            readMode = (ReadAccessMode)readModeMap.get(name);
            writeMode = (WriteAccessMode)writeModeMap.get(name);
            op = (builder, instance, target, arguments) -> builder.readModifyWrite(instance, ReadModifyWrite.Op.BITWISE_NAND, (Value)arguments.get(0), readMode, writeMode);
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndBitwiseNand" + name, objToObjDesc, op);
            opWithType = (builder, instance, target, arguments) -> {
                ClassOf classOf;
                Value patt62649$temp;
                Object patt62600$temp = arguments.get(0);
                if (patt62600$temp instanceof ClassOf && (patt62649$temp = (classOf = (ClassOf)patt62600$temp).getInput()) instanceof TypeLiteral) {
                    TypeLiteral typeLiteral = (TypeLiteral)patt62649$temp;
                    PointerType pt = typeLiteral.getValue().getPointer();
                    return builder.readModifyWrite(builder.bitCast(instance, (WordType)pt), ReadModifyWrite.Op.BITWISE_NAND, (Value)arguments.get(1), readMode, writeMode);
                }
                ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(instance.getType());
            };
            intrinsics.registerIntrinsic((TypeDescriptor)ptrDesc, "getAndBitwiseNand" + name, classObjToObjDesc, opWithType);
        }
    }

    static Value smartConvert(BasicBlockBuilder builder, Value input, WordType toType, boolean cRules) {
        if (input instanceof Dereference) {
            Dereference deref = (Dereference)input;
            return CNativeIntrinsics.smartConvert(builder, builder.load(deref.getPointer(), (ReadAccessMode)AccessModes.SinglePlain), toType, cRules);
        }
        CompilationContext ctxt = builder.getCurrentElement().getEnclosingType().getContext().getCompilationContext();
        ValueType fromType = input.getType();
        if (toType instanceof BooleanType) {
            if (fromType instanceof BooleanType) {
                return input;
            }
            if (cRules) {
                return builder.isNe(input, (Value)ctxt.getLiteralFactory().zeroInitializerLiteralOfType(input.getType()));
            }
            return builder.truncate(input, toType);
        }
        if (toType instanceof IntegerType) {
            if (fromType instanceof IntegerType) {
                IntegerType inputType = (IntegerType)fromType;
                if (toType.getMinBits() > inputType.getMinBits()) {
                    return builder.extend(input, toType);
                }
                if (toType.getMinBits() < inputType.getMinBits()) {
                    return builder.truncate(input, toType);
                }
                return builder.bitCast(input, toType);
            }
            if (fromType instanceof WordType) {
                return builder.valueConvert(input, toType);
            }
            return input;
        }
        if (toType instanceof FloatType) {
            if (fromType instanceof FloatType) {
                FloatType inputType = (FloatType)fromType;
                if (toType.getMinBits() > inputType.getMinBits()) {
                    return builder.extend(input, toType);
                }
                if (toType.getMinBits() < inputType.getMinBits()) {
                    return builder.truncate(input, toType);
                }
                return input;
            }
            if (fromType instanceof WordType) {
                return builder.valueConvert(input, toType);
            }
            return input;
        }
        if (toType instanceof PointerType) {
            if (fromType instanceof PointerType) {
                return builder.bitCast(input, toType);
            }
            if (fromType instanceof WordType) {
                return builder.valueConvert(input, toType);
            }
            return input;
        }
        return builder.valueConvert(input, toType);
    }

    private static /* synthetic */ Value lambda$registerPtrIntrinsics$59(WriteAccessMode mode, CompilationContext ctxt, Literal zeroVoid, BasicBlockBuilder builder, Value instance, InstanceMethodLiteral target, List arguments) {
        ClassOf classOf;
        Value patt44172$temp;
        Object patt44123$temp = arguments.get(0);
        if (patt44123$temp instanceof ClassOf && (patt44172$temp = (classOf = (ClassOf)patt44123$temp).getInput()) instanceof TypeLiteral) {
            TypeLiteral typeLiteral = (TypeLiteral)patt44172$temp;
            builder.store(builder.bitCast(instance, (WordType)typeLiteral.getValue().getPointer()), (Value)arguments.get(1), mode);
        } else {
            ctxt.error(builder.getLocation(), "Pointee argument must be a class literal", new Object[0]);
        }
        return zeroVoid;
    }

    private static /* synthetic */ Value lambda$registerPtrIntrinsics$58(WriteAccessMode mode, Literal zeroVoid, BasicBlockBuilder builder, Value instance, InstanceMethodLiteral target, List arguments) {
        builder.store(instance, (Value)arguments.get(0), mode);
        return zeroVoid;
    }
}

