/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.intrinsics.core;

import java.nio.ByteOrder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.driver.Phase;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.BooleanLiteral;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.NullLiteral;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.graph.literal.StringLiteral;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmString;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.ProgramObject;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.coreclasses.RuntimeMethodFinder;
import org.qbicc.plugin.dispatch.DispatchTables;
import org.qbicc.plugin.gc.nogc.NoGc;
import org.qbicc.plugin.instanceofcheckcast.SupersDisplayTables;
import org.qbicc.plugin.intrinsics.InstanceIntrinsic;
import org.qbicc.plugin.intrinsics.Intrinsics;
import org.qbicc.plugin.intrinsics.StaticIntrinsic;
import org.qbicc.plugin.intrinsics.core.BuildIntrinsics;
import org.qbicc.plugin.intrinsics.core.CNativeIntrinsics;
import org.qbicc.plugin.intrinsics.core.UnsafeIntrinsics;
import org.qbicc.plugin.layout.Layout;
import org.qbicc.plugin.serialization.BuildtimeHeap;
import org.qbicc.pointer.Pointer;
import org.qbicc.pointer.ProgramObjectPointer;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.NullableType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.Primitive;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.GlobalVariableElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class CoreIntrinsics {
    public static final Logger log = Logger.getLogger((String)"org.qbicc.plugin.intrinsics");

    public static void register(CompilationContext ctxt) {
        BuildIntrinsics.register(ctxt);
        CNativeIntrinsics.register(ctxt);
        CoreIntrinsics.registerJavaLangClassIntrinsics(ctxt);
        CoreIntrinsics.registerJavaLangStringUTF16Intrinsics(ctxt);
        CoreIntrinsics.registerJavaLangSystemIntrinsics(ctxt);
        CoreIntrinsics.registerJavaLangStackTraceElementInstrinsics(ctxt);
        CoreIntrinsics.registerJavaLangThreadIntrinsics(ctxt);
        CoreIntrinsics.registerJavaLangNumberIntrinsics(ctxt);
        CoreIntrinsics.registerJavaLangFloatDoubleMathIntrinsics(ctxt);
        CoreIntrinsics.registerJavaLangRefIntrinsics(ctxt);
        CoreIntrinsics.registerOrgQbiccCompilerIntrinsics(ctxt);
        CoreIntrinsics.registerOrgQbiccObjectModelIntrinsics(ctxt);
        CoreIntrinsics.registerOrgQbiccRuntimeBuildIntrinsics(ctxt);
        CoreIntrinsics.registerOrgQbiccRuntimeMainIntrinsics(ctxt);
        CoreIntrinsics.registerJavaLangMathIntrinsics(ctxt);
        CoreIntrinsics.registerJavaLangIntegerIntrinsics(ctxt);
        CoreIntrinsics.registerJavaLangLongIntrinsics(ctxt);
        CoreIntrinsics.registerJavaUtilConcurrentAtomicLongIntrinsics(ctxt);
        UnsafeIntrinsics.register(ctxt);
        CoreIntrinsics.registerJDKInternalIntrinsics(ctxt);
    }

    private static StaticIntrinsic setVolatile(CompilationContext ctxt, StaticFieldElement field) {
        Literal voidLiteral = ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)ctxt.getTypeSystem().getVoidType());
        return (builder, target, arguments) -> {
            builder.store((Value)builder.getLiteralFactory().literalOf(field), (Value)arguments.get(0), (WriteAccessMode)AccessModes.GlobalSeqCst);
            return voidLiteral;
        };
    }

    public static void registerJavaLangClassIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor jlcDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Class");
        ClassTypeDescriptor jlsDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/String");
        ClassTypeDescriptor jloDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
        MethodDescriptor classToBool = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(jlcDesc));
        MethodDescriptor emptyToObjArray = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)ArrayTypeDescriptor.of((ClassContext)classContext, (TypeDescriptor)jloDesc), List.of());
        MethodDescriptor emptyToClass = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)jlcDesc, List.of());
        MethodDescriptor emptyToString = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)jlsDesc, List.of());
        MethodDescriptor emptyToBool = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of());
        MethodDescriptor stringToClass = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)jlcDesc, List.of(jlsDesc));
        StaticIntrinsic desiredAssertionStatus0 = (builder, target, arguments) -> classContext.getLiteralFactory().literalOf(true);
        InstanceIntrinsic desiredAssertionStatus = (builder, instance, target, arguments) -> classContext.getLiteralFactory().literalOf(true);
        InstanceIntrinsic initClassName = (builder, instance, target, arguments) -> {
            throw new BlockEarlyTermination(builder.unreachable());
        };
        StaticIntrinsic getPrimitiveClass = (builder, target, arguments) -> {
            StringLiteral lit = (StringLiteral)arguments.get(0);
            LiteralFactory lf = ctxt.getLiteralFactory();
            TypeSystem ts = ctxt.getTypeSystem();
            ValueType type = Primitive.getPrimitiveFor((String)lit.getValue()).getType();
            return builder.classOf((Value)lf.literalOfType(type), (Value)lf.zeroInitializerLiteralOfType((ValueType)ts.getUnsignedInteger8Type()));
        };
        intrinsics.registerIntrinsic((TypeDescriptor)jlcDesc, "desiredAssertionStatus0", classToBool, desiredAssertionStatus0);
        intrinsics.registerIntrinsic((TypeDescriptor)jlcDesc, "desiredAssertionStatus", emptyToBool, desiredAssertionStatus);
        intrinsics.registerIntrinsic((TypeDescriptor)jlcDesc, "initClassName", emptyToString, initClassName);
        intrinsics.registerIntrinsic((TypeDescriptor)jlcDesc, "getPrimitiveClass", stringToClass, getPrimitiveClass);
        InstanceIntrinsic getEnclosingMethod0 = (builder, instance, target, arguments) -> {
            LiteralFactory lf = ctxt.getLiteralFactory();
            return lf.nullLiteralOfType((NullableType)target.getReturnType());
        };
        intrinsics.registerIntrinsic(Phase.ANALYZE, (TypeDescriptor)jlcDesc, "getEnclosingMethod0", emptyToObjArray, getEnclosingMethod0);
        InstanceIntrinsic getDeclaringClass0 = (builder, instance, target, arguments) -> {
            LiteralFactory lf = ctxt.getLiteralFactory();
            return lf.nullLiteralOfType((NullableType)target.getReturnType());
        };
        intrinsics.registerIntrinsic(Phase.ANALYZE, (TypeDescriptor)jlcDesc, "getDeclaringClass0", emptyToClass, getDeclaringClass0);
    }

    public static void registerJavaLangStringUTF16Intrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor jlsu16Desc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/StringUTF16");
        MethodDescriptor emptyToBool = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of());
        StaticIntrinsic isBigEndian = (builder, target, arguments) -> ctxt.getLiteralFactory().literalOf(ctxt.getTypeSystem().getEndianness() == ByteOrder.BIG_ENDIAN);
        intrinsics.registerIntrinsic((TypeDescriptor)jlsu16Desc, "isBigEndian", emptyToBool, isBigEndian);
    }

    public static void registerJavaLangSystemIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor systemDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/System");
        LoadedTypeDefinition jls = classContext.findDefinedType("java/lang/System").load();
        StaticFieldElement in = jls.findStaticField("in");
        in.setModifierFlags(65536);
        StaticFieldElement out = jls.findStaticField("out");
        out.setModifierFlags(65536);
        StaticFieldElement err = jls.findStaticField("err");
        err.setModifierFlags(65536);
        MethodDescriptor setInputStreamDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/io/InputStream")));
        MethodDescriptor setPrintStreamDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/io/PrintStream")));
        intrinsics.registerIntrinsic((TypeDescriptor)systemDesc, "setIn0", setInputStreamDesc, CoreIntrinsics.setVolatile(ctxt, in));
        intrinsics.registerIntrinsic((TypeDescriptor)systemDesc, "setOut0", setPrintStreamDesc, CoreIntrinsics.setVolatile(ctxt, out));
        intrinsics.registerIntrinsic((TypeDescriptor)systemDesc, "setErr0", setPrintStreamDesc, CoreIntrinsics.setVolatile(ctxt, err));
    }

    public static void registerJavaLangThreadIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        boolean threadAlive = true;
        ClassTypeDescriptor jltDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Thread");
        MethodDescriptor returnJlt = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)jltDesc, List.of());
        MethodDescriptor booleanDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of());
        StaticIntrinsic currentThread = (builder, target, arguments) -> builder.load(builder.currentThread(), (ReadAccessMode)AccessModes.SingleUnshared);
        intrinsics.registerIntrinsic((TypeDescriptor)jltDesc, "currentThread", returnJlt, currentThread);
        InstanceIntrinsic isAlive = (builder, instance, target, arguments) -> {
            Value threadStatusHandle = builder.instanceFieldOf(builder.decodeReference(instance), (TypeDescriptor)jltDesc, "threadStatus", (TypeDescriptor)BaseTypeDescriptor.I);
            Value threadStatus = builder.load(threadStatusHandle, (ReadAccessMode)AccessModes.SingleUnshared);
            IntegerLiteral aliveState = ctxt.getLiteralFactory().literalOf(1);
            Value isThreadAlive = builder.and(threadStatus, (Value)aliveState);
            return builder.isEq(isThreadAlive, (Value)aliveState);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)jltDesc, "isAlive", booleanDesc, isAlive);
    }

    public static void registerJavaLangStackTraceElementInstrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        RuntimeMethodFinder methodFinder = RuntimeMethodFinder.get((CompilationContext)ctxt);
        ClassTypeDescriptor steDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/StackTraceElement");
        ClassTypeDescriptor jltDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Throwable");
        ArrayTypeDescriptor steArrayDesc = ArrayTypeDescriptor.of((ClassContext)classContext, (TypeDescriptor)steDesc);
        MethodDescriptor steArrayThrowableToVoidDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(steArrayDesc, jltDesc));
        MethodElement fillStackTraceElements = methodFinder.getMethod("org/qbicc/runtime/stackwalk/MethodData", "fillStackTraceElements");
        StaticIntrinsic initStackTraceElements = (builder, target, arguments) -> {
            DefinedTypeDefinition jlt = classContext.findDefinedType("java/lang/Throwable");
            LoadedTypeDefinition jltVal = jlt.load();
            InstanceFieldElement backtraceField = jltVal.findInstanceField("backtrace");
            InstanceFieldElement depthField = jltVal.findInstanceField("depth");
            Value backtraceValue = builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(1)), backtraceField), (ReadAccessMode)AccessModes.SingleUnshared);
            Value depthValue = builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(1)), depthField), (ReadAccessMode)AccessModes.SingleUnshared);
            return builder.getFirstBuilder().call((Value)builder.getLiteralFactory().literalOf(fillStackTraceElements), List.of((Value)arguments.get(0), backtraceValue, depthValue));
        };
        intrinsics.registerIntrinsic(Phase.ANALYZE, (TypeDescriptor)steDesc, "initStackTraceElements", steArrayThrowableToVoidDesc, initStackTraceElements);
    }

    public static void registerJavaLangNumberIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor byteDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Byte");
        ClassTypeDescriptor characterDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Character");
        ClassTypeDescriptor integerDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Integer");
        ClassTypeDescriptor longDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Long");
        ClassTypeDescriptor shortDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Short");
        MethodDescriptor binaryByteToIntDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(BaseTypeDescriptor.B, BaseTypeDescriptor.B));
        MethodDescriptor binaryCharToIntDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(BaseTypeDescriptor.C, BaseTypeDescriptor.C));
        MethodDescriptor binaryIntDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(BaseTypeDescriptor.I, BaseTypeDescriptor.I));
        MethodDescriptor binaryLongDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, List.of(BaseTypeDescriptor.J, BaseTypeDescriptor.J));
        MethodDescriptor binaryShortToIntDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(BaseTypeDescriptor.S, BaseTypeDescriptor.S));
        StaticIntrinsic divideUnsigned = (builder, target, arguments) -> builder.divide(CoreIntrinsics.asUnsigned(builder, (Value)arguments.get(0)), CoreIntrinsics.asUnsigned(builder, (Value)arguments.get(1)));
        StaticIntrinsic remainderUnsigned = (builder, target, arguments) -> builder.remainder(CoreIntrinsics.asUnsigned(builder, (Value)arguments.get(0)), CoreIntrinsics.asUnsigned(builder, (Value)arguments.get(1)));
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "divideUnsigned", binaryIntDesc, divideUnsigned);
        intrinsics.registerIntrinsic((TypeDescriptor)longDesc, "divideUnsigned", binaryLongDesc, divideUnsigned);
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "remainderUnsigned", binaryIntDesc, remainderUnsigned);
        intrinsics.registerIntrinsic((TypeDescriptor)longDesc, "remainderUnsigned", binaryLongDesc, remainderUnsigned);
        StaticIntrinsic compare = (builder, target, arguments) -> builder.cmp((Value)arguments.get(0), (Value)arguments.get(1));
        StaticIntrinsic compareUnsigned = (builder, target, arguments) -> builder.cmp(CoreIntrinsics.asUnsigned(builder, (Value)arguments.get(0)), CoreIntrinsics.asUnsigned(builder, (Value)arguments.get(1)));
        intrinsics.registerIntrinsic((TypeDescriptor)byteDesc, "compare", binaryByteToIntDesc, compare);
        intrinsics.registerIntrinsic((TypeDescriptor)byteDesc, "compareUnsigned", binaryByteToIntDesc, compareUnsigned);
        intrinsics.registerIntrinsic((TypeDescriptor)characterDesc, "compare", binaryCharToIntDesc, compare);
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "compare", binaryIntDesc, compare);
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "compareUnsigned", binaryIntDesc, compareUnsigned);
        intrinsics.registerIntrinsic((TypeDescriptor)shortDesc, "compare", binaryShortToIntDesc, compare);
        intrinsics.registerIntrinsic((TypeDescriptor)shortDesc, "compareUnsigned", binaryShortToIntDesc, compareUnsigned);
    }

    private static void registerJavaLangFloatDoubleMathIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        TypeSystem ts = ctxt.getTypeSystem();
        ClassTypeDescriptor floatDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Float");
        ClassTypeDescriptor doubleDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Double");
        MethodDescriptor floatToIntMethodDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(BaseTypeDescriptor.F));
        MethodDescriptor doubleToLongMethodDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, List.of(BaseTypeDescriptor.D));
        StaticIntrinsic floatToRawIntBits = (builder, target, arguments) -> builder.bitCast((Value)arguments.get(0), (WordType)ts.getSignedInteger32Type());
        StaticIntrinsic doubleToRawLongBits = (builder, target, arguments) -> builder.bitCast((Value)arguments.get(0), (WordType)ts.getSignedInteger64Type());
        intrinsics.registerIntrinsic((TypeDescriptor)floatDesc, "floatToRawIntBits", floatToIntMethodDesc, floatToRawIntBits);
        intrinsics.registerIntrinsic((TypeDescriptor)doubleDesc, "doubleToRawLongBits", doubleToLongMethodDesc, doubleToRawLongBits);
        MethodDescriptor intToFloatMethodDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.F, List.of(BaseTypeDescriptor.I));
        MethodDescriptor longToDoubleMethodDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.D, List.of(BaseTypeDescriptor.J));
        StaticIntrinsic intBitsToFloat = (builder, target, arguments) -> builder.bitCast((Value)arguments.get(0), (WordType)ts.getFloat32Type());
        StaticIntrinsic longBitsToDouble = (builder, target, arguments) -> builder.bitCast((Value)arguments.get(0), (WordType)ts.getFloat64Type());
        intrinsics.registerIntrinsic((TypeDescriptor)floatDesc, "intBitsToFloat", intToFloatMethodDesc, intBitsToFloat);
        intrinsics.registerIntrinsic((TypeDescriptor)doubleDesc, "longBitsToDouble", longToDoubleMethodDesc, longBitsToDouble);
    }

    static Value asUnsigned(BasicBlockBuilder builder, Value value) {
        IntegerType type = (IntegerType)value.getType();
        return builder.bitCast(value, (WordType)type.asUnsigned());
    }

    static void registerOrgQbiccCompilerIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        CoreClasses coreClasses = CoreClasses.get((CompilationContext)ctxt);
        ClassTypeDescriptor ciDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/main/CompilerIntrinsics");
        ClassTypeDescriptor objDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
        ClassTypeDescriptor clsDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Class");
        ClassTypeDescriptor strDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/String");
        ClassTypeDescriptor voidUnaryfunctionPtrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$void_ptr_unaryoperator_function_ptr");
        MethodDescriptor nfpDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)voidUnaryfunctionPtrDesc, List.of(strDesc, strDesc));
        StaticIntrinsic nfp = (builder, target, arguments) -> {
            StringLiteral clazz = (StringLiteral)arguments.get(0);
            StringLiteral name = (StringLiteral)arguments.get(1);
            LoadedTypeDefinition ltd = classContext.findDefinedType(clazz.getValue().replace('.', '/')).load();
            PointerType toType = ctxt.getTypeSystem().getFunctionType((ValueType)ctxt.getTypeSystem().getVoidType().getPointer(), List.of(ctxt.getTypeSystem().getVoidType().getPointer())).getPointer();
            try {
                MethodElement me = ltd.requireSingleMethod(name.getValue());
                Value mh = builder.resolveStaticMethod(me.getEnclosingType().getDescriptor(), name.getValue(), me.getDescriptor());
                return builder.bitCast(mh, (WordType)toType);
            }
            catch (IllegalArgumentException e) {
                ctxt.error("CompilerIntrinsics.nativeFunctionPointer: failed to find: %s.%s", new Object[]{clazz.getValue(), name.getValue()});
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)toType);
            }
        };
        intrinsics.registerIntrinsic(Phase.ADD, (TypeDescriptor)ciDesc, "nativeFunctionPointer", nfpDesc, nfp);
        MethodDescriptor newRefArrayDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of(clsDesc, BaseTypeDescriptor.I, BaseTypeDescriptor.I));
        StaticIntrinsic newRefArray = (builder, target, arguments) -> {
            ReferenceArrayObjectType upperBound = classContext.findDefinedType("java/lang/Object").load().getObjectType().getReferenceArrayObject();
            Value typeId = builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), coreClasses.getClassTypeIdField()));
            Value dims = builder.truncate((Value)arguments.get(1), (WordType)coreClasses.getRefArrayDimensionsField().getType());
            return builder.newReferenceArray(upperBound, typeId, dims, (Value)arguments.get(2));
        };
        intrinsics.registerIntrinsic(Phase.ADD, (TypeDescriptor)ciDesc, "emitNewReferenceArray", newRefArrayDesc, newRefArray);
        MethodDescriptor newDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)objDesc, List.of(clsDesc));
        StaticIntrinsic new_ = (builder, target, arguments) -> {
            ClassObjectType upperBound = classContext.findDefinedType("java/lang/Object").load().getClassType();
            Value typeId = builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), coreClasses.getClassTypeIdField()));
            Value instanceSize = builder.extend(builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), coreClasses.getClassInstanceSizeField())), (WordType)ctxt.getTypeSystem().getSignedInteger64Type());
            Value instanceAlign = builder.extend(builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), coreClasses.getClassInstanceAlignField())), (WordType)ctxt.getTypeSystem().getSignedInteger32Type());
            return builder.new_(upperBound, typeId, instanceSize, instanceAlign);
        };
        intrinsics.registerIntrinsic(Phase.ADD, (TypeDescriptor)ciDesc, "emitNew", newDesc, new_);
        MethodDescriptor copyDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(clsDesc, objDesc, objDesc));
        StaticIntrinsic copy = (builder, target, arguments) -> {
            Value cls = (Value)arguments.get(0);
            Value src = (Value)arguments.get(1);
            Value dst = (Value)arguments.get(2);
            Value size32 = builder.load(builder.instanceFieldOf(builder.decodeReference(cls), coreClasses.getClassInstanceSizeField()));
            Value size = builder.extend(size32, (WordType)ctxt.getTypeSystem().getSignedInteger64Type());
            MethodElement method = NoGc.get((CompilationContext)ctxt).getCopyMethod();
            return builder.call((Value)builder.getLiteralFactory().literalOf(method), List.of(dst, src, size));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "copyInstanceFields", copyDesc, copy);
    }

    static void registerOrgQbiccObjectModelIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        CoreClasses coreClasses = CoreClasses.get((CompilationContext)ctxt);
        SupersDisplayTables tables = SupersDisplayTables.get((CompilationContext)ctxt);
        RuntimeMethodFinder methodFinder = RuntimeMethodFinder.get((CompilationContext)ctxt);
        LiteralFactory lf = ctxt.getLiteralFactory();
        ClassTypeDescriptor ciDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/main/CompilerIntrinsics");
        ClassTypeDescriptor typeIdDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$type_id");
        ClassTypeDescriptor objDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
        ClassTypeDescriptor clsDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Class");
        ClassTypeDescriptor jlsDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/String");
        ClassTypeDescriptor uint8Desc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/stdc/Stdint$uint8_t");
        MethodDescriptor objTypeIdDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)typeIdDesc, List.of(objDesc));
        MethodDescriptor objUint8Desc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)uint8Desc, List.of(objDesc));
        MethodDescriptor objIntDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(objDesc));
        MethodDescriptor typeIdTypeIdDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)typeIdDesc, List.of(typeIdDesc));
        MethodDescriptor typeIdBooleanDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(typeIdDesc));
        MethodDescriptor typeIdTypeIdBooleanDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(typeIdDesc, typeIdDesc));
        MethodDescriptor intVoidDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(BaseTypeDescriptor.I));
        MethodDescriptor typeIdClsDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)clsDesc, List.of(typeIdDesc, uint8Desc));
        MethodDescriptor typeIdToClassDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)clsDesc, List.of(typeIdDesc));
        MethodDescriptor clsTypeId = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)typeIdDesc, List.of(clsDesc));
        MethodDescriptor clsUint8 = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)uint8Desc, List.of(clsDesc));
        MethodDescriptor IntDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of());
        MethodDescriptor emptyTotypeIdDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)typeIdDesc, List.of());
        MethodDescriptor typeIdIntToByteDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.B, List.of(typeIdDesc, BaseTypeDescriptor.I));
        MethodDescriptor createClassDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)clsDesc, List.of(jlsDesc, typeIdDesc, uint8Desc, clsDesc));
        MethodDescriptor clsClsDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)clsDesc, List.of(clsDesc));
        MethodDescriptor clsClsBooleanDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(clsDesc, clsDesc));
        StaticIntrinsic typeOf = (builder, target, arguments) -> builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), coreClasses.getObjectTypeIdField()));
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "typeIdOf", objTypeIdDesc, typeOf);
        InstanceFieldElement elementTypeField = coreClasses.getRefArrayElementTypeIdField();
        StaticIntrinsic elementTypeOf = (builder, target, arguments) -> {
            Value handle = builder.decodeReference(builder.bitCast((Value)arguments.get(0), (WordType)elementTypeField.getEnclosingType().load().getObjectType().getReference()));
            return builder.load(builder.instanceFieldOf(handle, elementTypeField));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "elementTypeIdOf", objTypeIdDesc, elementTypeOf);
        InstanceFieldElement dimensionsField = coreClasses.getRefArrayDimensionsField();
        StaticIntrinsic dimensionsOf = (builder, target, arguments) -> {
            Value handle = builder.decodeReference(builder.bitCast((Value)arguments.get(0), (WordType)dimensionsField.getEnclosingType().load().getObjectType().getReference()));
            return builder.load(builder.instanceFieldOf(handle, dimensionsField));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "dimensionsOf", objUint8Desc, dimensionsOf);
        InstanceFieldElement lengthField = coreClasses.getArrayLengthField();
        StaticIntrinsic lengthOf = (builder, target, arguments) -> {
            Value handle = builder.decodeReference(builder.bitCast((Value)arguments.get(0), (WordType)lengthField.getEnclosingType().load().getObjectType().getReference()));
            return builder.load(builder.instanceFieldOf(handle, lengthField));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "lengthOf", objIntDesc, lengthOf);
        StaticIntrinsic maxSubClassId = (builder, target, arguments) -> {
            GlobalVariableElement typeIdGlobal = tables.getAndRegisterGlobalTypeIdArray(builder.getCurrentElement());
            Value typeIdStruct = builder.elementOf((Value)builder.getLiteralFactory().literalOf(typeIdGlobal), (Value)arguments.get(0));
            return builder.load(builder.memberOf(typeIdStruct, tables.getGlobalTypeIdStructType().getMember("maxSubTypeId")));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "maxSubClassTypeIdOf", typeIdTypeIdDesc, maxSubClassId);
        StaticIntrinsic isObject = (builder, target, arguments) -> {
            LoadedTypeDefinition jlo = classContext.findDefinedType("java/lang/Object").load();
            return builder.isEq((Value)arguments.get(0), (Value)lf.literalOfType((ValueType)jlo.getObjectType()));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "isJavaLangObject", typeIdBooleanDesc, isObject);
        StaticIntrinsic isCloneable = (builder, target, arguments) -> {
            LoadedTypeDefinition jlc = classContext.findDefinedType("java/lang/Cloneable").load();
            return builder.isEq((Value)arguments.get(0), (Value)lf.literalOfType((ValueType)jlc.getObjectType()));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "isJavaLangCloneable", typeIdBooleanDesc, isCloneable);
        StaticIntrinsic isSerializable = (builder, target, arguments) -> {
            LoadedTypeDefinition jis = classContext.findDefinedType("java/io/Serializable").load();
            return builder.isEq((Value)arguments.get(0), (Value)lf.literalOfType((ValueType)jis.getObjectType()));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "isJavaIoSerializable", typeIdBooleanDesc, isSerializable);
        StaticIntrinsic isClass = (builder, target, arguments) -> {
            LoadedTypeDefinition jlo = classContext.findDefinedType("java/lang/Object").load();
            ObjectType refArray = coreClasses.getArrayLoadedTypeDefinition("[ref").getObjectType();
            Value isObj = builder.isEq((Value)arguments.get(0), (Value)lf.literalOfType((ValueType)jlo.getObjectType()));
            Value isAboveRef = builder.isLt((Value)lf.literalOfType((ValueType)refArray), (Value)arguments.get(0));
            Value isNotInterface = builder.isLt((Value)arguments.get(0), (Value)lf.literalOf(ctxt.getTypeSystem().getTypeIdLiteralType(), (long)tables.getFirstInterfaceTypeId()));
            return builder.or(isObj, builder.and(isAboveRef, isNotInterface));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "isClass", typeIdBooleanDesc, isClass);
        StaticIntrinsic isInterface = (builder, target, arguments) -> builder.isLe((Value)lf.literalOf(ctxt.getTypeSystem().getTypeIdLiteralType(), (long)tables.getFirstInterfaceTypeId()), (Value)arguments.get(0));
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "isInterface", typeIdBooleanDesc, isInterface);
        StaticIntrinsic isPrimArray = (builder, target, arguments) -> {
            ObjectType firstPrimArray = coreClasses.getArrayLoadedTypeDefinition("[Z").getObjectType();
            ObjectType lastPrimArray = coreClasses.getArrayLoadedTypeDefinition("[D").getObjectType();
            return builder.and(builder.isGe((Value)arguments.get(0), (Value)lf.literalOfType((ValueType)firstPrimArray)), builder.isLe((Value)arguments.get(0), (Value)lf.literalOfType((ValueType)lastPrimArray)));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "isPrimArray", typeIdBooleanDesc, isPrimArray);
        StaticIntrinsic isPrimitive = (builder, target, arguments) -> {
            ValueType firstPrimType = Primitive.VOID.getType();
            ValueType lastPrimType = Primitive.DOUBLE.getType();
            return builder.and(builder.isGe((Value)arguments.get(0), (Value)lf.literalOfType(firstPrimType)), builder.isLe((Value)arguments.get(0), (Value)lf.literalOfType(lastPrimType)));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "isPrimitive", typeIdBooleanDesc, isPrimitive);
        StaticIntrinsic isRefArray = (builder, target, arguments) -> {
            ObjectType refArray = coreClasses.getArrayLoadedTypeDefinition("[ref").getObjectType();
            return builder.isEq((Value)arguments.get(0), (Value)lf.literalOfType((ValueType)refArray));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "isReferenceArray", typeIdBooleanDesc, isRefArray);
        StaticIntrinsic getRefArrayTypeId = (builder, target, arguments) -> ctxt.getLiteralFactory().literalOf(ctxt.getTypeSystem().getTypeIdLiteralType(), (long)coreClasses.getRefArrayContentField().getEnclosingType().load().getTypeId());
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "getReferenceArrayTypeId", emptyTotypeIdDesc, getRefArrayTypeId);
        StaticIntrinsic doesImplement = (builder, target, arguments) -> {
            IntegerType typeIdLiteralType = ctxt.getTypeSystem().getTypeIdLiteralType();
            Value objTypeId = (Value)arguments.get(0);
            Value interfaceTypeId = (Value)arguments.get(1);
            GlobalVariableElement typeIdGlobal = tables.getAndRegisterGlobalTypeIdArray(builder.getCurrentElement());
            Value typeIdStruct = builder.elementOf((Value)builder.getLiteralFactory().literalOf(typeIdGlobal), objTypeId);
            Value bits = builder.memberOf(typeIdStruct, tables.getGlobalTypeIdStructType().getMember("interfaceBits"));
            Value adjustedInterfaceTypeId = builder.sub(interfaceTypeId, (Value)lf.literalOf(typeIdLiteralType, (long)tables.getFirstInterfaceTypeId()));
            Value implementsIdx = builder.shr(builder.bitCast(adjustedInterfaceTypeId, (WordType)typeIdLiteralType.asUnsigned()), (Value)lf.literalOf(typeIdLiteralType, 3L));
            Value implementsBit = builder.and(adjustedInterfaceTypeId, (Value)lf.literalOf(typeIdLiteralType, 7L));
            Value dataByte = builder.load(builder.elementOf(bits, builder.extend(implementsIdx, (WordType)ctxt.getTypeSystem().getSignedInteger32Type())));
            Value mask = builder.truncate(builder.shl((Value)lf.literalOf(typeIdLiteralType, 1L), implementsBit), (WordType)ctxt.getTypeSystem().getSignedInteger8Type());
            return builder.isEq(mask, builder.and(mask, dataByte));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "doesImplement", typeIdTypeIdBooleanDesc, doesImplement);
        StaticIntrinsic getDimFromClass = (builder, target, arguments) -> builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), coreClasses.getClassDimensionField()));
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "getDimensionsFromClass", clsUint8, getDimFromClass);
        StaticIntrinsic getTypeIdFromClass = (builder, target, arguments) -> builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), coreClasses.getClassTypeIdField()));
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "getTypeIdFromClass", clsTypeId, getTypeIdFromClass);
        MethodElement getOrCreateArrayClass = methodFinder.getMethod("getOrCreateClassForRefArray");
        ReferenceType jlcRef = ctxt.getBootstrapClassContext().findDefinedType("java/lang/Class").load().getObjectType().getReference();
        StaticIntrinsic getClassFromTypeId = (builder, target, arguments) -> {
            Value componentClass;
            Value typeId = (Value)arguments.get(0);
            Value dims = (Value)arguments.get(1);
            BlockLabel trueBranch = new BlockLabel();
            BlockLabel fallThrough = new BlockLabel();
            BuildtimeHeap buildtimeHeap = BuildtimeHeap.get((CompilationContext)ctxt);
            ProgramObject rootArray = buildtimeHeap.getAndRegisterGlobalClassArray(builder.getCurrentElement());
            Literal base = lf.literalOf((Pointer)ProgramObjectPointer.of((ProgramObject)rootArray));
            Value elem = builder.elementOf((Value)base, (Value)arguments.get(0));
            Value result = componentClass = builder.valueConvert(elem, (WordType)jlcRef);
            builder.if_(builder.isGt(dims, (Value)ctxt.getLiteralFactory().literalOf(0)), trueBranch, fallThrough, Map.of(Slot.temp((int)0), result));
            builder.begin(trueBranch);
            result = builder.getFirstBuilder().call((Value)lf.literalOf(getOrCreateArrayClass), List.of(componentClass, dims));
            builder.goto_(fallThrough, Slot.temp((int)0), result);
            builder.begin(fallThrough);
            return builder.addParam(fallThrough, Slot.temp((int)0), result.getType());
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "getClassFromTypeId", typeIdClsDesc, getClassFromTypeId);
        StaticIntrinsic getClassFromTypeIdSimple = (builder, target, arguments) -> {
            BuildtimeHeap buildtimeHeap = BuildtimeHeap.get((CompilationContext)ctxt);
            ProgramObject rootArray = buildtimeHeap.getAndRegisterGlobalClassArray(builder.getCurrentElement());
            Literal base = lf.literalOf((Pointer)ProgramObjectPointer.of((ProgramObject)rootArray));
            Value elem = builder.elementOf((Value)base, (Value)arguments.get(0));
            return builder.valueConvert(elem, (WordType)jlcRef);
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "getClassFromTypeIdSimple", typeIdToClassDesc, getClassFromTypeIdSimple);
        StaticIntrinsic getArrayClassOf = (builder, target, arguments) -> builder.load(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), CoreClasses.get((CompilationContext)ctxt).getArrayClassField()));
        intrinsics.registerIntrinsic((TypeDescriptor)ciDesc, "getArrayClassOf", clsClsDesc, getArrayClassOf);
        StaticIntrinsic setArrayClass = (builder, target, arguments) -> {
            LoadedTypeDefinition jlc = classContext.findDefinedType("java/lang/Class").load();
            ReferenceType refType = jlc.getObjectType().getReference();
            NullLiteral expect = ctxt.getLiteralFactory().nullLiteralOfType((NullableType)refType);
            Value update = (Value)arguments.get(1);
            Value result = builder.cmpAndSwap(builder.instanceFieldOf(builder.decodeReference((Value)arguments.get(0)), CoreClasses.get((CompilationContext)ctxt).getArrayClassField()), (Value)expect, update, (ReadAccessMode)AccessModes.GlobalAcquire, (WriteAccessMode)AccessModes.GlobalRelease, CmpAndSwap.Strength.STRONG);
            return builder.extractMember(result, CmpAndSwap.getResultType((CompilationContext)ctxt, (ValueType)refType).getMember(1));
        };
        intrinsics.registerIntrinsic((TypeDescriptor)ciDesc, "setArrayClass", clsClsBooleanDesc, setArrayClass);
        InstanceFieldElement jlcName = classContext.findDefinedType("java/lang/Class").load().findInstanceField("name");
        InstanceFieldElement jlcCompType = classContext.findDefinedType("java/lang/Class").load().findInstanceField("componentType");
        StaticIntrinsic createClass = (builder, target, arguments) -> {
            ClassObjectType jlcType = (ClassObjectType)ctxt.getBootstrapClassContext().findDefinedType("java/lang/Class").load().getObjectType();
            CompoundType compoundType = Layout.get((CompilationContext)ctxt).getInstanceLayoutInfo(jlcType.getDefinition()).getCompoundType();
            Value instance = builder.new_(jlcType, (Value)lf.literalOfType((ValueType)jlcType), (Value)lf.literalOf(compoundType.getSize()), (Value)lf.literalOf(compoundType.getAlign()));
            Value handle = builder.instanceFieldOf(builder.decodeReference(instance), jlcName);
            builder.store(handle, (Value)arguments.get(0), handle.getDetectedMode().getWriteAccess());
            handle = builder.instanceFieldOf(builder.decodeReference(instance), CoreClasses.get((CompilationContext)ctxt).getClassTypeIdField());
            builder.store(handle, (Value)arguments.get(1), handle.getDetectedMode().getWriteAccess());
            handle = builder.instanceFieldOf(builder.decodeReference(instance), CoreClasses.get((CompilationContext)ctxt).getClassDimensionField());
            builder.store(handle, (Value)arguments.get(2), handle.getDetectedMode().getWriteAccess());
            handle = builder.instanceFieldOf(builder.decodeReference(instance), jlcCompType);
            builder.store(handle, (Value)arguments.get(3), handle.getDetectedMode().getWriteAccess());
            return instance;
        };
        intrinsics.registerIntrinsic(Phase.ADD, (TypeDescriptor)ciDesc, "createClass", createClassDesc, createClass);
        StaticIntrinsic getNumberOfTypeIds = (builder, target, arguments) -> lf.literalOf(ctxt.getTypeSystem().getTypeIdLiteralType(), (long)tables.get_number_of_typeids());
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "getNumberOfTypeIds", emptyTotypeIdDesc, getNumberOfTypeIds);
        StaticIntrinsic callRuntimeInitializer = (builder, target, arguments) -> {
            Value index = (Value)arguments.get(0);
            GlobalVariableElement rtinitTable = DispatchTables.get((CompilationContext)ctxt).getRTInitsGlobal();
            ProgramModule programModule = ctxt.getOrAddProgramModule(builder.getCurrentElement().getEnclosingType());
            programModule.declareData(null, rtinitTable.getName(), rtinitTable.getType());
            Value initFunc = builder.load(builder.elementOf((Value)builder.getLiteralFactory().literalOf(rtinitTable), index));
            return builder.call(initFunc, List.of(builder.load(builder.currentThread(), (ReadAccessMode)AccessModes.SingleUnshared)));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "callRuntimeInitializer", intVoidDesc, callRuntimeInitializer);
        StaticIntrinsic getSuperClassTypeId = (builder, target, arguments) -> {
            Value typeId = (Value)arguments.get(0);
            GlobalVariableElement typeIdGlobal = tables.getAndRegisterGlobalTypeIdArray(builder.getCurrentElement());
            Value typeIdStruct = builder.elementOf((Value)builder.getLiteralFactory().literalOf(typeIdGlobal), typeId);
            Value superTypeId = builder.memberOf(typeIdStruct, tables.getGlobalTypeIdStructType().getMember("superTypeId"));
            return builder.load(superTypeId);
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "getSuperClassTypeId", typeIdTypeIdDesc, getSuperClassTypeId);
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "getFirstInterfaceTypeid", emptyTotypeIdDesc, (builder, target, arguments) -> lf.literalOf(ctxt.getTypeSystem().getTypeIdLiteralType(), (long)tables.getFirstInterfaceTypeId()));
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "getNumberOfBytesInInterfaceBitsArray", IntDesc, (builder, target, arguments) -> lf.literalOf(tables.getNumberOfBytesInInterfaceBitsArray()));
        StaticIntrinsic getByteOfInterfaceBits = (builder, target, arguments) -> {
            Value typeId = (Value)arguments.get(0);
            Value index = (Value)arguments.get(1);
            GlobalVariableElement typeIdGlobal = tables.getAndRegisterGlobalTypeIdArray(builder.getCurrentElement());
            Value typeIdStruct = builder.elementOf((Value)builder.getLiteralFactory().literalOf(typeIdGlobal), typeId);
            Value bits = builder.memberOf(typeIdStruct, tables.getGlobalTypeIdStructType().getMember("interfaceBits"));
            return builder.load(builder.elementOf(bits, index));
        };
        intrinsics.registerIntrinsic(Phase.LOWER, (TypeDescriptor)ciDesc, "getByteOfInterfaceBits", typeIdIntToByteDesc, getByteOfInterfaceBits);
    }

    static void registerOrgQbiccRuntimeBuildIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor buildDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/Build");
        MethodDescriptor emptyToBool = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of());
        BooleanLiteral falseLit = classContext.getLiteralFactory().literalOf(false);
        BooleanLiteral trueLit = classContext.getLiteralFactory().literalOf(true);
        StaticIntrinsic isHost = (builder, target, arguments) -> falseLit;
        StaticIntrinsic isTarget = (builder, target, arguments) -> trueLit;
        intrinsics.registerIntrinsic(Phase.ANALYZE, (TypeDescriptor)buildDesc, "isHost", emptyToBool, isHost);
        intrinsics.registerIntrinsic(Phase.ANALYZE, (TypeDescriptor)buildDesc, "isTarget", emptyToBool, isTarget);
    }

    static void registerOrgQbiccRuntimeMainIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor mainDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"jdk/internal/org/qbicc/runtime/Main");
        ClassTypeDescriptor tgDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/ThreadGroup");
        MethodDescriptor voidVoidDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of());
        StaticIntrinsic sysThrGrp = (builder, target, arguments) -> ctxt.getLiteralFactory().literalOf(ctxt.getVm().getMainThreadGroup());
        MethodDescriptor returnTgDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)tgDesc, List.of());
        intrinsics.registerIntrinsic((TypeDescriptor)mainDesc, "getSystemThreadGroup", returnTgDesc, sysThrGrp);
    }

    public static void registerJavaLangMathIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor mathDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Math");
        ClassTypeDescriptor strictDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/StrictMath");
        MethodDescriptor intIntIntDescriptor = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, Collections.nCopies(2, BaseTypeDescriptor.I));
        MethodDescriptor longLongLongDescriptor = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, Collections.nCopies(2, BaseTypeDescriptor.J));
        MethodDescriptor floatFloatFloatDescriptor = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.F, Collections.nCopies(2, BaseTypeDescriptor.F));
        MethodDescriptor doubleDoubleDoubleDescriptor = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.D, Collections.nCopies(2, BaseTypeDescriptor.D));
        StaticIntrinsic min = (builder, target, arguments) -> builder.min((Value)arguments.get(0), (Value)arguments.get(1));
        StaticIntrinsic max = (builder, target, arguments) -> builder.max((Value)arguments.get(0), (Value)arguments.get(1));
        intrinsics.registerIntrinsic((TypeDescriptor)mathDesc, "min", intIntIntDescriptor, min);
        intrinsics.registerIntrinsic((TypeDescriptor)mathDesc, "min", longLongLongDescriptor, min);
        intrinsics.registerIntrinsic((TypeDescriptor)mathDesc, "min", floatFloatFloatDescriptor, min);
        intrinsics.registerIntrinsic((TypeDescriptor)mathDesc, "min", doubleDoubleDoubleDescriptor, min);
        intrinsics.registerIntrinsic((TypeDescriptor)mathDesc, "max", intIntIntDescriptor, max);
        intrinsics.registerIntrinsic((TypeDescriptor)mathDesc, "max", longLongLongDescriptor, max);
        intrinsics.registerIntrinsic((TypeDescriptor)mathDesc, "max", floatFloatFloatDescriptor, max);
        intrinsics.registerIntrinsic((TypeDescriptor)mathDesc, "max", doubleDoubleDoubleDescriptor, max);
        intrinsics.registerIntrinsic((TypeDescriptor)strictDesc, "min", intIntIntDescriptor, min);
        intrinsics.registerIntrinsic((TypeDescriptor)strictDesc, "min", longLongLongDescriptor, min);
        intrinsics.registerIntrinsic((TypeDescriptor)strictDesc, "min", floatFloatFloatDescriptor, min);
        intrinsics.registerIntrinsic((TypeDescriptor)strictDesc, "min", doubleDoubleDoubleDescriptor, min);
        intrinsics.registerIntrinsic((TypeDescriptor)strictDesc, "max", intIntIntDescriptor, max);
        intrinsics.registerIntrinsic((TypeDescriptor)strictDesc, "max", longLongLongDescriptor, max);
        intrinsics.registerIntrinsic((TypeDescriptor)strictDesc, "max", floatFloatFloatDescriptor, max);
        intrinsics.registerIntrinsic((TypeDescriptor)strictDesc, "max", doubleDoubleDoubleDescriptor, max);
    }

    private static void registerJavaLangIntegerIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor integerDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Integer");
        MethodDescriptor intToInt = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(BaseTypeDescriptor.I));
        MethodDescriptor intIntToInt = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(BaseTypeDescriptor.I, BaseTypeDescriptor.I));
        MethodDescriptor intToLong = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, List.of(BaseTypeDescriptor.I));
        StaticIntrinsic compare = (builder, targetPtr, arguments) -> builder.cmp((Value)arguments.get(0), (Value)arguments.get(1));
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "compare", intIntToInt, compare);
        StaticIntrinsic compareUnsigned = (builder, targetPtr, arguments) -> {
            TypeSystem ts = builder.getTypeSystem();
            Value a = (Value)arguments.get(0);
            Value b = (Value)arguments.get(1);
            UnsignedIntegerType u32 = ts.getUnsignedInteger32Type();
            return builder.cmp(builder.bitCast(a, (WordType)u32), builder.bitCast(b, (WordType)u32));
        };
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "compareUnsigned", intIntToInt, compareUnsigned);
        StaticIntrinsic divideUnsigned = (builder, targetPtr, arguments) -> {
            TypeSystem ts = builder.getTypeSystem();
            Value a = (Value)arguments.get(0);
            Value b = (Value)arguments.get(1);
            UnsignedIntegerType u32 = ts.getUnsignedInteger32Type();
            SignedIntegerType s32 = ts.getSignedInteger32Type();
            return builder.bitCast(builder.divide(builder.bitCast(a, (WordType)u32), builder.divisorCheck(builder.bitCast(b, (WordType)u32))), (WordType)s32);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "divideUnsigned", intIntToInt, divideUnsigned);
        StaticIntrinsic remainderUnsigned = (builder, targetPtr, arguments) -> {
            TypeSystem ts = builder.getTypeSystem();
            Value a = (Value)arguments.get(0);
            Value b = (Value)arguments.get(1);
            UnsignedIntegerType u32 = ts.getUnsignedInteger32Type();
            SignedIntegerType s32 = ts.getSignedInteger32Type();
            return builder.bitCast(builder.remainder(builder.bitCast(a, (WordType)u32), builder.divisorCheck(builder.bitCast(b, (WordType)u32))), (WordType)s32);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "remainderUnsigned", intIntToInt, remainderUnsigned);
        StaticIntrinsic toUnsignedLong = (builder, targetPtr, arguments) -> {
            TypeSystem ts = builder.getTypeSystem();
            UnsignedIntegerType u32 = ts.getUnsignedInteger32Type();
            UnsignedIntegerType u64 = ts.getUnsignedInteger64Type();
            SignedIntegerType s64 = ts.getSignedInteger64Type();
            return builder.bitCast(builder.extend(builder.bitCast((Value)arguments.get(0), (WordType)u32), (WordType)u64), (WordType)s64);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "toUnsignedLong", intToLong, toUnsignedLong);
        StaticIntrinsic numberOfTrailingZeros = (builder, targetPtr, arguments) -> builder.countTrailingZeros((Value)arguments.get(0));
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "numberOfTrailingZeros", intToInt, numberOfTrailingZeros);
        StaticIntrinsic numberOfLeadingZeros = (builder, targetPtr, arguments) -> builder.countLeadingZeros((Value)arguments.get(0));
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "numberOfLeadingZeros", intToInt, numberOfLeadingZeros);
        StaticIntrinsic highestOneBit = (builder, targetPtr, arguments) -> {
            LiteralFactory lf = builder.getLiteralFactory();
            TypeSystem ts = builder.getTypeSystem();
            UnsignedIntegerType u32 = ts.getUnsignedInteger32Type();
            SignedIntegerType s32 = ts.getSignedInteger32Type();
            IntegerLiteral bit = lf.literalOf((IntegerType)u32, Integer.MIN_VALUE);
            return builder.and((Value)arguments.get(0), builder.bitCast(builder.shr((Value)bit, builder.bitCast(builder.countLeadingZeros((Value)arguments.get(0)), (WordType)u32)), (WordType)s32));
        };
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "highestOneBit", intToInt, highestOneBit);
        StaticIntrinsic lowestOneBit = (builder, targetPtr, arguments) -> builder.and((Value)arguments.get(0), builder.negate((Value)arguments.get(0)));
        intrinsics.registerIntrinsic((TypeDescriptor)integerDesc, "lowestOneBit", intToInt, lowestOneBit);
    }

    private static void registerJavaLangLongIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor longDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Long");
        MethodDescriptor longLongToInt = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(BaseTypeDescriptor.J, BaseTypeDescriptor.J));
        MethodDescriptor longLongToLong = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, List.of(BaseTypeDescriptor.J, BaseTypeDescriptor.J));
        StaticIntrinsic compare = (builder, targetPtr, arguments) -> builder.cmp((Value)arguments.get(0), (Value)arguments.get(1));
        intrinsics.registerIntrinsic((TypeDescriptor)longDesc, "compare", longLongToInt, compare);
        StaticIntrinsic compareUnsigned = (builder, targetPtr, arguments) -> {
            TypeSystem ts = builder.getTypeSystem();
            Value a = (Value)arguments.get(0);
            Value b = (Value)arguments.get(1);
            UnsignedIntegerType u64 = ts.getUnsignedInteger64Type();
            return builder.cmp(builder.bitCast(a, (WordType)u64), builder.bitCast(b, (WordType)u64));
        };
        intrinsics.registerIntrinsic((TypeDescriptor)longDesc, "compareUnsigned", longLongToInt, compareUnsigned);
        StaticIntrinsic divideUnsigned = (builder, targetPtr, arguments) -> {
            TypeSystem ts = builder.getTypeSystem();
            Value a = (Value)arguments.get(0);
            Value b = (Value)arguments.get(1);
            UnsignedIntegerType u64 = ts.getUnsignedInteger64Type();
            SignedIntegerType s64 = ts.getSignedInteger64Type();
            return builder.bitCast(builder.divide(builder.bitCast(a, (WordType)u64), builder.divisorCheck(builder.bitCast(b, (WordType)u64))), (WordType)s64);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)longDesc, "divideUnsigned", longLongToLong, divideUnsigned);
        StaticIntrinsic remainderUnsigned = (builder, targetPtr, arguments) -> {
            TypeSystem ts = builder.getTypeSystem();
            Value a = (Value)arguments.get(0);
            Value b = (Value)arguments.get(1);
            UnsignedIntegerType u64 = ts.getUnsignedInteger64Type();
            SignedIntegerType s64 = ts.getSignedInteger64Type();
            return builder.bitCast(builder.remainder(builder.bitCast(a, (WordType)u64), builder.divisorCheck(builder.bitCast(b, (WordType)u64))), (WordType)s64);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)longDesc, "remainderUnsigned", longLongToLong, remainderUnsigned);
    }

    private static void registerJavaLangRefIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor objDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
        ClassTypeDescriptor referenceDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/ref/Reference");
        ClassTypeDescriptor phantomReferenceDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/ref/PhantomReference");
        MethodDescriptor objToBool = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(objDesc));
        MethodDescriptor objToVoid = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(objDesc));
        InstanceIntrinsic refersTo0 = (builder, instance, target, arguments) -> builder.isEq((Value)arguments.get(0), builder.load(builder.instanceFieldOf(builder.decodeReference(instance), (TypeDescriptor)referenceDesc, "referent", (TypeDescriptor)objDesc)));
        intrinsics.registerIntrinsic(Phase.ADD, (TypeDescriptor)referenceDesc, "refersTo0", objToBool, refersTo0);
        intrinsics.registerIntrinsic(Phase.ADD, (TypeDescriptor)phantomReferenceDesc, "refersTo0", objToBool, refersTo0);
        StaticIntrinsic reachabilityFence = (builder, target, arguments) -> {
            builder.reachable((Value)arguments.get(0));
            ClassContext context = builder.getCurrentElement().getEnclosingType().getContext();
            TypeSystem ts = context.getTypeSystem();
            LiteralFactory lf = context.getLiteralFactory();
            return lf.zeroInitializerLiteralOfType((ValueType)ts.getVoidType());
        };
        intrinsics.registerIntrinsic(Phase.ADD, (TypeDescriptor)referenceDesc, "reachabilityFence", objToVoid, reachabilityFence);
    }

    private static void registerJavaUtilConcurrentAtomicLongIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor atomicLongDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/util/concurrent/atomic/AtomicLong");
        MethodDescriptor emptyToBool = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of());
        StaticIntrinsic VMSupportsCS8 = (builder, target, arguments) -> ctxt.getLiteralFactory().literalOf(true);
        intrinsics.registerIntrinsic((TypeDescriptor)atomicLongDesc, "VMSupportsCS8", emptyToBool, VMSupportsCS8);
    }

    private static void registerJDKInternalIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor jlc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Class");
        ClassTypeDescriptor jls = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/String");
        ClassTypeDescriptor jlo = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
        ClassTypeDescriptor classloader = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/ClassLoader");
        ClassTypeDescriptor reflect = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"jdk/internal/reflect/Reflection");
        MethodDescriptor boolStringObj = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(jls, jlo));
        MethodDescriptor intClass = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(jlc));
        InstanceIntrinsic trySetObjectField = (builder, input, target, arguments) -> {
            VmObject vmObject;
            Value string = (Value)arguments.get(0);
            Value newValue = (Value)arguments.get(1);
            LiteralFactory lf = ctxt.getLiteralFactory();
            String fieldName = null;
            if (string instanceof StringLiteral) {
                fieldName = ((StringLiteral)string).getValue();
            } else if (string instanceof ObjectLiteral && (vmObject = ((ObjectLiteral)string).getValue()) instanceof VmString) {
                fieldName = ((VmString)vmObject).getContent();
            }
            if (fieldName == null) {
                ctxt.error(builder.getLocation(), "trySetObjectField string argument must be a literal string", new Object[0]);
                return lf.literalOf(false);
            }
            LoadedTypeDefinition ltd = ctxt.getBootstrapClassContext().findDefinedType("java/lang/ClassLoader").load();
            InstanceFieldElement field = ltd.findInstanceField(fieldName);
            if (field == null) {
                ctxt.error(builder.getLocation(), "No such field \"%s\" on class \"%s\"", new Object[]{fieldName, ltd.getVmClass().getName()});
                return lf.literalOf(false);
            }
            ValueType expectType = newValue.getType();
            Value result = builder.cmpAndSwap(builder.instanceFieldOf(builder.decodeReference(input), field), (Value)lf.zeroInitializerLiteralOfType(expectType), newValue, (ReadAccessMode)AccessModes.GlobalSeqCst, (WriteAccessMode)AccessModes.SingleOpaque, CmpAndSwap.Strength.STRONG);
            return builder.extractMember(result, CmpAndSwap.getResultType((CompilationContext)ctxt, (ValueType)expectType).getMember(1));
        };
        intrinsics.registerIntrinsic((TypeDescriptor)classloader, "trySetObjectField", boolStringObj, trySetObjectField);
        InstanceFieldElement modField = ctxt.getBootstrapClassContext().findDefinedType("java/lang/Class").load().findInstanceField("modifiers");
        StaticIntrinsic getClassAccessFlags = (builder, input, arguments) -> {
            Value cls = (Value)arguments.get(0);
            return builder.and(builder.load(builder.instanceFieldOf(builder.decodeReference(cls), modField)), (Value)ctxt.getLiteralFactory().literalOf(8191));
        };
        intrinsics.registerIntrinsic(Phase.ANALYZE, (TypeDescriptor)reflect, "getClassAccessFlags", intClass, getClassAccessFlags);
    }
}

