/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.layout;

import io.smallrye.common.constraint.Assert;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.layout.LayoutInfo;
import org.qbicc.type.ArrayType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.TypeUtil;
import org.qbicc.type.ValueType;
import org.qbicc.type.VariadicType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.FieldElement;

public final class Layout {
    private static final AttachmentKey<Layout> KEY = new AttachmentKey();
    private final Map<LoadedTypeDefinition, LayoutInfo> instanceLayouts = new ConcurrentHashMap<LoadedTypeDefinition, LayoutInfo>();
    private final Map<LoadedTypeDefinition, LayoutInfo> staticLayouts = new ConcurrentHashMap<LoadedTypeDefinition, LayoutInfo>();
    private final Map<ObjectType, LayoutInfo> arrayLayouts = new ConcurrentHashMap<ObjectType, LayoutInfo>();
    private final CompilationContext ctxt;
    static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();

    private Layout(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static Layout get(CompilationContext ctxt) {
        Layout appearing;
        Layout layout = (Layout)ctxt.getAttachment(KEY);
        if (layout == null && (appearing = (Layout)ctxt.putAttachmentIfAbsent(KEY, (Object)(layout = new Layout(ctxt)))) != null) {
            layout = appearing;
        }
        return layout;
    }

    public LayoutInfo getArrayLayoutInfo(DefinedTypeDefinition arrayClass, ObjectType elementType) {
        ArrayType at;
        LayoutInfo layoutInfo = this.arrayLayouts.get(elementType);
        if (layoutInfo != null) {
            return layoutInfo;
        }
        LayoutInfo protoInfo = this.getInstanceLayoutInfo(arrayClass);
        CompoundType protoCompound = protoInfo.getCompoundType();
        int memberCount = protoCompound.getMemberCount();
        if (memberCount < 1) {
            throw new IllegalArgumentException();
        }
        CompoundType.Member lastMember = protoCompound.getMember(memberCount - 1);
        ValueType valueType = lastMember.getType();
        if (valueType instanceof ArrayType && (at = (ArrayType)valueType).getElementCount() == 0L && at.getElementType() instanceof ReferenceType) {
            CompoundType.Member newLastMember;
            CompoundType.Member[] newMembers = (CompoundType.Member[])protoCompound.getMembers().toArray(CompoundType.Member[]::new);
            TypeSystem ts = this.ctxt.getTypeSystem();
            newMembers[memberCount - 1] = newLastMember = ts.getCompoundTypeMember(lastMember.getName(), (ValueType)ts.getArrayType((ValueType)elementType.getReference(), 0L), lastMember.getOffset(), lastMember.getAlign());
            CompoundType newType = ts.getCompoundType(CompoundType.Tag.CLASS, elementType.getReferenceArrayObject().toFriendlyString(), protoCompound.getSize(), protoCompound.getAlign(), () -> List.of(newMembers));
            HashMap<FieldElement, CompoundType.Member> newMapping = new HashMap<FieldElement, CompoundType.Member>(protoInfo.getFieldsMap());
            newMapping.replaceAll((fe, m) -> m == lastMember ? newLastMember : m);
            layoutInfo = new LayoutInfo(protoInfo.getAllocatedBits(), newType, newMapping);
            LayoutInfo appearing = this.arrayLayouts.putIfAbsent(elementType, layoutInfo);
            return appearing != null ? appearing : layoutInfo;
        }
        throw new IllegalArgumentException();
    }

    public LayoutInfo getInstanceLayoutInfo(DefinedTypeDefinition type) {
        CompoundType compoundType;
        LayoutInfo appearing;
        int size;
        int minAlignment;
        LayoutInfo superLayout;
        if (type.isInterface()) {
            throw new IllegalArgumentException("Interfaces have no instance layout");
        }
        LoadedTypeDefinition validated = type.load();
        LayoutInfo layoutInfo = this.instanceLayouts.get(validated);
        if (layoutInfo != null) {
            return layoutInfo;
        }
        LoadedTypeDefinition superClass = validated.getSuperClass();
        if (superClass != null) {
            superLayout = this.getInstanceLayoutInfo((DefinedTypeDefinition)superClass);
            minAlignment = superLayout.getCompoundType().getAlign();
        } else {
            superLayout = null;
            minAlignment = this.ctxt.getTypeSystem().getPointerAlignment();
        }
        BitSet allocated = new BitSet();
        if (superLayout != null) {
            allocated.or(superLayout.getAllocatedBits());
        }
        int cnt = validated.getFieldCount();
        HashMap<FieldElement, CompoundType.Member> fieldToMember = superLayout == null ? new HashMap<FieldElement, CompoundType.Member>(cnt) : new HashMap<FieldElement, CompoundType.Member>(superLayout.getFieldsMap());
        FieldElement trailingArray = null;
        for (int i = 0; i < cnt; ++i) {
            FieldElement field = validated.getField(i);
            if (field.isStatic() || !field.getType().isComplete()) continue;
            if (field.getType().getSize() == 0L) {
                Assert.assertTrue((trailingArray == null ? 1 : 0) != 0);
                trailingArray = field;
                continue;
            }
            CompoundType.Member member = this.computeMember(allocated, field);
            if (member.getAlign() > minAlignment) {
                minAlignment = member.getAlign();
            }
            fieldToMember.put(field, member);
            field.setOffset((long)member.getOffset());
        }
        if (trailingArray != null) {
            CompoundType.Member member = this.computeMember(allocated, trailingArray);
            if (member.getAlign() > minAlignment) {
                minAlignment = member.getAlign();
            }
            fieldToMember.put(trailingArray, member);
            trailingArray.setOffset((long)member.getOffset());
            size = member.getOffset();
        } else {
            size = allocated.length();
        }
        Object[] membersArray = (CompoundType.Member[])fieldToMember.values().toArray(CompoundType.Member[]::new);
        Arrays.sort(membersArray);
        List<Object> membersList = List.of(membersArray);
        Object name = type.getInternalName().replace('/', '.');
        if (type.isHidden()) {
            name = (String)name + "/" + ENCODER.encodeToString(type.getDigest()) + "." + type.getHiddenClassIndex();
        }
        return (appearing = this.instanceLayouts.putIfAbsent(validated, layoutInfo = new LayoutInfo(allocated, compoundType = this.ctxt.getTypeSystem().getCompoundType(CompoundType.Tag.CLASS, (String)name, (long)size, minAlignment, () -> membersList), fieldToMember))) != null ? appearing : layoutInfo;
    }

    public LayoutInfo getStaticLayoutInfo(DefinedTypeDefinition type) {
        LoadedTypeDefinition loaded = type.load();
        LayoutInfo layoutInfo = this.staticLayouts.get(loaded);
        if (layoutInfo != null) {
            return layoutInfo;
        }
        int cnt = loaded.getFieldCount();
        if (cnt == 0) {
            return null;
        }
        BitSet allocated = new BitSet();
        HashMap<FieldElement, CompoundType.Member> fieldToMember = new HashMap<FieldElement, CompoundType.Member>(cnt);
        TypeSystem ts = this.ctxt.getTypeSystem();
        int minAlignment = ts.getPointerAlignment();
        for (int i = 0; i < cnt; ++i) {
            FieldElement field = loaded.getField(i);
            if (!field.isStatic() || field.isThreadLocal() || field.getType() instanceof VariadicType) continue;
            CompoundType.Member member = this.computeMember(allocated, field);
            if (member.getAlign() > minAlignment) {
                minAlignment = member.getAlign();
            }
            fieldToMember.put(field, member);
            field.setOffset((long)member.getOffset());
        }
        int size = allocated.length();
        Object[] membersArray = (CompoundType.Member[])fieldToMember.values().toArray(CompoundType.Member[]::new);
        Arrays.sort(membersArray);
        List<Object> membersList = List.of(membersArray);
        CompoundType compoundType = ts.getCompoundType(CompoundType.Tag.STRUCT, "statics." + type.getInternalName().replace('/', '.'), (long)size, minAlignment, () -> membersList);
        layoutInfo = new LayoutInfo(allocated, compoundType, fieldToMember);
        LayoutInfo appearing = this.staticLayouts.putIfAbsent(loaded, layoutInfo);
        return appearing != null ? appearing : layoutInfo;
    }

    private ValueType widenBoolean(ValueType type) {
        if (type instanceof BooleanType) {
            return this.ctxt.getTypeSystem().getUnsignedInteger8Type();
        }
        if (type instanceof ArrayType) {
            ValueType widened;
            ArrayType arrayType = (ArrayType)type;
            ValueType elementType = arrayType.getElementType();
            return elementType == (widened = this.widenBoolean(elementType)) ? type : this.ctxt.getTypeSystem().getArrayType(widened, arrayType.getElementCount());
        }
        return type;
    }

    private CompoundType.Member computeMember(BitSet allocated, FieldElement field) {
        int idx;
        int align;
        TypeSystem ts = this.ctxt.getTypeSystem();
        ValueType fieldType = this.widenBoolean(field.getType());
        int size = (int)fieldType.getSize();
        if (size != 0) {
            align = Math.max(field.getMinimumAlignment(), fieldType.getAlign());
            idx = this.find(allocated, align, size);
            allocated.set(idx, idx + size);
        } else if (fieldType instanceof ArrayType) {
            ArrayType at = (ArrayType)fieldType;
            align = Math.max(field.getMinimumAlignment(), at.getElementType().getAlign());
            idx = (int)TypeUtil.alignUp((long)allocated.length(), (int)align);
        } else {
            throw new IllegalStateException("Invalid zero-sized member");
        }
        return ts.getCompoundTypeMember(field.getName(), fieldType, idx, align);
    }

    private int find(BitSet bitSet, int alignment, int size) {
        assert (Integer.bitCount(alignment) == 1);
        int mask = alignment - 1;
        int i = bitSet.nextClearBit(0);
        while (true) {
            int amt = mask - (i - 1 & mask);
            while (amt > 0) {
                i = bitSet.nextClearBit(i + amt);
                amt = mask - (i - 1 & mask);
            }
            int n = bitSet.nextSetBit(i);
            if (n == -1 || n - i >= size) {
                return i;
            }
            i = bitSet.nextClearBit(n);
        }
    }
}

